/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.GlassPane;
import com.dlsc.gemsfx.ResizableTextArea;
import com.dlsc.gemsfx.util.FocusUtil;
import com.dlsc.gemsfx.util.ResizingBehaviour;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.prefs.Preferences;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.RotateTransition;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.skin.ButtonBarSkin;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import net.synedra.validatorfx.Validator;
import org.apache.commons.lang3.StringUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class DialogPane
extends Pane {
    private static final String MESSAGE_LABEL_STYLE_CLASS = "message-label";
    private final GlassPane glassPane;
    private final ObservableList<ContentPane> dialogContentPanes = FXCollections.observableArrayList();
    private final Map<ContentPane, DoubleProperty> dialogVisibilityMap = new HashMap<ContentPane, DoubleProperty>();
    private final EventHandler<KeyEvent> escapeHandler = evt -> {
        ObservableList<Dialog<?>> dialogs;
        if (KeyCombination.keyCombination((String)"ESC+SHIFT").match(evt)) {
            this.hideAllDialogs();
        } else if (evt.getCode() == KeyCode.ESCAPE && !(dialogs = this.getDialogs()).isEmpty()) {
            Dialog dialog = (Dialog)dialogs.get(dialogs.size() - 1);
            dialog.cancel();
            evt.consume();
        }
    };
    private final WeakEventHandler<KeyEvent> weakEscapeHandler = new WeakEventHandler(this.escapeHandler);
    private final ObjectProperty<Callback<Dialog<?>, Node>> headerFactory = new SimpleObjectProperty((Object)this, "headerFactory");
    private final ObjectProperty<Callback<Dialog<?>, Node>> footerFactory = new SimpleObjectProperty((Object)this, "footerFactory");
    private final ListProperty<Dialog<?>> dialogs = new SimpleListProperty((Object)this, "dialogs", FXCollections.observableArrayList());
    private final ObjectProperty<Duration> animationDuration = new SimpleObjectProperty((Object)this, "animationDuration", (Object)Duration.millis((double)100.0));
    private final ObjectProperty<Supplier<Label>> labelSupplier = new SimpleObjectProperty((Object)this, "labelSupplier", Label::new);
    private final BooleanProperty animateDialogs = new SimpleBooleanProperty((Object)this, "animateDialogs", true);
    private final BooleanProperty fadeInOut = new SimpleBooleanProperty((Object)this, "fadeInOut", true);
    private final ReadOnlyBooleanWrapper showingDialog = new ReadOnlyBooleanWrapper((Object)this, "showingDialog", false);
    private final DoubleProperty maximizedPadding = new SimpleDoubleProperty((Object)this, "dialogPadding", 20.0);
    private final ObjectProperty<StringConverter<ButtonType>> converter = new SimpleObjectProperty((Object)this, "converter", (Object)new StringConverter<ButtonType>(){

        public String toString(ButtonType buttonType) {
            if (buttonType != null) {
                return buttonType.getText();
            }
            return "";
        }

        public ButtonType fromString(String string) {
            return null;
        }
    });

    public DialogPane() {
        this.getStyleClass().add((Object)"dialog-pane");
        this.setHeaderFactory(DialogHeader::new);
        this.setFooterFactory(DialogButtonBar::new);
        this.showingDialog.bind((ObservableValue)this.dialogs.emptyProperty().not());
        this.mouseTransparentProperty().bind((ObservableValue)this.showingDialogProperty().not());
        this.visibleProperty().bind((ObservableValue)this.dialogsProperty().emptyProperty().not());
        this.managedProperty().bind((ObservableValue)this.dialogsProperty().emptyProperty().not());
        this.glassPane = new GlassPane();
        this.glassPane.fadeInOutProperty().bind((ObservableValue)this.fadeInOutProperty());
        this.glassPane.fadeInOutDurationProperty().bind(this.animationDurationProperty());
        this.glassPane.hideProperty().bind((ObservableValue)this.dialogs.emptyProperty());
        this.dialogs.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(dialog -> {
                        ContentPane contentPane = new ContentPane((Dialog<?>)dialog);
                        contentPane.blockedProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.dialogContentPanes.isEmpty() && this.dialogContentPanes.get(this.dialogContentPanes.size() - 1) != contentPane, (Observable[])new Observable[]{this.dialogContentPanes}));
                        this.dialogContentPanes.add((Object)contentPane);
                        SimpleDoubleProperty visibility = new SimpleDoubleProperty();
                        visibility.addListener(it -> this.requestLayout());
                        this.dialogVisibilityMap.put(contentPane, (DoubleProperty)visibility);
                        this.slideInOut(1.0, (DoubleProperty)visibility, () -> contentPane);
                    });
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(dialog -> {
                    Optional<ContentPane> dialogOptional = this.dialogContentPanes.stream().filter(d -> d.getDialog() == dialog).findFirst();
                    if (dialogOptional.isPresent()) {
                        ContentPane dialogPane = dialogOptional.get();
                        DoubleProperty visibility = this.dialogVisibilityMap.get((Object)dialogPane);
                        this.slideInOut(0.0, visibility, () -> dialogPane);
                    }
                });
            }
        });
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)clip);
        this.getChildren().add((Object)this.glassPane);
        this.sceneProperty().addListener((obs, oldScene, newScene) -> {
            if (oldScene != null) {
                oldScene.removeEventFilter(KeyEvent.KEY_PRESSED, this.weakEscapeHandler);
            }
            if (newScene != null) {
                newScene.addEventFilter(KeyEvent.KEY_PRESSED, this.weakEscapeHandler);
            }
        });
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(DialogPane.class.getResource("dialog-pane.css")).toExternalForm();
    }

    public final GlassPane getGlassPane() {
        return this.glassPane;
    }

    public final Callback<Dialog<?>, Node> getHeaderFactory() {
        return (Callback)this.headerFactory.get();
    }

    public final ObjectProperty<Callback<Dialog<?>, Node>> headerFactoryProperty() {
        return this.headerFactory;
    }

    public final void setHeaderFactory(Callback<Dialog<?>, Node> headerFactory) {
        this.headerFactory.set(headerFactory);
    }

    public final Callback<Dialog<?>, Node> getFooterFactory() {
        return (Callback)this.footerFactory.get();
    }

    public final ObjectProperty<Callback<Dialog<?>, Node>> footerFactoryProperty() {
        return this.footerFactory;
    }

    public final void setFooterFactory(Callback<Dialog<?>, Node> footerFactory) {
        this.footerFactory.set(footerFactory);
    }

    public final ObservableList<Dialog<?>> getDialogs() {
        return (ObservableList)this.dialogs.get();
    }

    public final ListProperty<Dialog<?>> dialogsProperty() {
        return this.dialogs;
    }

    public final void setDialogs(ObservableList<Dialog<?>> dialogs) {
        this.dialogs.set(dialogs);
    }

    public final Duration getAnimationDuration() {
        return (Duration)this.animationDuration.get();
    }

    public final ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(Duration animationDuration) {
        this.animationDuration.set((Object)animationDuration);
    }

    public void showDialog(Dialog<?> dialog) {
        if (dialog.getDialogPane() != this) {
            throw new IllegalArgumentException("the given dialog does not belong to this dialog pane");
        }
        this.dialogs.add(dialog);
    }

    public void hideDialog(Dialog<?> dialog) {
        if (!this.dialogs.contains(dialog)) {
            throw new IllegalArgumentException("the given dialog does not belong to this dialog pane");
        }
        this.dialogs.remove(dialog);
    }

    public void hideAllDialogs() {
        ArrayList list = new ArrayList((Collection<Dialog<?>>)this.getDialogs());
        for (int i = list.size() - 1; i >= 0; --i) {
            this.hideDialog((Dialog)list.get(i));
        }
    }

    private Dialog<ButtonType> doShowDialog(Type type, String title, String message) {
        return this.doShowDialog(type, title, message, Collections.emptyList());
    }

    private Dialog<ButtonType> doShowDialog(Type type, String title, String message, List<ButtonType> buttons) {
        Label messageLabel = this.getLabelSupplier().get();
        messageLabel.setText(message);
        messageLabel.setWrapText(true);
        if (!messageLabel.getStyleClass().contains((Object)MESSAGE_LABEL_STYLE_CLASS)) {
            messageLabel.getStyleClass().add((Object)MESSAGE_LABEL_STYLE_CLASS);
        }
        return this.showNode(type, title, (Node)messageLabel, buttons);
    }

    public final Dialog<Void> showError(String title, String message) {
        return this.showError(title, message, (String)null);
    }

    public final Dialog<Void> showError(String title, String message, Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return this.showError(title, message, stringWriter.toString());
    }

    public final Dialog<Void> showError(String title, Exception exception) {
        return this.showError(title, exception.getMessage(), exception);
    }

    public final Dialog<Void> showError(String title, String message, String details) {
        Dialog<Void> dialog = new Dialog<Void>(this, Type.ERROR);
        dialog.setTitle(title);
        Label messageLabel = this.getLabelSupplier().get();
        messageLabel.setText(message);
        messageLabel.setWrapText(true);
        if (!messageLabel.getStyleClass().contains((Object)MESSAGE_LABEL_STYLE_CLASS)) {
            messageLabel.getStyleClass().add((Object)MESSAGE_LABEL_STYLE_CLASS);
        }
        if (StringUtils.isBlank((CharSequence)details)) {
            dialog.setContent((Node)messageLabel);
        } else {
            ResizableTextArea textArea = new ResizableTextArea();
            textArea.setText(details);
            textArea.setWrapText(false);
            textArea.setPrefColumnCount(80);
            textArea.setResizeHorizontal(true);
            textArea.setResizeVertical(true);
            textArea.getStyleClass().add((Object)"error-text-area");
            TitledPane titledPane = new TitledPane();
            titledPane.getStyleClass().add((Object)"error-details-titled-pane");
            titledPane.setText("Details");
            titledPane.setContent((Node)textArea);
            titledPane.setPrefHeight(300.0);
            VBox content = new VBox(new Node[]{messageLabel, titledPane});
            content.getStyleClass().add((Object)"container");
            dialog.setContent((Node)content);
            FocusUtil.requestFocus((Node)textArea);
        }
        dialog.show();
        return dialog;
    }

    public final Dialog<ButtonType> showWarning(String title, String message) {
        return this.showWarning(title, message, Collections.emptyList());
    }

    public final Dialog<ButtonType> showWarning(String title, String message, List<ButtonType> buttonTypes) {
        return this.doShowDialog(Type.WARNING, title, message, buttonTypes);
    }

    public final Dialog<ButtonType> showConfirmation(String title, String message) {
        return this.showConfirmation(title, message, Collections.emptyList());
    }

    public final Dialog<ButtonType> showConfirmation(String title, String message, List<ButtonType> buttonTypes) {
        return this.doShowDialog(Type.CONFIRMATION, title, message, buttonTypes);
    }

    public final Dialog<ButtonType> showInformation(String title, String message) {
        return this.showInformation(title, message, Collections.emptyList());
    }

    public final Dialog<ButtonType> showInformation(String title, String message, List<ButtonType> buttons) {
        return this.doShowDialog(Type.INFORMATION, title, message, buttons);
    }

    public final Dialog<String> showTextInput(String title, String text) {
        return this.showTextInput(title, null, null, text, false);
    }

    public final Dialog<String> showTextInput(String title, String text, boolean multiline) {
        return this.showTextInput(title, null, null, text, multiline);
    }

    public final Dialog<String> showTextInput(String title, String message, String text, boolean multiline) {
        return this.showTextInput(title, message, null, text, multiline);
    }

    public final Dialog<String> showTextInput(String title, String message, String prompt, String text, boolean multiline) {
        return this.showTextInput(title, message, prompt, text, multiline, Collections.emptyList());
    }

    public final Dialog<String> showTextInput(String title, String message, String prompt, String text, boolean multiline, List<ButtonType> buttonTypes) {
        Object textInputControl;
        if (multiline) {
            ResizableTextArea textArea = new ResizableTextArea(text);
            textArea.setPromptText(prompt);
            textArea.setWrapText(true);
            textArea.setPrefRowCount(6);
            textArea.setResizeVertical(true);
            textArea.setResizeHorizontal(true);
            textInputControl = textArea;
        } else {
            TextField textField = new TextField(text);
            textField.setPromptText(prompt);
            textField.setPrefColumnCount(20);
            textInputControl = textField;
        }
        FocusUtil.requestFocus((Node)textInputControl);
        VBox box = new VBox();
        box.getStyleClass().add((Object)"prompt-node-wrapper");
        if (StringUtils.isNotBlank((CharSequence)message)) {
            Label promptLabel = this.getLabelSupplier().get();
            promptLabel.getStyleClass().add((Object)"prompt-label");
            promptLabel.setText(message);
            if (!promptLabel.getStyleClass().contains((Object)MESSAGE_LABEL_STYLE_CLASS)) {
                promptLabel.getStyleClass().add((Object)MESSAGE_LABEL_STYLE_CLASS);
            }
            box.getChildren().add((Object)promptLabel);
        }
        box.getChildren().add(textInputControl);
        Dialog<String> dialog = this.showNode(Type.INPUT, title, (Node)box);
        dialog.valueProperty().bindBidirectional((Property)textInputControl.textProperty());
        if (buttonTypes != null && !buttonTypes.isEmpty()) {
            dialog.getButtonTypes().setAll(buttonTypes);
        }
        dialog.getValidator().createCheck().dependsOn("text", (ObservableValue)textInputControl.textProperty()).decorates((Node)textInputControl).immediateClear().withMethod(ctx -> {
            String str;
            if (dialog.isRequired() && StringUtils.isBlank((CharSequence)(str = (String)ctx.get("text")))) {
                ctx.error("Missing text.");
            }
        });
        return dialog;
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node) {
        return this.showNode(type, title, node, false, Collections.emptyList());
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node, boolean maximize) {
        return this.showNode(type, title, node, maximize, Collections.emptyList());
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node, List<ButtonType> buttons) {
        return this.showNode(type, title, node, false, buttons);
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node, boolean maximize, List<ButtonType> buttons) {
        return this.showNode(type, title, node, maximize, buttons, true, null);
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node, boolean maximize, List<ButtonType> buttons, boolean sameWidthButtons) {
        return this.showNode(type, title, node, maximize, buttons, sameWidthButtons, null);
    }

    public final <T> Dialog<T> showNode(Type type, String title, Node node, boolean maximize, List<ButtonType> buttons, boolean sameWidthButtons, BooleanProperty validProperty) {
        Dialog dialog = new Dialog(this, type);
        dialog.setTitle(title);
        dialog.setContent(node);
        dialog.setMaximize(maximize);
        dialog.setSameWidthButtons(sameWidthButtons);
        if (buttons != null && !buttons.isEmpty()) {
            dialog.getButtonTypes().setAll(buttons);
        }
        if (validProperty != null) {
            dialog.validProperty().bind((ObservableValue)validProperty);
        }
        dialog.show();
        return dialog;
    }

    public final Dialog<Void> showBusyIndicator() {
        BusyIndicator busyIndicator = new BusyIndicator();
        busyIndicator.sceneProperty().addListener(it -> {
            if (busyIndicator.getScene() != null) {
                busyIndicator.start();
            } else {
                busyIndicator.stop();
            }
        });
        Dialog<Void> dialog = new Dialog<Void>(this, Type.BLANK);
        dialog.getStyleClass().add((Object)"busy-dialog");
        dialog.setContent((Node)busyIndicator);
        dialog.getButtonTypes().clear();
        dialog.setDelay(Duration.millis((double)1000.0));
        dialog.setUsingPadding(true);
        dialog.show();
        return dialog;
    }

    public final Supplier<Label> getLabelSupplier() {
        return (Supplier)this.labelSupplier.get();
    }

    public final ObjectProperty<Supplier<Label>> labelSupplierProperty() {
        return this.labelSupplier;
    }

    public final void setLabelSupplier(Supplier<Label> labelSupplier) {
        this.labelSupplier.set(labelSupplier);
    }

    public final BooleanProperty animateDialogsProperty() {
        return this.animateDialogs;
    }

    public final boolean isAnimateDialogs() {
        return this.animateDialogs.get();
    }

    public final void setAnimateDialogs(boolean animate) {
        this.animateDialogs.set(animate);
    }

    public final BooleanProperty fadeInOutProperty() {
        return this.fadeInOut;
    }

    public final boolean isFadeInOut() {
        return this.fadeInOut.get();
    }

    public final void setFadeInOut(boolean animate) {
        this.fadeInOut.set(animate);
    }

    public final ReadOnlyBooleanProperty showingDialogProperty() {
        return this.showingDialog.getReadOnlyProperty();
    }

    public final boolean isShowingDialog() {
        return this.showingDialog.get();
    }

    private void slideInOut(double visibility, DoubleProperty visibilityProperty, Supplier<Node> nodeSupplier) {
        Node node = nodeSupplier.get();
        if (!this.getAnimationDuration().equals((Object)Duration.ZERO) && this.isAnimateDialogs()) {
            if (visibility == 1.0) {
                this.ensureNodeInChildrenList(node);
                node.setVisible(true);
                node.setOpacity(0.0);
            } else {
                node.setOpacity(1.0);
            }
            KeyValue value1 = new KeyValue((WritableValue)visibilityProperty, (Object)visibility);
            KeyValue value2 = new KeyValue((WritableValue)node.opacityProperty(), (Object)(visibility == 0.0 ? 0 : 1));
            KeyFrame frame = new KeyFrame(this.getAnimationDuration(), new KeyValue[]{value1, value2});
            Timeline timeline = new Timeline(new KeyFrame[]{frame});
            timeline.setOnFinished(evt -> {
                if (visibility == 0.0) {
                    node.setVisible(false);
                    this.getChildren().remove((Object)node);
                    if (node instanceof ContentPane) {
                        this.dialogContentPanes.remove((Object)node);
                        this.dialogVisibilityMap.remove(node);
                    }
                }
            });
            timeline.play();
        } else if (visibility == 1.0) {
            this.ensureNodeInChildrenList(node);
            node.setVisible(true);
            node.setOpacity(1.0);
            visibilityProperty.set(1.0);
        } else {
            node.setOpacity(0.0);
            visibilityProperty.set(0.0);
            this.getChildren().remove((Object)node);
            if (node instanceof ContentPane) {
                this.dialogContentPanes.remove((Object)node);
                this.dialogVisibilityMap.remove(node);
            }
        }
    }

    private void ensureNodeInChildrenList(Node node) {
        if (!this.getChildren().contains((Object)node)) {
            this.getChildren().add((Object)node);
        }
    }

    public final double getMaximizedPadding() {
        return this.maximizedPadding.get();
    }

    public final DoubleProperty maximizedPaddingProperty() {
        return this.maximizedPadding;
    }

    public final void setMaximizedPadding(double maximizedPadding) {
        this.maximizedPadding.set(maximizedPadding);
    }

    protected void layoutChildren() {
        Insets insets = this.getInsets();
        double contentY = insets.getTop();
        double contentX = insets.getLeft();
        double contentWidth = this.getWidth() - insets.getLeft() - insets.getRight();
        double contentHeight = this.getHeight() - insets.getTop() - insets.getBottom();
        for (ContentPane contentPane : this.dialogContentPanes) {
            double dialogWidth = Math.min(contentPane.maxWidth(contentHeight), Math.max(contentPane.minWidth(contentHeight), contentPane.prefWidth(contentHeight)));
            double dialogHeight = Math.min(contentPane.maxHeight(contentWidth), Math.max(contentPane.minHeight(contentWidth), contentPane.prefHeight(contentWidth)));
            Dialog<?> dialog = contentPane.getDialog();
            double maxWidth = contentWidth - 2.0 * this.getMaximizedPadding();
            double maxHeight = contentHeight - 2.0 * this.getMaximizedPadding();
            if (dialog.isMaximize()) {
                dialogWidth = maxWidth;
                dialogHeight = maxHeight;
            } else {
                dialogWidth = Math.min(dialogWidth, maxWidth);
                dialogHeight = Math.min(dialogHeight, maxHeight);
            }
            double dialogTargetY = contentY + (contentHeight - dialogHeight) / 2.0;
            DoubleProperty dialogVisibility = this.dialogVisibilityMap.get((Object)contentPane);
            if (dialogVisibility == null) continue;
            contentPane.resizeRelocate(contentX + (contentWidth - dialogWidth) / 2.0, dialogTargetY * dialogVisibility.get(), dialogWidth, dialogHeight);
        }
        if (this.glassPane.isVisible()) {
            this.glassPane.resizeRelocate(contentX, contentY, contentWidth, contentHeight);
        }
    }

    public final StringConverter<ButtonType> getConverter() {
        return (StringConverter)this.converter.get();
    }

    public final ObjectProperty<StringConverter<ButtonType>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<ButtonType> converter) {
        this.converter.set(converter);
    }

    public static class Dialog<T> {
        private final Type type;
        private final DialogPane pane;
        private final StringProperty id = new SimpleStringProperty((Object)this, "id");
        private final ObjectProperty<Preferences> preferences = new SimpleObjectProperty((Object)this, "preferences");
        private final DoubleProperty prefWidth = new SimpleDoubleProperty((Object)this, "prefWidth", -1.0);
        private final DoubleProperty prefHeight = new SimpleDoubleProperty((Object)this, "prefHeight", -1.0);
        private final DoubleProperty minWidth = new SimpleDoubleProperty((Object)this, "minWidth", -1.0);
        private final DoubleProperty minHeight = new SimpleDoubleProperty((Object)this, "minHeight", -1.0);
        private final DoubleProperty maxWidth = new SimpleDoubleProperty((Object)this, "maxWidth", -1.0);
        private final DoubleProperty maxHeight = new SimpleDoubleProperty((Object)this, "maxHeight", -1.0);
        private final ObjectProperty<BiConsumer<Double, Double>> onResize = new SimpleObjectProperty((Object)this, "onResize");
        private final BooleanProperty required = new SimpleBooleanProperty((Object)this, "required", false);
        private final BooleanProperty showCloseButton = new SimpleBooleanProperty((Object)this, "showCloseButton", true);
        private final ObjectProperty<Duration> delay = new SimpleObjectProperty((Object)this, "delay", (Object)Duration.ZERO);
        private final BooleanProperty usingPadding = new SimpleBooleanProperty((Object)this, "usingPadding", true);
        private final ObjectProperty<Pos> contentAlignment = new SimpleObjectProperty((Object)this, "contentAlignment", (Object)Pos.CENTER_LEFT);
        private final ObjectProperty<T> value = new SimpleObjectProperty((Object)this, "value");
        private Consumer<ButtonType> onButtonPressed;
        private final ObjectProperty<Consumer<ButtonType>> onClose = new SimpleObjectProperty((Object)this, "onClose", buttonType -> {});
        private final BooleanProperty valid = new SimpleBooleanProperty((Object)this, "valid", true);
        private final ObservableList<ButtonType> buttonTypes = FXCollections.observableArrayList();
        private final BooleanProperty sameWidthButtons = new SimpleBooleanProperty(true);
        private final BooleanProperty maximize = new SimpleBooleanProperty();
        private final ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content");
        private final ObjectProperty<Node> extras = new SimpleObjectProperty((Object)this, "extras");
        private final StringProperty title = new SimpleStringProperty((Object)this, "title", "Dialog");
        private final ObservableList<String> styleClass = FXCollections.observableArrayList();
        private final BooleanProperty showHeader = new SimpleBooleanProperty((Object)this, "showHeader", true);
        private final BooleanProperty showFooter = new SimpleBooleanProperty((Object)this, "showFooter", true);
        private final Map<ButtonType, Button> buttonMap = new HashMap<ButtonType, Button>();
        private final ObjectProperty<Validator> validator = new SimpleObjectProperty((Object)this, "validator", (Object)new Validator());
        private final BooleanProperty resizable = new SimpleBooleanProperty((Object)this, "resizable");

        public Dialog(DialogPane pane, Type type) {
            this.pane = Objects.requireNonNull(pane, "dialog pane can not be null");
            this.type = Objects.requireNonNull(type, "dialog type can not be null");
            this.getStyleClass().add((Object)type.name().toLowerCase());
            switch (type) {
                case INPUT: 
                case WARNING: {
                    this.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
                    break;
                }
                case INFORMATION: {
                    this.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
                    break;
                }
                case ERROR: {
                    this.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
                    break;
                }
                case CONFIRMATION: {
                    this.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    break;
                }
                case BLANK: {
                    this.setUsingPadding(false);
                }
            }
            this.setOnResize(new DefaultResizeHandler(this));
            this.preferencesProperty().subscribe(preferences -> {
                if (preferences != null) {
                    double height;
                    double width = preferences.getDouble("width", -1.0);
                    if (width != -1.0) {
                        this.setPrefWidth(width);
                    }
                    if ((height = preferences.getDouble("height", -1.0)) != -1.0) {
                        this.setPrefHeight(height);
                    }
                }
            });
        }

        public final Type getType() {
            return this.type;
        }

        public final DialogPane getDialogPane() {
            return this.pane;
        }

        public final String getId() {
            return (String)this.id.get();
        }

        public final StringProperty idProperty() {
            return this.id;
        }

        public final void setId(String id) {
            this.id.set((Object)id);
        }

        public final Preferences getPreferences() {
            return (Preferences)this.preferences.get();
        }

        public final ObjectProperty<Preferences> preferencesProperty() {
            return this.preferences;
        }

        public final void setPreferences(Preferences preferences) {
            this.preferences.set((Object)preferences);
        }

        public final double getPrefWidth() {
            return this.prefWidth.get();
        }

        public final DoubleProperty prefWidthProperty() {
            return this.prefWidth;
        }

        public final void setPrefWidth(double prefWidth) {
            this.prefWidth.set(prefWidth);
        }

        public final double getPrefHeight() {
            return this.prefHeight.get();
        }

        public final DoubleProperty prefHeightProperty() {
            return this.prefHeight;
        }

        public final void setPrefHeight(double prefHeight) {
            this.prefHeight.set(prefHeight);
        }

        public final double getMinWidth() {
            return this.minWidth.get();
        }

        public final DoubleProperty minWidthProperty() {
            return this.minWidth;
        }

        public final void setMinWidth(double minWidth) {
            this.minWidth.set(minWidth);
        }

        public final double getMinHeight() {
            return this.minHeight.get();
        }

        public final DoubleProperty minHeightProperty() {
            return this.minHeight;
        }

        public final void setMinHeight(double minHeight) {
            this.minHeight.set(minHeight);
        }

        public final double getMaxWidth() {
            return this.maxWidth.get();
        }

        public final DoubleProperty maxWidthProperty() {
            return this.maxWidth;
        }

        public final void setMaxWidth(double maxWidth) {
            this.maxWidth.set(maxWidth);
        }

        public final double getMaxHeight() {
            return this.maxHeight.get();
        }

        public final DoubleProperty maxHeightProperty() {
            return this.maxHeight;
        }

        public final void setMaxHeight(double maxHeight) {
            this.maxHeight.set(maxHeight);
        }

        public final BiConsumer<Double, Double> getOnResize() {
            return (BiConsumer)this.onResize.get();
        }

        public final ObjectProperty<BiConsumer<Double, Double>> onResizeProperty() {
            return this.onResize;
        }

        public final void setOnResize(BiConsumer<Double, Double> onResize) {
            this.onResize.set(onResize);
        }

        public final boolean isRequired() {
            return this.required.get();
        }

        public final BooleanProperty requiredProperty() {
            return this.required;
        }

        public final void setRequired(boolean required) {
            this.required.set(required);
        }

        public final boolean isShowCloseButton() {
            return this.showCloseButton.get();
        }

        public final BooleanProperty showCloseButtonProperty() {
            return this.showCloseButton;
        }

        public final void setShowCloseButton(boolean showCloseButton) {
            this.showCloseButton.set(showCloseButton);
        }

        public final Duration getDelay() {
            return (Duration)this.delay.get();
        }

        public final ObjectProperty<Duration> delayProperty() {
            return this.delay;
        }

        public final void setDelay(Duration delay) {
            this.delay.set((Object)delay);
        }

        public final boolean isUsingPadding() {
            return this.usingPadding.get();
        }

        public final BooleanProperty usingPaddingProperty() {
            return this.usingPadding;
        }

        public final void setUsingPadding(boolean usingPadding) {
            this.usingPadding.set(usingPadding);
        }

        public final Pos getContentAlignment() {
            return (Pos)this.contentAlignment.get();
        }

        public final ObjectProperty<Pos> contentAlignmentProperty() {
            return this.contentAlignment;
        }

        public final void setContentAlignment(Pos contentAlignment) {
            this.contentAlignment.set((Object)contentAlignment);
        }

        public final T getValue() {
            return (T)this.value.get();
        }

        public final ObjectProperty<T> valueProperty() {
            return this.value;
        }

        public final void setValue(T value) {
            this.value.set(value);
        }

        public void show() {
            this.pane.showDialog(this);
        }

        public void cancel() {
            this.pane.hideDialog(this);
            this.setValue(null);
            this.commit(ButtonType.CANCEL);
        }

        public Consumer<ButtonType> getOnButtonPressed() {
            return this.onButtonPressed;
        }

        public final void setOnButtonPressed(Consumer<ButtonType> onButtonPressed) {
            this.onButtonPressed = onButtonPressed;
        }

        public final Consumer<ButtonType> getOnClose() {
            return (Consumer)this.onClose.get();
        }

        public final ObjectProperty<Consumer<ButtonType>> onCloseProperty() {
            return this.onClose;
        }

        public final void setOnClose(Consumer<ButtonType> onClose) {
            this.onClose.set(onClose);
        }

        public final Dialog<T> onClose(Consumer<ButtonType> onCommit) {
            Objects.requireNonNull(onCommit, "onCommit handler can not be null");
            this.setOnClose(onCommit);
            return this;
        }

        private void commit(ButtonType buttonType) {
            if (this.onButtonPressed != null) {
                this.onButtonPressed.accept(buttonType);
            }
            this.getOnClose().accept(buttonType);
        }

        public final boolean isValid() {
            return this.valid.get();
        }

        public final BooleanProperty validProperty() {
            return this.valid;
        }

        public final void setValid(boolean valid) {
            this.valid.set(valid);
        }

        public final ObservableList<ButtonType> getButtonTypes() {
            return this.buttonTypes;
        }

        public final boolean isSameWidthButtons() {
            return this.sameWidthButtons.get();
        }

        public final BooleanProperty sameWidthButtonsProperty() {
            return this.sameWidthButtons;
        }

        public final void setSameWidthButtons(boolean sameWidthButtons) {
            this.sameWidthButtons.set(sameWidthButtons);
        }

        public final BooleanProperty maximizeProperty() {
            return this.maximize;
        }

        public final void setMaximize(boolean max) {
            this.maximize.set(max);
        }

        public final boolean isMaximize() {
            return this.maximize.get();
        }

        public final ObjectProperty<Node> contentProperty() {
            return this.content;
        }

        public final void setContent(Node content) {
            this.content.set((Object)content);
        }

        public final Node getContent() {
            return (Node)this.content.get();
        }

        public final Node getExtras() {
            return (Node)this.extras.get();
        }

        public final ObjectProperty<Node> extrasProperty() {
            return this.extras;
        }

        public final void setExtras(Node extras) {
            this.extras.set((Object)extras);
        }

        public final StringProperty titleProperty() {
            return this.title;
        }

        public final String getTitle() {
            return (String)this.title.get();
        }

        public final void setTitle(String title) {
            this.title.set((Object)title);
        }

        public final ObservableList<String> getStyleClass() {
            return this.styleClass;
        }

        public final BooleanProperty showHeaderProperty() {
            return this.showHeader;
        }

        public final boolean isShowHeader() {
            return this.showHeaderProperty().get();
        }

        public final void setShowHeader(boolean showHeader) {
            this.showHeaderProperty().set(showHeader);
        }

        public final BooleanProperty showFooterProperty() {
            return this.showFooter;
        }

        public final boolean isShowFooter() {
            return this.showFooterProperty().get();
        }

        public final void setShowFooter(boolean showFooter) {
            this.showFooterProperty().set(showFooter);
        }

        public final Button getButton(ButtonType type) {
            return this.buttonMap.get(type);
        }

        public final Validator getValidator() {
            return (Validator)this.validator.get();
        }

        public final ObjectProperty<Validator> validatorProperty() {
            return this.validator;
        }

        public final void setValidator(Validator validator) {
            this.validator.set((Object)validator);
        }

        public final boolean isResizable() {
            return this.resizable.get();
        }

        public final BooleanProperty resizableProperty() {
            return this.resizable;
        }

        public final void setResizable(boolean resizable) {
            this.resizable.set(resizable);
        }
    }

    public static enum Type {
        INPUT,
        INFORMATION,
        ERROR,
        WARNING,
        CONFIRMATION,
        BLANK;

    }

    private static class BusyIndicator
    extends CircularProgressIndicator {
        public BusyIndicator() {
            this.getStyleClass().add((Object)"dialog-pane-busy-indicator");
        }

        public void stop() {
            this.setProgress(0.0);
        }

        public void start() {
            this.setProgress(-1.0);
        }
    }

    private class ContentPane
    extends StackPane {
        private final Dialog<?> dialog;
        private final ChangeListener<Node> focusListener = (o, oldOwner, newOwner) -> {
            if (newOwner != null && !this.isInsideDialogPane(newOwner.getParent()) && this.getScene() != null) {
                if (oldOwner != null && this.isInsideDialogPane(oldOwner.getParent())) {
                    oldOwner.requestFocus();
                } else {
                    this.requestFocus();
                }
            }
        };
        private final WeakChangeListener<Node> weakFocusListener = new WeakChangeListener(this.focusListener);
        private final BooleanProperty blocked = new SimpleBooleanProperty((Object)this, "blocked");

        public ContentPane(Dialog<?> dialog) {
            this.dialog = Objects.requireNonNull(dialog);
            this.prefWidthProperty().bindBidirectional((Property)dialog.prefWidthProperty());
            this.prefHeightProperty().bindBidirectional((Property)dialog.prefHeightProperty());
            this.minWidthProperty().bindBidirectional((Property)dialog.minWidthProperty());
            this.minHeightProperty().bindBidirectional((Property)dialog.minHeightProperty());
            this.maxWidthProperty().bindBidirectional((Property)dialog.maxWidthProperty());
            this.maxHeightProperty().bindBidirectional((Property)dialog.maxHeightProperty());
            ResizingBehaviour resizingSupport = ResizingBehaviour.install((Region)this);
            resizingSupport.resizableProperty().bind((ObservableValue)dialog.resizableProperty());
            resizingSupport.onResizeProperty().bind(dialog.onResizeProperty());
            this.setFocusTraversable(false);
            DialogPane shell = this.dialog.getDialogPane();
            Node header = (Node)DialogPane.this.getHeaderFactory().call(dialog);
            StackPane content = new StackPane();
            content.getStyleClass().add((Object)"content");
            if (dialog.isUsingPadding()) {
                content.getStyleClass().add((Object)"padding");
            }
            this.sceneProperty().addListener((obs, oldScene, newScene) -> {
                if (oldScene != null) {
                    oldScene.focusOwnerProperty().removeListener(this.weakFocusListener);
                }
                if (newScene != null) {
                    newScene.focusOwnerProperty().addListener(this.weakFocusListener);
                }
            });
            VBox.setVgrow((Node)content, (Priority)Priority.ALWAYS);
            StackPane.setAlignment((Node)this.dialog.getContent(), (Pos)dialog.getContentAlignment());
            content.getChildren().setAll((Object[])new Node[]{this.dialog.getContent()});
            boolean blankDialog = this.dialog.getType().equals((Object)Type.BLANK);
            header.setVisible(!blankDialog && dialog.isShowHeader());
            header.setManaged(!blankDialog && dialog.isShowHeader());
            Node footer = (Node)DialogPane.this.getFooterFactory().call(dialog);
            VBox.setVgrow((Node)footer, (Priority)Priority.NEVER);
            footer.setVisible(!blankDialog && dialog.isShowFooter());
            footer.setManaged(!blankDialog && dialog.isShowFooter());
            this.getStyleClass().setAll((Object[])new String[]{"content-pane"});
            this.getStyleClass().addAll(this.dialog.getStyleClass());
            VBox box = new VBox();
            box.getStyleClass().add((Object)"vbox");
            box.setFillWidth(true);
            box.getChildren().setAll((Object[])new Node[]{header, content, footer});
            GlassPane glassPane = new GlassPane();
            glassPane.hideProperty().bind((ObservableValue)this.blocked.not());
            glassPane.fadeInOutProperty().bind((ObservableValue)shell.fadeInOutProperty());
            this.getChildren().addAll((Object[])new Node[]{box, glassPane});
        }

        public Orientation getContentBias() {
            return Orientation.VERTICAL;
        }

        private boolean isInsideDialogPane(Parent parent) {
            if (parent == null) {
                return false;
            }
            if (parent instanceof DialogPane) {
                return true;
            }
            return this.isInsideDialogPane(parent.getParent());
        }

        public boolean isBlocked() {
            return this.blocked.get();
        }

        public BooleanProperty blockedProperty() {
            return this.blocked;
        }

        public void setBlocked(boolean blocked) {
            this.blocked.set(blocked);
        }

        public Dialog<?> getDialog() {
            return this.dialog;
        }
    }

    public static class DefaultResizeHandler
    implements BiConsumer<Double, Double> {
        private final Dialog<?> dialog;

        public DefaultResizeHandler(Dialog<?> dialog) {
            this.dialog = Objects.requireNonNull(dialog, "dialog can not be null");
        }

        @Override
        public void accept(Double width, Double height) {
            Preferences preferences = this.dialog.getPreferences();
            if (preferences != null) {
                preferences.put("width", width.toString());
                preferences.put("height", height.toString());
            }
        }
    }

    private static class CircularProgressIndicator
    extends Region {
        private static final double PREFERRED_WIDTH = 24.0;
        private static final double PREFERRED_HEIGHT = 24.0;
        private static final double MINIMUM_WIDTH = 12.0;
        private static final double MINIMUM_HEIGHT = 12.0;
        private static final double MAXIMUM_WIDTH = 1024.0;
        private static final double MAXIMUM_HEIGHT = 1024.0;
        private final DoubleProperty dashOffset = new SimpleDoubleProperty(0.0);
        private final DoubleProperty dashArray_0 = new SimpleDoubleProperty(1.0);
        private StackPane indeterminatePane;
        private Pane progressPane;
        private Circle circle;
        private Arc arc;
        private final Timeline timeline;
        private RotateTransition indeterminatePaneRotation;
        private final InvalidationListener listener;
        private final DoubleProperty progress;
        private final BooleanProperty indeterminate;
        private final BooleanProperty roundLineCap;
        private boolean isRunning;

        public CircularProgressIndicator() {
            this.getStyleClass().add((Object)"circular-progress");
            this.progress = new DoublePropertyBase(0.0){

                public void invalidated() {
                    if (this.get() < 0.0) {
                        this.startIndeterminate();
                    } else {
                        this.stopIndeterminate();
                        this.set(Math.max(0.0, Math.min(1.0, this.get())));
                        this.redraw();
                    }
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "progress";
                }
            };
            this.indeterminate = new BooleanPropertyBase(false){

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "indeterminate";
                }
            };
            this.roundLineCap = new BooleanPropertyBase(false){

                public void invalidated() {
                    if (this.get()) {
                        circle.setStrokeLineCap(StrokeLineCap.ROUND);
                        arc.setStrokeLineCap(StrokeLineCap.ROUND);
                    } else {
                        circle.setStrokeLineCap(StrokeLineCap.SQUARE);
                        arc.setStrokeLineCap(StrokeLineCap.SQUARE);
                    }
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "roundLineCap";
                }
            };
            this.isRunning = false;
            this.timeline = new Timeline();
            this.listener = observable -> {
                this.circle.setStrokeDashOffset(this.dashOffset.get());
                this.circle.getStrokeDashArray().setAll((Object[])new Double[]{this.dashArray_0.getValue(), 200.0});
            };
            this.init();
            this.initGraphics();
            this.registerListeners();
        }

        private void init() {
            if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
                if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                    this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
                } else {
                    this.setPrefSize(24.0, 24.0);
                }
            }
            if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
                this.setMinSize(12.0, 12.0);
            }
            if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
                this.setMaxSize(1024.0, 1024.0);
            }
        }

        private void initGraphics() {
            double center = 12.0;
            double radius = 10.8;
            this.circle = new Circle();
            this.circle.setCenterX(center);
            this.circle.setCenterY(center);
            this.circle.setRadius(radius);
            this.circle.getStyleClass().add((Object)"indicator");
            this.circle.setStrokeLineCap(this.isRoundLineCap() ? StrokeLineCap.ROUND : StrokeLineCap.SQUARE);
            this.circle.setStrokeWidth(2.5263158399999996);
            this.circle.setStrokeDashOffset(this.dashOffset.get());
            this.circle.getStrokeDashArray().setAll((Object[])new Double[]{this.dashArray_0.getValue(), 200.0});
            this.arc = new Arc(center, center, radius, radius, 90.0, -360.0 * this.getProgress());
            this.arc.setStrokeLineCap(this.isRoundLineCap() ? StrokeLineCap.ROUND : StrokeLineCap.SQUARE);
            this.arc.setStrokeWidth(2.4000000000000004);
            this.arc.getStyleClass().add((Object)"indicator");
            this.indeterminatePane = new StackPane(new Node[]{this.circle});
            this.indeterminatePane.setVisible(false);
            this.progressPane = new Pane(new Node[]{this.arc});
            this.progressPane.setVisible(Double.compare(this.getProgress(), 0.0) != 0);
            this.getChildren().setAll((Object[])new Node[]{this.progressPane, this.indeterminatePane});
            KeyValue kvDashOffset_0 = new KeyValue((WritableValue)this.dashOffset, (Object)0, Interpolator.EASE_BOTH);
            KeyValue kvDashOffset_50 = new KeyValue((WritableValue)this.dashOffset, (Object)-32, Interpolator.EASE_BOTH);
            KeyValue kvDashOffset_100 = new KeyValue((WritableValue)this.dashOffset, (Object)-64, Interpolator.EASE_BOTH);
            KeyValue kvDashArray_0_0 = new KeyValue((WritableValue)this.dashArray_0, (Object)5, Interpolator.EASE_BOTH);
            KeyValue kvDashArray_0_50 = new KeyValue((WritableValue)this.dashArray_0, (Object)89, Interpolator.EASE_BOTH);
            KeyValue kvDashArray_0_100 = new KeyValue((WritableValue)this.dashArray_0, (Object)89, Interpolator.EASE_BOTH);
            KeyValue kvRotate_0 = new KeyValue((WritableValue)this.circle.rotateProperty(), (Object)-10, Interpolator.LINEAR);
            KeyValue kvRotate_100 = new KeyValue((WritableValue)this.circle.rotateProperty(), (Object)370, Interpolator.LINEAR);
            KeyFrame kf0 = new KeyFrame(Duration.ZERO, new KeyValue[]{kvDashOffset_0, kvDashArray_0_0, kvRotate_0});
            KeyFrame kf1 = new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{kvDashOffset_50, kvDashArray_0_50});
            KeyFrame kf2 = new KeyFrame(Duration.millis((double)1500.0), new KeyValue[]{kvDashOffset_100, kvDashArray_0_100, kvRotate_100});
            this.timeline.setCycleCount(-1);
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1, kf2});
            this.indeterminatePaneRotation = new RotateTransition();
            this.indeterminatePaneRotation.setNode((Node)this.indeterminatePane);
            this.indeterminatePaneRotation.setFromAngle(0.0);
            this.indeterminatePaneRotation.setToAngle(-360.0);
            this.indeterminatePaneRotation.setInterpolator(Interpolator.LINEAR);
            this.indeterminatePaneRotation.setCycleCount(-1);
            this.indeterminatePaneRotation.setDuration(new Duration(4500.0));
            this.indeterminatePane.rotateProperty().addListener(it -> {
                Window window;
                Scene scene = this.indeterminatePane.getScene();
                boolean stop = scene != null ? ((window = scene.getWindow()) == null ? true : !window.isShowing()) : true;
                if (stop) {
                    this.stopIndeterminate();
                }
            });
        }

        private void registerListeners() {
            this.widthProperty().addListener(o -> this.resize());
            this.heightProperty().addListener(o -> this.resize());
            this.progress.addListener(o -> this.redraw());
            this.dashOffset.addListener(this.listener);
        }

        public double getProgress() {
            return this.progress.get();
        }

        public void setProgress(double PROGRESS) {
            this.progress.set(PROGRESS);
        }

        public DoubleProperty progressProperty() {
            return this.progress;
        }

        private void startIndeterminate() {
            if (this.isRunning) {
                return;
            }
            this.manageNode((Node)this.indeterminatePane, true);
            this.manageNode((Node)this.progressPane, false);
            this.timeline.play();
            this.indeterminatePaneRotation.play();
            this.isRunning = true;
            this.indeterminate.set(true);
        }

        private void stopIndeterminate() {
            if (!this.isRunning) {
                return;
            }
            this.timeline.stop();
            this.indeterminatePaneRotation.stop();
            this.indeterminatePane.setRotate(0.0);
            this.manageNode((Node)this.progressPane, true);
            this.manageNode((Node)this.indeterminatePane, false);
            this.isRunning = false;
            this.indeterminate.set(false);
        }

        public boolean isIndeterminate() {
            return Double.compare(-1.0, this.getProgress()) == 0;
        }

        public ReadOnlyBooleanProperty indeterminateProperty() {
            return this.indeterminate;
        }

        public boolean isRoundLineCap() {
            return this.roundLineCap.get();
        }

        public void setRoundLineCap(boolean BOOLEAN) {
            this.roundLineCap.set(BOOLEAN);
        }

        public BooleanProperty roundLineCapProperty() {
            return this.roundLineCap;
        }

        private void manageNode(Node NODE, boolean MANAGED) {
            if (MANAGED) {
                NODE.setManaged(true);
                NODE.setVisible(true);
            } else {
                NODE.setVisible(false);
                NODE.setManaged(false);
            }
        }

        private void resize() {
            double width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
            double height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
            double size = Math.min(width, height);
            if (width > 0.0 && height > 0.0) {
                this.indeterminatePane.setMaxSize(size, size);
                this.indeterminatePane.setPrefSize(size, size);
                this.indeterminatePane.relocate((this.getWidth() - size) * 0.5, (this.getHeight() - size) * 0.5);
                this.progressPane.setMaxSize(size, size);
                this.progressPane.setPrefSize(size, size);
                this.progressPane.relocate((this.getWidth() - size) * 0.5, (this.getHeight() - size) * 0.5);
                double center = size * 0.5;
                double radius = size * 0.45;
                this.arc.setCenterX(center);
                this.arc.setCenterY(center);
                this.arc.setRadiusX(radius);
                this.arc.setRadiusY(radius);
                this.arc.setStrokeWidth(size * 0.10526316);
                double factor = size / 24.0;
                this.circle.setScaleX(factor);
                this.circle.setScaleY(factor);
            }
        }

        private void redraw() {
            double progress = this.getProgress();
            this.progressPane.setVisible(Double.compare(progress, 0.0) > 0);
            this.arc.setLength(-360.0 * progress);
        }
    }

    public static class DialogButtonBar
    extends ButtonBar {
        private final Dialog<?> dialog;

        public DialogButtonBar(Dialog<?> dialog) {
            this.dialog = dialog;
            this.setSkin((Skin)new ButtonBarSkin((ButtonBar)this));
            this.getStyleClass().add((Object)"footer");
            if (System.getProperty("os.name").startsWith("Mac")) {
                this.setButtonOrder("L_NCYOAHE+U+FBIX_R");
            } else if (System.getProperty("os.name").startsWith("Windows")) {
                this.setButtonOrder("L_YNOCAHE+U+FBXI_R");
            } else {
                this.setButtonOrder("L_HENYCOA+U+FBIX_R");
            }
            if (!dialog.getType().equals((Object)Type.BLANK)) {
                this.createButtons();
            }
        }

        protected void createButtons() {
            this.getButtons().clear();
            boolean hasDefault = false;
            for (ButtonType buttonType : this.dialog.getButtonTypes()) {
                Button button = this.createButton(buttonType);
                this.dialog.buttonMap.put(buttonType, button);
                switch (buttonType.getButtonData()) {
                    case LEFT: 
                    case RIGHT: 
                    case HELP: 
                    case HELP_2: 
                    case NO: 
                    case NEXT_FORWARD: 
                    case BACK_PREVIOUS: 
                    case APPLY: 
                    case CANCEL_CLOSE: 
                    case OTHER: 
                    case BIG_GAP: 
                    case SMALL_GAP: {
                        break;
                    }
                    case YES: 
                    case OK_DONE: 
                    case FINISH: {
                        button.disableProperty().bind((ObservableValue)this.dialog.validProperty().not());
                    }
                }
                if (button != null) {
                    Node content;
                    ButtonBar.ButtonData buttonData = buttonType.getButtonData();
                    button.setDefaultButton(!hasDefault && buttonData != null && buttonData.isDefaultButton());
                    button.setCancelButton(buttonData != null && buttonData.isCancelButton());
                    button.setOnAction(evt -> {
                        if (buttonType.equals(ButtonType.CANCEL)) {
                            this.dialog.cancel();
                        } else {
                            Validator validator;
                            if (buttonData != null && this.isTriggeringValidation(buttonData) && (validator = this.dialog.getValidator()) != null && !validator.validate()) {
                                return;
                            }
                            this.dialog.getDialogPane().hideDialog(this.dialog);
                            this.dialog.commit(buttonType);
                        }
                    });
                    hasDefault |= buttonData != null && buttonData.isDefaultButton();
                    if (button.isDefaultButton() && (content = this.dialog.getContent()) instanceof ListView) {
                        content.setOnMouseClicked(evt -> {
                            if (evt.getClickCount() == 2) {
                                button.fire();
                            }
                        });
                    }
                }
                this.getButtons().add((Object)button);
            }
        }

        protected boolean isTriggeringValidation(ButtonBar.ButtonData data) {
            return switch (data) {
                default -> throw new IncompatibleClassChangeError();
                case ButtonBar.ButtonData.LEFT -> true;
                case ButtonBar.ButtonData.RIGHT -> true;
                case ButtonBar.ButtonData.HELP -> false;
                case ButtonBar.ButtonData.HELP_2 -> false;
                case ButtonBar.ButtonData.YES -> true;
                case ButtonBar.ButtonData.NO -> false;
                case ButtonBar.ButtonData.NEXT_FORWARD -> true;
                case ButtonBar.ButtonData.BACK_PREVIOUS -> true;
                case ButtonBar.ButtonData.FINISH -> true;
                case ButtonBar.ButtonData.APPLY -> true;
                case ButtonBar.ButtonData.CANCEL_CLOSE -> false;
                case ButtonBar.ButtonData.OK_DONE -> true;
                case ButtonBar.ButtonData.OTHER -> true;
                case ButtonBar.ButtonData.BIG_GAP -> true;
                case ButtonBar.ButtonData.SMALL_GAP -> true;
            };
        }

        protected Button createButton(ButtonType buttonType) {
            String text = buttonType.getText();
            StringConverter<ButtonType> converter = this.dialog.getDialogPane().getConverter();
            if (converter != null) {
                text = converter.toString((Object)buttonType);
            }
            Button button = new Button(text);
            button.getStyleClass().add((Object)buttonType.getButtonData().getTypeCode().toLowerCase());
            ButtonBar.ButtonData buttonData = buttonType.getButtonData();
            button.setMinWidth(Double.NEGATIVE_INFINITY);
            ButtonBar.setButtonUniformSize((Node)button, (boolean)this.dialog.isSameWidthButtons());
            ButtonBar.setButtonData((Node)button, (ButtonBar.ButtonData)buttonData);
            button.setDefaultButton(buttonData.isDefaultButton());
            button.setCancelButton(buttonData.isCancelButton());
            return button;
        }
    }

    public static class DialogHeader
    extends StackPane {
        private final BooleanProperty showCloseButton = new SimpleBooleanProperty((Object)this, "showCloseButton", true);
        private final BooleanProperty showIcon = new SimpleBooleanProperty((Object)this, "showIcon", true);

        public DialogHeader(Dialog<?> dialog) {
            this.setAlignment(Pos.CENTER);
            this.getStyleClass().add((Object)"header");
            Label dialogTitle = new Label("Dialog");
            dialogTitle.setMaxWidth(Double.MAX_VALUE);
            dialogTitle.getStyleClass().add((Object)"title");
            dialogTitle.textProperty().bind((ObservableValue)dialog.titleProperty());
            VBox.setVgrow((Node)dialogTitle, (Priority)Priority.NEVER);
            ImageView dialogIcon = new ImageView();
            dialogIcon.getStyleClass().addAll((Object[])new String[]{"icon"});
            dialogIcon.visibleProperty().bind((ObservableValue)this.showIconProperty());
            dialogIcon.managedProperty().bind((ObservableValue)this.showIconProperty());
            VBox vBox = new VBox(new Node[]{dialogIcon, dialogTitle});
            vBox.getStyleClass().add((Object)"title-and-icon-box");
            FontIcon fontIcon = new FontIcon((Ikon)MaterialDesign.MDI_CLOSE);
            Button closeButton = new Button();
            closeButton.setGraphic((Node)fontIcon);
            closeButton.setFocusTraversable(false);
            closeButton.setAlignment(Pos.CENTER);
            closeButton.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            closeButton.getStyleClass().add((Object)"close-button");
            closeButton.visibleProperty().bind((ObservableValue)dialog.showCloseButtonProperty().and((ObservableBooleanValue)this.showCloseButtonProperty()));
            closeButton.managedProperty().bind((ObservableValue)dialog.showCloseButtonProperty().and((ObservableBooleanValue)this.showCloseButtonProperty()));
            closeButton.setOnAction(evt -> dialog.cancel());
            StackPane.setAlignment((Node)closeButton, (Pos)Pos.TOP_RIGHT);
            this.getChildren().setAll((Object[])new Node[]{vBox, closeButton});
        }

        public final boolean isShowCloseButton() {
            return this.showCloseButton.get();
        }

        public final BooleanProperty showCloseButtonProperty() {
            return this.showCloseButton;
        }

        public final void setShowCloseButton(boolean showCloseButton) {
            this.showCloseButton.set(showCloseButton);
        }

        public final boolean isShowIcon() {
            return this.showIcon.get();
        }

        public final BooleanProperty showIconProperty() {
            return this.showIcon;
        }

        public final void setShowIcon(boolean showIcon) {
            this.showIcon.set(showIcon);
        }
    }
}

