\page ExampleRE03 Example RE03


 Contact : M.Asai (SLAC/JLab), A.Kimura (AIT), T.Aso (TNCMT)

## Introduction

 This example demonstrates how to use UI-command base scoring.
It create parallel world(s) for defining scoring mesh(es).

 Due to some performance overhead, this functionality is not 
provided by default. To get it included, the pointer to 
G4ScoringManager must be accessed. The access to the static 
method G4ScoringManager::GetScoringManager() activates this 
functionality. 

### Geometry and primary particle

 It has just one water box in the world volume filled by air.
No detector in the mass geometry. Particle gun shoots a gamma
into the water box.

### Physics

 The physics list is taken from referenced physics-list QGS_BIC
in Geant4.

## Macro files

### "run.mac"

run.mac is the main macro file of this example for both
batch and interactive modes.

 In interactive mode, trajectories are not visualized by default
for the sake of execution speed. To visualize them, comment out
lines of `/vis/disable` and `/vis/enable` in run.mac.

 In addition, in sub-event parallel mode, only the trajectories
created in the master thread are visualized by default.
Un-comment the line of /run/trajectoriesToBeMerged in vis.mac
to visualize all trajectories.

 draw.mac is used by run.mac to visualize a score. 

### Other macro files

 run2.mac through run4.mac macro files should be used
independently. They demonstrate additional functionalities of
command-based scoring. Each macro file create its own scoring
parallel world(s). 

 - run2.mac : defining three box meshes of different sizes
   and granurarities touching to each other
 - run3.mac : defining two box meshes of different sizes and
   granurarities overlaying one over the other to demonstrate
   changing granurarity of a box mesh
 - run4.mac : defining a cylindrical mesh

 IMPORTANT: DO NOT use more than one of these macro files in
one execution of this example.

drawSlice.mac and drawCylinderSlice.mac are used internally 
from run*.mac to draw a single slice of the corresponding mesh. 

## RE03ActionInitialization

The RE03ActionInitialization class works for all Geant4 run
modes, i.e. sequential mode, event-level paralle mode and
sub-event-level parallel mode.

## RE03UserScoreWriter

G4ScoringManager has a default score writer which dumps every
entry of one quantity of a mesh for all quantities of the mesh
one by one in CSV format. To alternate the file format the user
can implement his/her own score writer deriving from G4VUserScoreWriter
base class and set it to G4ScoringManager. To demonstrate this,
RE03UserScoreWriter is included in this example. To use this
alternative writer, un-comment its instantiation in RE03.cc.






