/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.StandardMethodCodec;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class PlatformViewsChannel2 {
    private static final String TAG = "PlatformViewsChannel2";
    private final MethodChannel channel;
    private PlatformViewsHandler handler;
    private final MethodChannel.MethodCallHandler parsingHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (PlatformViewsChannel2.this.handler == null) {
                return;
            }
            Log.v(PlatformViewsChannel2.TAG, "Received '" + call.method + "' message.");
            switch (call.method) {
                case "create": {
                    this.create(call, result);
                    break;
                }
                case "dispose": {
                    this.dispose(call, result);
                    break;
                }
                case "touch": {
                    this.touch(call, result);
                    break;
                }
                case "setDirection": {
                    this.setDirection(call, result);
                    break;
                }
                case "clearFocus": {
                    this.clearFocus(call, result);
                    break;
                }
                case "isSurfaceControlEnabled": {
                    this.isSurfaceControlEnabled(call, result);
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }

        private void create(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            Map createArgs = (Map)call.arguments();
            ByteBuffer additionalParams = createArgs.containsKey("params") ? ByteBuffer.wrap((byte[])createArgs.get("params")) : null;
            try {
                PlatformViewCreationRequest request = new PlatformViewCreationRequest((Integer)createArgs.get("id"), (String)createArgs.get("viewType"), 0.0, 0.0, (Integer)createArgs.get("direction"), additionalParams);
                PlatformViewsChannel2.this.handler.createPlatformView(request);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel2.detailedExceptionString(exception), null);
            }
        }

        private void dispose(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            Map disposeArgs = (Map)call.arguments();
            int viewId = (Integer)disposeArgs.get("id");
            try {
                PlatformViewsChannel2.this.handler.dispose(viewId);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel2.detailedExceptionString(exception), null);
            }
        }

        private void touch(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            List args = (List)call.arguments();
            PlatformViewTouch touch = new PlatformViewTouch((Integer)args.get(0), (Number)args.get(1), (Number)args.get(2), (Integer)args.get(3), (Integer)args.get(4), args.get(5), args.get(6), (Integer)args.get(7), (Integer)args.get(8), (float)((Double)args.get(9)).doubleValue(), (float)((Double)args.get(10)).doubleValue(), (Integer)args.get(11), (Integer)args.get(12), (Integer)args.get(13), (Integer)args.get(14), ((Number)args.get(15)).longValue());
            try {
                PlatformViewsChannel2.this.handler.onTouch(touch);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel2.detailedExceptionString(exception), null);
            }
        }

        private void setDirection(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            Map setDirectionArgs = (Map)call.arguments();
            int newDirectionViewId = (Integer)setDirectionArgs.get("id");
            int direction = (Integer)setDirectionArgs.get("direction");
            try {
                PlatformViewsChannel2.this.handler.setDirection(newDirectionViewId, direction);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel2.detailedExceptionString(exception), null);
            }
        }

        private void clearFocus(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            int viewId = (Integer)call.arguments();
            try {
                PlatformViewsChannel2.this.handler.clearFocus(viewId);
                result.success(null);
            }
            catch (IllegalStateException exception) {
                result.error("error", PlatformViewsChannel2.detailedExceptionString(exception), null);
            }
        }

        private void isSurfaceControlEnabled(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            result.success(PlatformViewsChannel2.this.handler.isSurfaceControlEnabled());
        }
    };

    public PlatformViewsChannel2(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/platform_views_2", StandardMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingHandler);
    }

    public void invokeViewFocused(int viewId) {
        if (this.channel == null) {
            return;
        }
        this.channel.invokeMethod("viewFocused", viewId);
    }

    private static String detailedExceptionString(Exception exception) {
        return Log.getStackTraceString(exception);
    }

    public void setPlatformViewsHandler(@Nullable PlatformViewsHandler handler) {
        this.handler = handler;
    }

    public static interface PlatformViewsHandler {
        public void createPlatformView(@NonNull PlatformViewCreationRequest var1);

        public void dispose(int var1);

        public void onTouch(@NonNull PlatformViewTouch var1);

        public void setDirection(int var1, int var2);

        public void clearFocus(int var1);

        public boolean isSurfaceControlEnabled();
    }

    public static class PlatformViewTouch {
        public final int viewId;
        @NonNull
        public final Number downTime;
        @NonNull
        public final Number eventTime;
        public final int action;
        public final int pointerCount;
        @NonNull
        public final Object rawPointerPropertiesList;
        @NonNull
        public final Object rawPointerCoords;
        public final int metaState;
        public final int buttonState;
        public final float xPrecision;
        public final float yPrecision;
        public final int deviceId;
        public final int edgeFlags;
        public final int source;
        public final int flags;
        public final long motionEventId;

        public PlatformViewTouch(int viewId, @NonNull Number downTime, @NonNull Number eventTime, int action, int pointerCount, @NonNull Object rawPointerPropertiesList, @NonNull Object rawPointerCoords, int metaState, int buttonState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags, long motionEventId) {
            this.viewId = viewId;
            this.downTime = downTime;
            this.eventTime = eventTime;
            this.action = action;
            this.pointerCount = pointerCount;
            this.rawPointerPropertiesList = rawPointerPropertiesList;
            this.rawPointerCoords = rawPointerCoords;
            this.metaState = metaState;
            this.buttonState = buttonState;
            this.xPrecision = xPrecision;
            this.yPrecision = yPrecision;
            this.deviceId = deviceId;
            this.edgeFlags = edgeFlags;
            this.source = source;
            this.flags = flags;
            this.motionEventId = motionEventId;
        }
    }

    public static class PlatformViewCreationRequest {
        public final int viewId;
        @NonNull
        public final String viewType;
        public final double logicalWidth;
        public final double logicalHeight;
        public final int direction;
        @Nullable
        public final ByteBuffer params;

        public PlatformViewCreationRequest(int viewId, @NonNull String viewType, double logicalWidth, double logicalHeight, int direction, @Nullable ByteBuffer params) {
            this.viewId = viewId;
            this.viewType = viewType;
            this.logicalWidth = logicalWidth;
            this.logicalHeight = logicalHeight;
            this.direction = direction;
            this.params = params;
        }
    }
}

