// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:developer';
import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/async_star_single_step_into_test.dart
//
const LINE_A = 27;
const LINE_B = 28;
const LINE_C = 32;
const LINE_G = 34;
const LINE_0 = 35;
const LINE_D = 36;
const LINE_1 = 41;
const LINE_E = 42;
const LINE_F = 43;
// AUTOGENERATED END

Stream<int> foobar() async* {
  yield 1; // LINE_A
  yield 2; // LINE_B
}

Future<void> helper() async {
  print('helper'); // LINE_C
  // ignore: unused_local_variable
  await for (var i in foobar()) /* LINE_G */ {
    debugger(); // LINE_0
    print('loop'); // LINE_D
  }
}

Future<void> testMain() async {
  debugger(); // LINE_1
  print('mmmmm'); // LINE_E
  await helper(); // LINE_F
  print('z');
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_1),
  stepOver, // debugger.

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_E),
  stepOver, // print.

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_F),
  stepInto,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_C),
  stepOver, // print.

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_G), // foobar()
  stepInto,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_G), // await for
  stepInto,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  // Resume here to exit the generator function.
  // TODO(johnmccutchan): Implement support for step-out of async functions.
  resumeIsolate,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_0),
  stepOver, // debugger.

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_D),
  stepOver, // print.

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_G),
  stepInto,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_B),
  resumeIsolate,
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'async_star_single_step_into_test.dart',
      testeeConcurrent: testMain,
      extraArgs: extraDebuggingArgs,
    );
