if(NOT dune-geometry_FOUND)
# Whether this module is installed or not
set(dune-geometry_INSTALLED ON)

# Settings specific to the module

# Package initialization

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was dune-geometry-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

#report other information
set_and_check(dune-geometry_PREFIX "${PACKAGE_PREFIX_DIR}")
set_and_check(dune-geometry_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include")
set(dune-geometry_CMAKE_CONFIG_VERSION "2.10")
set(dune-geometry_CXX_FLAGS "-O2 -Wall -fdiagnostics-color=always -mavx")
set(dune-geometry_CXX_FLAGS_DEBUG "-g")
set(dune-geometry_CXX_FLAGS_MINSIZEREL "-Os -DNDEBUG")
set(dune-geometry_CXX_FLAGS_RELEASE "-O3 -DNDEBUG")
set(dune-geometry_CXX_FLAGS_RELWITHDEBINFO "-O2 -g -DNDEBUG")
set(dune-geometry_DEPENDS "dune-common (>= 2.10)")
set(dune-geometry_SUGGESTS "")
set(dune-geometry_MODULE_PATH "${PACKAGE_PREFIX_DIR}/share/dune/cmake/modules")
set(dune-geometry_PYTHON_WHEELHOUSE "/build/dune-geometry/src/dune-geometry-2.10.0/_skbuild/linux-x86_64-3.14/cmake-build/dist")
set(dune-geometry_LIBRARIES "Dune::Geometry")
set(dune-geometry_HASPYTHON 1)
set(dune-geometry_PYTHONREQUIRES "")

# Resolve dune dependencies
include(CMakeFindDependencyMacro)
macro(find_and_check_dune_dependency module version)
  find_dependency(${module})
  list(PREPEND CMAKE_MODULE_PATH "${dune-common_MODULE_PATH}")
  include(DuneModuleDependencies)
  list(POP_FRONT CMAKE_MODULE_PATH)
  if(dune-common_VERSION VERSION_GREATER_EQUAL "2.10")
    dune_check_module_version(${module} QUIET REQUIRED VERSION "${version}")
  endif()
endmacro()

find_and_check_dune_dependency(dune-common ">= 2.10")

# Set up DUNE_LIBS, DUNE_FOUND_DEPENDENCIES, DUNE_*_FOUND, and HAVE_* variables
if(dune-geometry_LIBRARIES)
  message(STATUS "Setting dune-geometry_LIBRARIES=${dune-geometry_LIBRARIES}")
  list(PREPEND DUNE_LIBS ${dune-geometry_LIBRARIES})
endif()
list(APPEND DUNE_FOUND_DEPENDENCIES dune-geometry)
set(DUNE_dune-geometry_FOUND TRUE)
set(HAVE_DUNE_GEOMETRY TRUE)

# Lines that are set by the CMake build system via the variable DUNE_CUSTOM_PKG_CONFIG_SECTION


# If this file is found in a super build that includes dune-geometry, the 
# `dune-geometry-targets.cmake`-file has not yet been generated. This variable
# determines whether the configuration of dune-geometry has been completed.
get_property(dune-geometry_IN_CONFIG_MODE GLOBAL PROPERTY dune-geometry_LIBRARIES DEFINED)

#import the target
if(dune-geometry_LIBRARIES AND NOT dune-geometry_IN_CONFIG_MODE)
  get_filename_component(_dir "${CMAKE_CURRENT_LIST_FILE}" PATH)
  include("${_dir}/dune-geometry-targets.cmake")
endif()

endif()
