
#ifndef DUNE_COMMON_CONFIG_HH
#define DUNE_COMMON_CONFIG_HH

/* Define to 1 if you have module dune-common available */
#ifndef HAVE_DUNE_COMMON
#define HAVE_DUNE_COMMON 1
#endif



/* Define to the version of dune-common */
#define DUNE_COMMON_VERSION "2.10"

/* Define to the major version of dune-common */
#define DUNE_COMMON_VERSION_MAJOR 2

/* Define to the minor version of dune-common */
#define DUNE_COMMON_VERSION_MINOR 10

/* Define to the revision of dune-common */
#define DUNE_COMMON_VERSION_REVISION 0

/* Standard debug streams with a level below will collapse to doing nothing */
#define DUNE_MINIMAL_DEBUG_LEVEL 4

/* does the standard library provide experimental::is_detected ? */
#define DUNE_HAVE_CXX_EXPERIMENTAL_IS_DETECTED 1

/* does the language support lambdas in unevaluated contexts ? */
#define DUNE_HAVE_CXX_UNEVALUATED_CONTEXT_LAMBDA 1

/* does the standard library provide identity ? */
#define DUNE_HAVE_CXX_STD_IDENTITY 1

/* Define if you have a BLAS library. */
#define HAVE_BLAS 1

/* Define if you have LAPACK library. */
#define HAVE_LAPACK 1

/* Define to 1 if you have the Threading Building Blocks (TBB) library */
/* #undef HAVE_TBB */




/* old feature support macros which were tested until 2.10, kept around for one more release */
/* none for 2.10 */

/* Define to ENABLE_UMFPACK if the UMFPack library is available. */
/// \deprecated Use HAVE_SUITESPARSE_UMFPACK instead
#define HAVE_UMFPACK HAVE_SUITESPARSE_UMFPACK

/* Used to call lapack functions */
#define LAPACK_NEEDS_UNDERLINE

/* If enabled certain Python modules will be precompiled */
/* #undef DUNE_ENABLE_PYTHONMODULE_PRECOMPILE */






#endif // DUNE_COMMON_CONFIG_HH


#ifndef DUNE_COMMON_CONFIG_BOTTOM_HH
#define DUNE_COMMON_CONFIG_BOTTOM_HH



#endif // DUNE_COMMON_CONFIG_BOTTOM_HH
