if(NOT dumux_FOUND)
# Whether this module is installed or not
set(dumux_INSTALLED ON)

# Settings specific to the module

# Package initialization

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was dumux-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

#report other information
set_and_check(dumux_PREFIX "${PACKAGE_PREFIX_DIR}")
set_and_check(dumux_INCLUDE_DIRS "${PACKAGE_PREFIX_DIR}/include")
set(dumux_CMAKE_CONFIG_VERSION "2.10")
set(dumux_CXX_FLAGS "-O2 -Wall -fdiagnostics-color=always -mavx")
set(dumux_CXX_FLAGS_DEBUG "-g")
set(dumux_CXX_FLAGS_MINSIZEREL "-Os -DNDEBUG")
set(dumux_CXX_FLAGS_RELEASE "-O3 -DNDEBUG")
set(dumux_CXX_FLAGS_RELWITHDEBINFO "-O2 -g -DNDEBUG")
set(dumux_DEPENDS "dune-common (>=2.10);dune-geometry (>=2.10);dune-grid (>=2.10);dune-localfunctions (>=2.10);dune-istl (>=2.10)")
set(dumux_SUGGESTS "dune-alugrid (>=2.10);dune-foamgrid (>=2.10);dune-uggrid (>=2.10);dune-functions (>=2.10);opm-common;opm-grid;dune-subgrid (>=2.10);dune-spgrid (>=2.10);dune-mmesh (>=1.4)")
set(dumux_MODULE_PATH "${PACKAGE_PREFIX_DIR}/share/dune/cmake/modules")
set(dumux_PYTHON_WHEELHOUSE "/build/dumux/src/dumux-3.10.0/_skbuild/linux-x86_64-3.14/cmake-build/dist")
set(dumux_LIBRARIES "Dumux::Dumux;Dumux::Format")
set(dumux_HASPYTHON 1)
set(dumux_PYTHONREQUIRES "numpy")

# Resolve dune dependencies
include(CMakeFindDependencyMacro)
macro(find_and_check_dune_dependency module version)
  find_dependency(${module})
  list(PREPEND CMAKE_MODULE_PATH "${dune-common_MODULE_PATH}")
  include(DuneModuleDependencies)
  list(POP_FRONT CMAKE_MODULE_PATH)
  if(dune-common_VERSION VERSION_GREATER_EQUAL "2.10")
    dune_check_module_version(${module} QUIET REQUIRED VERSION "${version}")
  endif()
endmacro()

find_and_check_dune_dependency(dune-uggrid ">=2.10")
find_and_check_dune_dependency(dune-common ">=2.10")
find_and_check_dune_dependency(dune-geometry ">=2.10")
find_and_check_dune_dependency(dune-grid ">=2.10")
find_and_check_dune_dependency(dune-localfunctions ">=2.10")
find_and_check_dune_dependency(dune-istl ">=2.10")

# Set up DUNE_LIBS, DUNE_FOUND_DEPENDENCIES, DUNE_*_FOUND, and HAVE_* variables
if(dumux_LIBRARIES)
  message(STATUS "Setting dumux_LIBRARIES=${dumux_LIBRARIES}")
  list(PREPEND DUNE_LIBS ${dumux_LIBRARIES})
endif()
list(APPEND DUNE_FOUND_DEPENDENCIES dumux)
set(DUNE_dumux_FOUND TRUE)
set(HAVE_DUMUX TRUE)

# Lines that are set by the CMake build system via the variable DUNE_CUSTOM_PKG_CONFIG_SECTION
include(CMakeFindDependencyMacro)
# Make sure MPI is found
find_dependency(MPI)
# Make sure OpenMP is found
find_dependency(OpenMP)
# Propagate the multithreading backend
set(DUMUX_MULTITHREADING_BACKEND OpenMP)

# If this file is found in a super build that includes dumux, the 
# `dumux-targets.cmake`-file has not yet been generated. This variable
# determines whether the configuration of dumux has been completed.
get_property(dumux_IN_CONFIG_MODE GLOBAL PROPERTY dumux_LIBRARIES DEFINED)

#import the target
if(dumux_LIBRARIES AND NOT dumux_IN_CONFIG_MODE)
  get_filename_component(_dir "${CMAKE_CURRENT_LIST_FILE}" PATH)
  include("${_dir}/dumux-targets.cmake")
endif()

endif()
