
#ifndef DUMUX_CONFIG_HH
#define DUMUX_CONFIG_HH

/* Define to 1 if you have module dumux available */
#ifndef HAVE_DUMUX
#define HAVE_DUMUX 1
#endif





/* Define to the version of dumux */
#define DUMUX_VERSION "3.10.0"

/* Define to the major version of dumux */
#define DUMUX_VERSION_MAJOR 3

/* Define to the minor version of dumux */
#define DUMUX_VERSION_MINOR 10

/* Define to the revision of dumux */
#define DUMUX_VERSION_REVISION 0

/* Define the path to dumux */
#define DUMUX_SOURCE_DIR "/build/dumux/src/dumux-3.10.0"

/* Define the major version of opm-grid */
#define OPM_GRID_VERSION_MAJOR 

/* Define the minor version of opm-grid */
#define OPM_GRID_VERSION_MINOR 

/* Define to 1 if gnuplot was found */
/* #undef DUMUX_HAVE_GNUPLOT */

/* Define path to gnuplot executable */
/* #undef GNUPLOT_EXECUTABLE */

/* Define to 1 if gstat was found */
/* #undef DUMUX_HAVE_GSTAT */

/* Define path to gstat executable */
/* #undef GSTAT_EXECUTABLE */

/* Define to 1 if quadmath was found */
/* #undef DUMUX_HAVE_QUAD */

/* Set the DUMUX_MULTITHREADING_BACKEND */
#ifndef DUMUX_MULTITHREADING_BACKEND
#define DUMUX_MULTITHREADING_BACKEND OpenMP
#endif

/* Set DUMUX_HAVE_CPP_PARALLEL_ALGORITHMS if available */
#define DUMUX_HAVE_CPP_PARALLEL_ALGORITHMS 1





#if __has_include(<dune-common-config.hh>)
  #include <dune-common-config.hh>
#endif

#if __has_include(<dune-geometry-config.hh>)
  #include <dune-geometry-config.hh>
#endif

#if __has_include(<dune-grid-config.hh>)
  #include <dune-grid-config.hh>
#endif

#if __has_include(<dune-localfunctions-config.hh>)
  #include <dune-localfunctions-config.hh>
#endif

#if __has_include(<dune-istl-config.hh>)
  #include <dune-istl-config.hh>
#endif

#if __has_include(<dune-alugrid-config.hh>)
  #include <dune-alugrid-config.hh>
#endif

#if __has_include(<dune-foamgrid-config.hh>)
  #include <dune-foamgrid-config.hh>
#endif

#if __has_include(<dune-uggrid-config.hh>)
  #include <dune-uggrid-config.hh>
#endif

#if __has_include(<dune-functions-config.hh>)
  #include <dune-functions-config.hh>
#endif

#if __has_include(<opm-common-config.hh>)
  #include <opm-common-config.hh>
#endif

#if __has_include(<opm-grid-config.hh>)
  #include <opm-grid-config.hh>
#endif

#if __has_include(<dune-subgrid-config.hh>)
  #include <dune-subgrid-config.hh>
#endif

#if __has_include(<dune-spgrid-config.hh>)
  #include <dune-spgrid-config.hh>
#endif

#if __has_include(<dune-mmesh-config.hh>)
  #include <dune-mmesh-config.hh>
#endif


#endif // DUMUX_CONFIG_HH


#ifndef DUMUX_CONFIG_BOTTOM_HH
#define DUMUX_CONFIG_BOTTOM_HH



#endif // DUMUX_CONFIG_BOTTOM_HH
