/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.panel;

import com.jhlabs.image.GaussianFilter;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.event.PaletteEvent;
import gov.nasa.giss.ui.event.PaletteListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoPalette
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Color PALETTE_BACKGROUND = new Color(238, 238, 238);
    private static final Color TITLE_BACKGROUND = new Color(85, 85, 85, 51);
    private static final Color TITLE_BORDER_COLOR_1 = new Color(0, 0, 0, 51);
    private static final Color TITLE_BORDER_COLOR_2 = new Color(255, 255, 255, 102);
    private static final int CORNER_RADIUS = 6;
    private static final int CORNER_DIAMETER = 12;
    private static final int INS_LEFT = 4;
    private static final int INS_TOP = 4;
    private static final int INS_RIGHT = 8;
    private static final int INS_BOTTOM = 8;
    private static final float DROP_SIZE = 0.5f * (float)(Math.min(4, 4) + Math.min(8, 8));
    private static final float DROP_OFFSET = (float)Math.min(8, 8) - DROP_SIZE;
    private static final int TITLEBAR_HGT;
    private static final Font TITLE_FONT;
    private static final float TITLE_FSIZE;
    private static int lineHeight_;
    private static int lineAscent_;
    private boolean collapsible_ = true;
    private boolean expanded_ = true;
    private String title_;
    private int titleWidth_;
    private Color dropColor_ = new Color(0.0f, 0.0f, 0.0f, 0.67f);
    private BufferedImage dropShadow_;
    private final ArrayList<PaletteListener> listeners_ = new ArrayList(12);

    public PseudoPalette() {
        this("PseudoPalette");
    }

    public PseudoPalette(String title) {
        this(title, true);
    }

    public PseudoPalette(String title, boolean collapsible) {
        this.setTitle(title);
        this.setOpaque(true);
        this.setFont(TITLE_FONT);
        this.collapsible_ = collapsible;
        Border borderTB = BorderFactory.createEmptyBorder(TITLEBAR_HGT, 0, 0, 0);
        Border borderDS = BorderFactory.createEmptyBorder(4, 4, 8, 8);
        CompoundBorder bbb = BorderFactory.createCompoundBorder(borderDS, borderTB);
        super.setBorder(bbb);
        PaletteMouseHandler mph = new PaletteMouseHandler();
        this.addMouseListener(mph);
        this.addMouseMotionListener(mph);
    }

    public String getTitle() {
        return this.title_;
    }

    public void setTitle(String title) {
        this.title_ = title;
        this.setName(title);
        this.measure();
    }

    public boolean isCollapsible() {
        return this.collapsible_;
    }

    public boolean isExpanded() {
        return this.expanded_;
    }

    public void setExpanded(boolean expanded) {
        if (!this.collapsible_) {
            LOGGER.trace("Pseudo palette cannot be collapsed");
            return;
        }
        LOGGER.trace("{}", (Object)expanded);
        this.expanded_ = expanded;
        this.setSize(this.getPreferredSize());
        this.invalidate();
        Container c = this.getParent();
        if (c != null) {
            c.repaint();
        }
        this.fireStateChanged(expanded);
    }

    public float getDropShadowDarkness() {
        return (float)this.dropColor_.getAlpha() / 255.0f;
    }

    public void setDropShadowDarkness(float darkness) {
        if (darkness < 0.0f || darkness > 1.0f) {
            throw new IllegalArgumentException("Shadow darkness must be in range [0., 1.0]");
        }
        this.dropColor_ = new Color(0.0f, 0.0f, 0.0f, darkness);
    }

    public Insets getDropShadowInsets() {
        return new Insets(4, 4, 8, 8);
    }

    public int getTitlebarHeight() {
        return TITLEBAR_HGT;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (!this.expanded_) {
            d.height = TITLEBAR_HGT + 4 + 8;
        }
        return d;
    }

    @Override
    public final void setBorder(Border b) {
    }

    @Override
    public final void setFont(Font f) {
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    public void paintChildren(Graphics g) {
        if (!this.expanded_) {
            return;
        }
        super.paintChildren(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintShadow(g);
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        int ww = this.getWidth() - 4 - 8;
        g2d.setColor(PALETTE_BACKGROUND);
        g2d.fill(this.getPaletteArea());
        g2d.setColor(TITLE_BACKGROUND);
        g2d.fill(this.getTitleArea());
        if (this.titleWidth_ > 0) {
            int x = Math.max(0, (ww - this.titleWidth_) / 2);
            int y = (TITLEBAR_HGT - lineHeight_) / 2 + lineAscent_;
            g2d.setColor(Color.BLACK);
            g2d.drawString(this.title_, 4 + x, 4 + y);
        }
        if (this.expanded_) {
            g2d.setColor(TITLE_BORDER_COLOR_1);
            g2d.drawLine(4, 4 + TITLEBAR_HGT - 1, 4 + ww, 4 + TITLEBAR_HGT - 1);
            g2d.setColor(TITLE_BORDER_COLOR_2);
            g2d.drawLine(4, 4 + TITLEBAR_HGT, 4 + ww, 4 + TITLEBAR_HGT);
        }
        g2d.dispose();
    }

    private Area getTitleArea() {
        int ww = this.getWidth() - 4 - 8;
        Area area = null;
        if (this.expanded_) {
            area = new Area(new RoundRectangle2D.Double(4.0, 4.0, ww, TITLEBAR_HGT, 12.0, 12.0));
            area.add(new Area(new Rectangle(4, 4 + TITLEBAR_HGT - 6, ww, 6)));
        } else {
            area = new Area(new RoundRectangle2D.Double(4.0, 4.0, ww, TITLEBAR_HGT, 12.0, 12.0));
        }
        return area;
    }

    private void paintShadow(Graphics g) {
        Graphics2D g2d;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.dropShadow_ == null || this.dropShadow_.getWidth() != w || this.dropShadow_.getHeight() != h) {
            this.dropShadow_ = new BufferedImage(w, h, 2);
            g2d = this.dropShadow_.createGraphics();
            GraphicUtils.antialias(g2d);
            g2d.setColor(this.dropColor_);
            g2d.translate(DROP_OFFSET, DROP_OFFSET);
            g2d.fill(this.getPaletteArea());
            g2d.translate(-DROP_OFFSET, -DROP_OFFSET);
            g2d.dispose();
            GaussianFilter filter = new GaussianFilter(DROP_SIZE);
            this.dropShadow_ = filter.filter(this.dropShadow_, null);
        }
        g2d = GraphicUtils.createAntialiasedGfx(g);
        g2d.drawImage((Image)this.dropShadow_, 0, 0, null);
        g2d.dispose();
    }

    private Area getPaletteArea() {
        int w = this.getWidth() - 4 - 8;
        int h = this.getHeight() - 4 - 8;
        Area area = null;
        if (this.expanded_) {
            area = new Area(new RoundRectangle2D.Double(4.0, 4.0, w, h, 12.0, 12.0));
            area.add(new Area(new Rectangle(4, 4 + h - 6, w, 6)));
        } else {
            area = new Area(new RoundRectangle2D.Double(4.0, 4.0, w, TITLEBAR_HGT, 12.0, 12.0));
        }
        return area;
    }

    private void measure() {
        if (this.title_ == null || this.title_.length() == 0) {
            this.titleWidth_ = 0;
        } else {
            FontMetrics fm = this.getFontMetrics(TITLE_FONT);
            lineHeight_ = fm.getHeight();
            lineAscent_ = fm.getAscent();
            this.titleWidth_ = fm.stringWidth(this.title_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaletteListener(PaletteListener ll) {
        ArrayList<PaletteListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.add(ll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePaletteListener(PaletteListener ll) {
        ArrayList<PaletteListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            this.listeners_.remove(ll);
        }
    }

    public synchronized void removePaletteListeners() {
        this.listeners_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void fireStateChanged(boolean expand) {
        PaletteEvent e = expand ? new PaletteEvent(this, 101) : new PaletteEvent(this, 102);
        ArrayList<PaletteListener> arrayList = this.listeners_;
        synchronized (arrayList) {
            int isize = this.listeners_.size();
            if (isize > 0) {
                for (int i = isize - 1; i >= 0; --i) {
                    this.listeners_.get(i).paletteStateChanged(e);
                }
            }
        }
    }

    static {
        Font f = UIManager.getDefaults().getFont("Label.font");
        TITLE_FSIZE = 0.8f * f.getSize2D();
        TITLE_FONT = f.deriveFont(TITLE_FSIZE);
        TITLEBAR_HGT = (int)(TITLE_FSIZE * 1.8f);
    }

    private class PaletteMouseHandler
    extends MouseInputAdapter {
        private boolean dragInProgress_;
        private Point windowPoint_;
        private Point mousePoint_;

        @Override
        public void mouseClicked(MouseEvent e) {
            Container c = PseudoPalette.this.getParent();
            Point p = e.getPoint();
            if (PseudoPalette.this.collapsible_ && e.getClickCount() == 2 && this.inTitleBar(p)) {
                PseudoPalette.this.setExpanded(!PseudoPalette.this.isExpanded());
            } else if (this.inPalette(p)) {
                c.setComponentZOrder(PseudoPalette.this, 0);
            }
            c.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.movePalette(e.getPoint());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            if (!this.inTitleBar(p)) {
                return;
            }
            this.dragInProgress_ = true;
            this.windowPoint_ = PseudoPalette.this.getLocation();
            this.mousePoint_ = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.movePalette(e.getPoint());
            this.dragInProgress_ = false;
        }

        private void movePalette(Point p) {
            if (!this.dragInProgress_) {
                return;
            }
            int dx = p.x - this.mousePoint_.x;
            int dy = p.y - this.mousePoint_.y;
            this.windowPoint_.translate(dx, dy);
            PseudoPalette.this.setLocation(this.windowPoint_);
        }

        private boolean inTitleBar(Point p) {
            if (p == null) {
                return false;
            }
            return p.x >= 4 && p.x <= PseudoPalette.this.getWidth() - 8 && p.y >= 4 && p.y <= 4 + TITLEBAR_HGT;
        }

        private boolean inPalette(Point p) {
            if (p == null) {
                return false;
            }
            return p.x >= 4 && p.x <= PseudoPalette.this.getWidth() - 8 && p.y >= 4 && p.y <= PseudoPalette.this.getHeight() - 8;
        }
    }
}

