/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.filechooser;

import gov.nasa.giss.io.FtypeInfoHash;
import gov.nasa.giss.ui.filechooser.ExtFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Objects;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class SaveFileChooser
extends JFileChooser
implements ActionListener,
PropertyChangeListener {
    private static File recentPath_;

    public SaveFileChooser() {
        this.setDialogType(1);
        this.setDialogTitle("Save as\u2026");
        this.setFileName("Untitled");
        if (recentPath_ != null) {
            this.setCurrentDirectory(recentPath_);
        }
        this.setMultiSelectionEnabled(false);
        this.setAcceptAllFileFilterUsed(false);
        this.addActionListener(this);
        this.addPropertyChangeListener(this);
    }

    public SaveFileChooser(File f) {
        this();
        this.setCurrentDirectory(f);
        this.setSelectedFile(f);
    }

    public SaveFileChooser(File folder, String name) {
        this();
        this.setCurrentDirectory(folder);
        this.setFileName(name);
    }

    public SaveFileChooser(String[][] ftypeData) {
        this();
        this.createFiltersFromArrayData(ftypeData);
    }

    public SaveFileChooser(FtypeInfoHash ftHash, String ... keys) {
        this();
        String[][] ftypeData = ftHash.toFtypeInfoArray(keys);
        this.createFiltersFromArrayData(ftypeData);
    }

    public SaveFileChooser(File folder, String name, FtypeInfoHash ftHash, String ... keys) {
        this(folder, name);
        String[][] ftypeData = ftHash.toFtypeInfoArray(keys);
        this.createFiltersFromArrayData(ftypeData);
    }

    private void createFiltersFromArrayData(String[][] ftypeData) {
        for (int i = 0; i < ftypeData.length; ++i) {
            this.addChoosableFileFilter(new ExtFileFilter(ftypeData[i][1], ftypeData[i][2].split(",")));
        }
    }

    public final void setFileName(String fname) {
        Objects.requireNonNull(fname, "File name cannot be null.");
        try {
            File f = new File(this.getCurrentDirectory(), fname);
            this.setSelectedFile(f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JTextField findTextField(Component c) {
        if (c.getClass() == JTextField.class) {
            return (JTextField)c;
        }
        if (c instanceof Container) {
            for (Component child : ((Container)c).getComponents()) {
                JTextField found = this.findTextField(child);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    @Override
    public void approveSelection() {
        ExtFileFilter eff;
        File file = this.getSelectedFile();
        if (file == null) {
            this.cancelSelection();
            return;
        }
        FileFilter ff = this.getFileFilter();
        if (ff instanceof ExtFileFilter && !(eff = (ExtFileFilter)ff).accept(file)) {
            File xfile = new File(file.getParentFile(), file.getName() + "." + eff.getExtensions()[0]);
            this.setSelectedFile(xfile);
        }
        if (file.exists()) {
            int choice = JOptionPane.showOptionDialog(this, "A file by that name already exists.\nDo you want to replace it?", null, 0, 3, null, new String[]{"Replace", "Cancel"}, null);
            if (choice == 0) {
                super.approveSelection();
            }
        } else {
            super.approveSelection();
        }
    }

    public void setExtension(String ext) {
        FileFilter[] filters = this.getChoosableFileFilters();
        String fauxname = "foo." + ext;
        for (int i = 0; i < filters.length; ++i) {
            ExtFileFilter f = (ExtFileFilter)filters[i];
            if (!f.accept(fauxname)) continue;
            this.setFileFilter(f);
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ApproveSelection")) {
            recentPath_ = this.getCurrentDirectory();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        JTextField nameTF;
        String pname = e.getPropertyName();
        if (pname.equals("fileFilterChanged") && (nameTF = this.findTextField(this)) != null) {
            this.validateExtension();
        }
    }

    private void validateExtension() {
        JTextField nameTF = this.findTextField(this);
        if (nameTF == null) {
            return;
        }
        String fname = nameTF.getText();
        if (fname.lastIndexOf(46) < 1) {
            return;
        }
        FileFilter currentFilter = this.getFileFilter();
        if (!(currentFilter instanceof ExtFileFilter)) {
            return;
        }
        ExtFileFilter ceff = (ExtFileFilter)currentFilter;
        if (ceff.accept(fname)) {
            return;
        }
        for (FileFilter filter : this.getChoosableFileFilters()) {
            ExtFileFilter eff;
            if (!(filter instanceof ExtFileFilter) || !(eff = (ExtFileFilter)filter).accept(fname)) continue;
            int lastDot = fname.lastIndexOf(46);
            String xname = fname.substring(0, lastDot + 1) + ceff.getExtensions()[0];
            nameTF.setText(xname);
            return;
        }
    }
}

