/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.filechooser;

import gov.nasa.giss.io.FtypeInfoHash;
import gov.nasa.giss.ui.filechooser.ExtFileFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.invoke.MethodHandles;
import javax.swing.JFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFileChooser
extends JFileChooser
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static File recentPath_;

    public OpenFileChooser() {
        this.setDialogType(0);
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(false);
        if (recentPath_ != null) {
            this.setCurrentDirectory(recentPath_);
        }
        this.addActionListener(this);
    }

    public final void setCurrentDirectory(String dirpath) {
        if (dirpath == null || dirpath.length() == 0) {
            return;
        }
        try {
            File dir = new File(dirpath);
            if (!dir.exists()) {
                LOGGER.warn("Directory {} does not exist", (Object)dirpath);
                return;
            }
            this.setCurrentDirectory(new File(dirpath));
        }
        catch (Exception ignore) {
            LOGGER.warn("Could not set file chooser path to {}", (Object)dirpath);
        }
    }

    public void addFtypeDataFilters(FtypeInfoHash ftHash, String ... keys) {
        String[][] ftypeData = ftHash.toFtypeInfoArray(keys);
        this.addFtypeDataFilters(ftypeData);
    }

    public void addFtypeDataFilters(String[][] ftypeData) {
        for (int i = 0; i < ftypeData.length; ++i) {
            this.addChoosableFileFilter(new ExtFileFilter(ftypeData[i][1], ftypeData[i][2].split(",")));
        }
    }

    @Override
    public File[] getSelectedFiles() {
        if (this.isMultiSelectionEnabled()) {
            File[] ff = super.getSelectedFiles();
            if (ff == null) {
                return new File[0];
            }
            if (ff.length == 0) {
                return ff;
            }
            return ff;
        }
        File f = this.getSelectedFile();
        if (f == null) {
            return new File[0];
        }
        return new File[]{f};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ApproveSelection")) {
            recentPath_ = this.getCurrentDirectory();
        }
    }
}

