/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color.chooser;

import gov.nasa.giss.ui.color.chooser.ColorChooserPanel;
import gov.nasa.giss.ui.color.chooser.ColorChooserSlider;
import gov.nasa.giss.ui.color.chooser.ColorComponentID;
import java.awt.Color;

class HsbSlider
extends ColorChooserSlider {
    HsbSlider(ColorChooserPanel panel, ColorComponentID compID) {
        super(panel, compID);
    }

    @Override
    Color getColorAt(Color c, float pct) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        switch (this.compID_) {
            case HUE: {
                return Color.getHSBColor(pct, hsb[1], hsb[2]);
            }
            case SATURATION: {
                return Color.getHSBColor(hsb[0], pct, hsb[2]);
            }
            case BRIGHTNESS: {
                return Color.getHSBColor(hsb[0], hsb[1], pct);
            }
        }
        return c;
    }

    @Override
    float getTickXPct(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        switch (this.compID_) {
            case HUE: {
                return hsb[0];
            }
            case SATURATION: {
                return hsb[1];
            }
            case BRIGHTNESS: {
                return hsb[2];
            }
        }
        return 0.0f;
    }
}

