/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.util.PlatformUtils;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanPreferenceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String APPNAME = "Panoply";
    public static final String DOMAIN = "gov.nasa.giss";
    static final String ALTDIR = ".gissjava";

    static synchronized File findExtraPreferencesFile(String type, int majorVersion) {
        Objects.requireNonNull(type, "Settings type cannot be null.");
        File prefsDir = PanPreferences.findPrefsDirectory();
        if (prefsDir == null) {
            LOGGER.warn("Unable to find/access/create support directory.");
            LOGGER.warn("File Object for {} will be null.", (Object)type);
            return null;
        }
        StringBuilder fnameSB = new StringBuilder();
        if (PlatformUtils.isMacintosh()) {
            fnameSB.append(DOMAIN).append('.').append(APPNAME);
        } else {
            fnameSB.append(APPNAME.toLowerCase());
        }
        if (majorVersion > 0) {
            fnameSB.append('.').append(majorVersion);
        }
        fnameSB.append('.').append(type).append(".xml");
        String fname = fnameSB.toString();
        try {
            return new File(prefsDir, fname);
        }
        catch (Exception ignore) {
            throw new RuntimeException("Unable to create " + type + " File object.");
        }
    }

    private PanPreferenceUtils() {
    }
}

