/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class CantersPseudocylindricW33
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Canters Pseudocylindric W33";
    private static final double CP1 = 1.1988;
    private static final double CP3 = -0.129;
    private static final double CP5 = -0.0076;
    private static final double THREE_CP3 = -0.387;
    private static final double FIVE_CP5 = -0.038;
    private static final double PI2_OVER_4 = 2.4674011002723395;
    private static final double PI4_OVER_16 = 6.088068189625152;
    private static final double MAX_X_OVER_RS = 2.6206144924839783;
    private static final double MAX_Y_OVER_RS = 1.3104147499553833;

    public CantersPseudocylindricW33(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPseudocylindricW33(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.6206144924839783, 1.3104147499553833);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double capX = lambdaRad * cosPhi;
        double capY = phiRad;
        double capY2 = capY * capY;
        double capY4 = capY2 * capY2;
        double yp = (1.1988 + -0.129 * capY2 + -0.0076 * capY4) * capY;
        double dyp = 1.1988 + -0.387 * capY2 + -0.038 * capY4;
        double xp = capX / dyp;
        double x = (double)this.outCenterX_ + xp * this.rS_;
        double y = (double)this.outCenterY_ - yp * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double phiRad;
        double capY4;
        double capY2;
        double absYOverRS;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        if (absy > this.ymRS_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double yp = absYOverRS = absy * this.invRS_;
        if (absYOverRS < 1.0E-5) {
            // empty if block
        }
        double capY = 1.5707963267948966 * yp / this.ymRS_;
        for (int iter = 0; iter < 33; ++iter) {
            capY2 = capY * capY;
            capY4 = capY2 * capY2;
            double func = (1.1988 + -0.129 * capY2 + -0.0076 * capY4) * capY;
            double dfunc = 1.1988 + -0.387 * capY2 + -0.038 * capY4;
            double dCapY = -(func - yp) / dfunc;
            capY += dCapY;
            if (Math.abs(dCapY) < 1.0E-5) break;
        }
        if ((phiRad = capY) >= 1.5707963267948966) {
            return null;
        }
        double xp = absXOverRS;
        capY2 = capY * capY;
        capY4 = capY2 * capY2;
        double dyp = 1.1988 + -0.387 * capY2 + -0.038 * capY4;
        double capX = xp * dyp;
        double lambdaRad = capX / Math.cos(phiRad);
        if (Double.isNaN(lambdaRad) || lambdaRad > Math.PI) {
            return null;
        }
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CantersPseudocylindricW33 cantersPseudocylindricW33 = this;
        synchronized (cantersPseudocylindricW33) {
            double y;
            double capY = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
                double x;
                double xp;
                double capX;
                double lambdaRad;
                double phiRad;
                double capY4;
                double capY2;
                double yp = y * this.invRS_;
                capY += 1.0E-5;
                for (int iter = 0; iter < 33; ++iter) {
                    capY2 = capY * capY;
                    capY4 = capY2 * capY2;
                    double func = (1.1988 + -0.129 * capY2 + -0.0076 * capY4) * capY;
                    double dfunc = 1.1988 + -0.387 * capY2 + -0.038 * capY4;
                    double dCapY = -(func - yp) / dfunc;
                    capY += dCapY;
                    if (Math.abs(dCapY) < 1.0E-5) break;
                }
                if ((phiRad = capY) >= 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                capY2 = capY * capY;
                capY4 = capY2 * capY2;
                double dyp = 1.1988 + -0.387 * capY2 + -0.038 * capY4;
                double xFactor = 1.0 / Math.cos(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (capX = (xp = (x = (double)ix + 0.5) * this.invRS_) * dyp) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

