/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcodec.common.StringUtils;
import org.jcodec.common.io.IOUtils;
import org.jcodec.platform.Platform;

public class MainUtils {
    private static final String KEY_GIT_REVISION = "git.commit.id.abbrev";
    private static final String JCODEC_LOG_SINK_COLOR = "jcodec.colorPrint";
    private static final String GIT_PROPERTIES = "git.properties";
    public static boolean isColorSupported = System.console() != null || Boolean.parseBoolean(System.getProperty("jcodec.colorPrint"));
    private static Pattern flagPattern = Pattern.compile("^--([^=]+)=(.*)$");

    public static Cmd parseArguments(String[] args, Flag[] flags) {
        HashMap<String, String> longFlags = new HashMap<String, String>();
        HashMap<String, String> shortFlags = new HashMap<String, String>();
        HashMap<String, String> allLongFlags = new HashMap<String, String>();
        HashMap<String, String> allShortFlags = new HashMap<String, String>();
        ArrayList<String> outArgs = new ArrayList<String>();
        ArrayList<HashMap<String, String>> argLongFlags = new ArrayList<HashMap<String, String>>();
        ArrayList<HashMap<String, String>> argShortFlags = new ArrayList<HashMap<String, String>>();
        for (int arg = 0; arg < args.length; ++arg) {
            if (args[arg].startsWith("--")) {
                Matcher matcher = flagPattern.matcher(args[arg]);
                if (matcher.matches()) {
                    longFlags.put(matcher.group(1), matcher.group(2));
                    continue;
                }
                longFlags.put(args[arg].substring(2), "true");
                continue;
            }
            if (args[arg].startsWith("-")) {
                String shortName = args[arg].substring(1);
                boolean found = false;
                for (Flag flag : flags) {
                    if (!shortName.equals(flag.getShortName())) continue;
                    found = true;
                    if (flag.getType() != FlagType.VOID) {
                        shortFlags.put(shortName, args[++arg]);
                        continue;
                    }
                    shortFlags.put(shortName, "true");
                }
                if (found) continue;
                ++arg;
                continue;
            }
            allLongFlags.putAll(longFlags);
            allShortFlags.putAll(shortFlags);
            outArgs.add(args[arg]);
            argLongFlags.add(longFlags);
            argShortFlags.add(shortFlags);
            longFlags = new HashMap();
            shortFlags = new HashMap();
        }
        return new Cmd(allLongFlags, allShortFlags, outArgs.toArray(new String[0]), argLongFlags.toArray((Map[])Array.newInstance(longFlags.getClass(), 0)), argShortFlags.toArray((Map[])Array.newInstance(shortFlags.getClass(), 0)));
    }

    public static void printHelpVarArgs(Flag[] flags, String ... arguments) {
        MainUtils.printHelpOut(System.out, "", flags, Arrays.asList(arguments));
    }

    public static void printHelpArgs(Flag[] flags, String[] arguments) {
        MainUtils.printHelpOut(System.out, "", flags, Arrays.asList(arguments));
    }

    public static void printHelp(Flag[] flags, List<String> params) {
        MainUtils.printHelpOut(System.out, "", flags, params);
    }

    public static void printHelpNoFlags(String ... arguments) {
        MainUtils.printHelpOut(System.out, "", new Flag[0], Arrays.asList(arguments));
    }

    public static void printHelpCmdVa(String command, Flag[] flags, String ... arguments) {
        MainUtils.printHelpOut(System.out, command, flags, Arrays.asList(arguments));
    }

    public static void printHelpCmd(String command, Flag[] flags, List<String> params) {
        MainUtils.printHelpOut(System.out, command, flags, params);
    }

    private static String getGitRevision() {
        block5: {
            String string;
            InputStream is;
            block4: {
                is = null;
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(GIT_PROPERTIES);
                if (is != null) break block4;
                String string2 = null;
                IOUtils.closeQuietly(is);
                return string2;
            }
            try {
                Properties properties = new Properties();
                properties.load(is);
                string = (String)properties.get(KEY_GIT_REVISION);
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(is);
                break block5;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly(is);
            return string;
        }
        return null;
    }

    public static void printHelpOut(PrintStream out, String command, Flag[] flags, List<String> params) {
        String version = MainUtils.class.getPackage().getImplementationVersion();
        String gitRevision = MainUtils.getGitRevision();
        if (command == null || command.isEmpty()) {
            command = "jcodec";
        }
        if (gitRevision != null || version != null) {
            out.println(command + MainUtils.bold((version != null ? " v." + version : "") + (gitRevision != null ? " rev. " + gitRevision : "")));
            out.println();
        }
        out.print(MainUtils.bold("Syntax: " + command));
        StringBuilder sample = new StringBuilder();
        StringBuilder detail = new StringBuilder();
        for (Flag flag : flags) {
            sample.append(" [");
            detail.append("\t");
            if (flag.getLongName() != null) {
                sample.append(MainUtils.bold(MainUtils.color("--" + flag.getLongName() + "=<value>", ANSIColor.MAGENTA)));
                detail.append(MainUtils.bold(MainUtils.color("--" + flag.getLongName(), ANSIColor.MAGENTA)));
            }
            if (flag.getShortName() != null) {
                if (flag.getLongName() != null) {
                    sample.append(" (");
                    detail.append(" (");
                }
                sample.append(MainUtils.bold(MainUtils.color("-" + flag.getShortName() + " <value>", ANSIColor.MAGENTA)));
                detail.append(MainUtils.bold(MainUtils.color("-" + flag.getShortName(), ANSIColor.MAGENTA)));
                if (flag.getLongName() != null) {
                    sample.append(")");
                    detail.append(")");
                }
            }
            sample.append("]");
            detail.append("\t\t" + flag.getDescription() + "\n");
        }
        for (String param : params) {
            if (param.charAt(0) != '?') {
                sample.append(MainUtils.bold(" <" + param + ">"));
                continue;
            }
            sample.append(MainUtils.bold(" [" + param.substring(1) + "]"));
        }
        out.println(sample);
        out.println(MainUtils.bold("Where:"));
        out.println(detail);
    }

    public static String bold(String str) {
        return isColorSupported ? "\u001b[1m" + str + "\u001b[0m" : str;
    }

    public static String colorString(String str, String placeholder) {
        return isColorSupported ? "\u001b[" + placeholder + "m" + str + "\u001b[0m" : str;
    }

    public static String color(String str, ANSIColor fg) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + "m" + str + "\u001b[0m" : str;
    }

    public static String colorBright(String str, ANSIColor fg, boolean bright) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + ";" + (bright ? 1 : 2) + "m" + str + "\u001b[0m" : str;
    }

    public static String color3(String str, ANSIColor fg, ANSIColor bg) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + ";" + (40 + (bg.ordinal() & 7)) + ";1m" + str + "\u001b[0m" : str;
    }

    public static String color4(String str, ANSIColor fg, ANSIColor bg, boolean bright) {
        return isColorSupported ? "\u001b[" + (30 + (fg.ordinal() & 7)) + ";" + (40 + (bg.ordinal() & 7)) + ";" + (bright ? 1 : 2) + "m" + str + "\u001b[0m" : str;
    }

    public static File tildeExpand(String path) {
        if (path.startsWith("~")) {
            path = path.replaceFirst("~", System.getProperty("user.home"));
        }
        return new File(path);
    }

    public static enum ANSIColor {
        BLACK,
        RED,
        GREEN,
        BROWN,
        BLUE,
        MAGENTA,
        CYAN,
        GREY;

    }

    public static class Cmd {
        public Map<String, String> longFlags;
        public Map<String, String> shortFlags;
        public String[] args;
        private Map<String, String>[] longArgFlags;
        private Map<String, String>[] shortArgFlags;

        public Cmd(Map<String, String> longFlags, Map<String, String> shortFlags, String[] args, Map<String, String>[] longArgFlags, Map<String, String>[] shortArgFlags) {
            this.args = args;
            this.longFlags = longFlags;
            this.shortFlags = shortFlags;
            this.longArgFlags = longArgFlags;
            this.shortArgFlags = shortArgFlags;
        }

        private Long getLongFlagInternal(Map<String, String> longFlags, Map<String, String> shortFlags, Flag flag, Long defaultValue) {
            return longFlags.containsKey(flag.getLongName()) ? new Long(longFlags.get(flag.getLongName())) : (shortFlags.containsKey(flag.getShortName()) ? new Long(shortFlags.get(flag.getShortName())) : defaultValue);
        }

        private Integer getIntegerFlagInternal(Map<String, String> longFlags, Map<String, String> shortFlags, Flag flag, Integer defaultValue) {
            return longFlags.containsKey(flag.getLongName()) ? new Integer(longFlags.get(flag.getLongName())) : (shortFlags.containsKey(flag.getShortName()) ? new Integer(shortFlags.get(flag.getShortName())) : defaultValue);
        }

        private Boolean getBooleanFlagInternal(Map<String, String> longFlags, Map<String, String> shortFlags, Flag flag, Boolean defaultValue) {
            return longFlags.containsKey(flag.getLongName()) ? !"false".equalsIgnoreCase(longFlags.get(flag.getLongName())) : (shortFlags.containsKey(flag.getShortName()) ? !"false".equalsIgnoreCase(shortFlags.get(flag.getShortName())) : defaultValue);
        }

        private Double getDoubleFlagInternal(Map<String, String> longFlags, Map<String, String> shortFlags, Flag flag, Double defaultValue) {
            return longFlags.containsKey(flag.getLongName()) ? new Double(longFlags.get(flag.getLongName())) : (shortFlags.containsKey(flag.getShortName()) ? new Double(shortFlags.get(flag.getShortName())) : defaultValue);
        }

        private String getStringFlagInternal(Map<String, String> longFlags, Map<String, String> shortFlags, Flag flag, String defaultValue) {
            return longFlags.containsKey(flag.getLongName()) ? longFlags.get(flag.getLongName()) : (shortFlags.containsKey(flag.getShortName()) ? shortFlags.get(flag.getShortName()) : defaultValue);
        }

        private int[] getMultiIntegerFlagInternal(Map<String, String> longFlags, Map<String, String> shortFlags, Flag flag, int[] defaultValue) {
            String flagValue;
            if (longFlags.containsKey(flag.getLongName())) {
                flagValue = longFlags.get(flag.getLongName());
            } else if (shortFlags.containsKey(flag.getShortName())) {
                flagValue = shortFlags.get(flag.getShortName());
            } else {
                return defaultValue;
            }
            String[] split = StringUtils.splitS(flagValue, ",");
            int[] result = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                result[i] = Integer.parseInt(split[i]);
            }
            return result;
        }

        private <T extends Enum<T>> T getEnumFlagInternal(Map<String, String> longFlags, Map<String, String> shortFlags, Flag flag, T defaultValue, Class<T> class1) {
            String flagValue;
            if (longFlags.containsKey(flag.getLongName())) {
                flagValue = longFlags.get(flag.getLongName());
            } else if (shortFlags.containsKey(flag.getShortName())) {
                flagValue = shortFlags.get(flag.getShortName());
            } else {
                return defaultValue;
            }
            String strVal = flagValue.toLowerCase();
            EnumSet<Enum> allOf = EnumSet.allOf(class1);
            for (Enum val : allOf) {
                if (!val.name().toLowerCase().equals(strVal)) continue;
                return (T)val;
            }
            return null;
        }

        public Long getLongFlagD(Flag flagName, Long defaultValue) {
            return this.getLongFlagInternal(this.longFlags, this.shortFlags, flagName, defaultValue);
        }

        public Long getLongFlag(Flag flagName) {
            return this.getLongFlagInternal(this.longFlags, this.shortFlags, flagName, null);
        }

        public Long getLongFlagID(int arg, Flag flagName, Long defaultValue) {
            return this.getLongFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, defaultValue);
        }

        public Long getLongFlagI(int arg, Flag flagName) {
            return this.getLongFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, null);
        }

        public Integer getIntegerFlagD(Flag flagName, Integer defaultValue) {
            return this.getIntegerFlagInternal(this.longFlags, this.shortFlags, flagName, defaultValue);
        }

        public Integer getIntegerFlag(Flag flagName) {
            return this.getIntegerFlagInternal(this.longFlags, this.shortFlags, flagName, null);
        }

        public Integer getIntegerFlagID(int arg, Flag flagName, Integer defaultValue) {
            return this.getIntegerFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, defaultValue);
        }

        public Integer getIntegerFlagI(int arg, Flag flagName) {
            return this.getIntegerFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, null);
        }

        public Boolean getBooleanFlagD(Flag flagName, Boolean defaultValue) {
            return this.getBooleanFlagInternal(this.longFlags, this.shortFlags, flagName, defaultValue);
        }

        public Boolean getBooleanFlag(Flag flagName) {
            return this.getBooleanFlagInternal(this.longFlags, this.shortFlags, flagName, false);
        }

        public Boolean getBooleanFlagID(int arg, Flag flagName, Boolean defaultValue) {
            return this.getBooleanFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, defaultValue);
        }

        public Boolean getBooleanFlagI(int arg, Flag flagName) {
            return this.getBooleanFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, false);
        }

        public Double getDoubleFlagD(Flag flagName, Double defaultValue) {
            return this.getDoubleFlagInternal(this.longFlags, this.shortFlags, flagName, defaultValue);
        }

        public Double getDoubleFlag(Flag flagName) {
            return this.getDoubleFlagInternal(this.longFlags, this.shortFlags, flagName, null);
        }

        public Double getDoubleFlagID(int arg, Flag flagName, Double defaultValue) {
            return this.getDoubleFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, defaultValue);
        }

        public Double getDoubleFlagI(int arg, Flag flagName) {
            return this.getDoubleFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, null);
        }

        public String getStringFlagD(Flag flagName, String defaultValue) {
            return this.getStringFlagInternal(this.longFlags, this.shortFlags, flagName, defaultValue);
        }

        public String getStringFlag(Flag flagName) {
            return this.getStringFlagInternal(this.longFlags, this.shortFlags, flagName, null);
        }

        public String getStringFlagID(int arg, Flag flagName, String defaultValue) {
            return this.getStringFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, defaultValue);
        }

        public String getStringFlagI(int arg, Flag flagName) {
            return this.getStringFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, null);
        }

        public int[] getMultiIntegerFlagD(Flag flagName, int[] defaultValue) {
            return this.getMultiIntegerFlagInternal(this.longFlags, this.shortFlags, flagName, defaultValue);
        }

        public int[] getMultiIntegerFlag(Flag flagName) {
            return this.getMultiIntegerFlagInternal(this.longFlags, this.shortFlags, flagName, new int[0]);
        }

        public int[] getMultiIntegerFlagID(int arg, Flag flagName, int[] defaultValue) {
            return this.getMultiIntegerFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, defaultValue);
        }

        public int[] getMultiIntegerFlagI(int arg, Flag flagName) {
            return this.getMultiIntegerFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, new int[0]);
        }

        public <T extends Enum<T>> T getEnumFlagD(Flag flagName, T defaultValue, Class<T> class1) {
            return this.getEnumFlagInternal(this.longFlags, this.shortFlags, flagName, defaultValue, class1);
        }

        public <T extends Enum<T>> T getEnumFlag(Flag flagName, Class<T> class1) {
            return this.getEnumFlagInternal(this.longFlags, this.shortFlags, flagName, null, class1);
        }

        public <T extends Enum<T>> T getEnumFlagID(int arg, Flag flagName, T defaultValue, Class<T> class1) {
            return this.getEnumFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, defaultValue, class1);
        }

        public <T extends Enum<T>> T getEnumFlagI(int arg, Flag flagName, Class<T> class1) {
            return this.getEnumFlagInternal(this.longArgFlags[arg], this.shortArgFlags[arg], flagName, null, class1);
        }

        public String getArg(int i) {
            return i < this.args.length ? this.args[i] : null;
        }

        public int argsLength() {
            return this.args.length;
        }

        public void popArg() {
            this.args = Platform.copyOfRangeO(this.args, 1, this.args.length);
        }
    }

    public static class Flag {
        private String longName;
        private String shortName;
        private String description;
        private FlagType type;

        public Flag(String longName, String description) {
            this(longName, null, description);
        }

        public Flag(String longName, String shortName, String description) {
            this(longName, shortName, description, FlagType.ANY);
        }

        public Flag(String longName, String shortName, String description, FlagType type) {
            this.longName = longName;
            this.shortName = shortName;
            this.description = description;
            this.type = type;
        }

        public String getLongName() {
            return this.longName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getShortName() {
            return this.shortName;
        }

        public FlagType getType() {
            return this.type;
        }
    }

    public static enum FlagType {
        VOID,
        STRING,
        INT,
        LONG,
        DOUBLE,
        MULT,
        ENUM,
        ANY;

    }
}

