/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefs;

import gov.nasa.giss.data.nc.NcCatalog;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefs.PanBookmark;
import gov.nasa.giss.panoply.prefs.PanBookmarkList;
import gov.nasa.giss.panoply.prefs.PanBookmarkType;
import gov.nasa.giss.panoply.prefs.PanHistoryFolder;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.Objects;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanHistoryList
extends PanBookmarkList {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static PanHistoryList getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanHistoryList() {
    }

    @Override
    public String getName() {
        if (this.isNameSet()) {
            return super.getName();
        }
        return "history";
    }

    @Override
    public String getAddress() {
        return "history";
    }

    @Override
    public void add(TreeTableNode child) {
        Objects.requireNonNull(child, "Cannot add a null child.");
        if (!(child instanceof PanHistoryFolder)) {
            throw new IllegalArgumentException("Can only add day folders to history list.");
        }
        super.add(child);
    }

    @Override
    public void add(int index, TreeTableNode child) {
        Objects.requireNonNull(child, "Cannot add a null child.");
        if (!(child instanceof PanHistoryFolder)) {
            throw new IllegalArgumentException("Can only add day folders to history list.");
        }
        super.add(index, child);
    }

    public void enforceAgeLimit() {
        PanHistoryFolder hf;
        int limit = PanPreferences.getSharedInstance().getInt("files:history.days");
        int xlimit = limit;
        if (xlimit < 1) {
            xlimit = 60;
            LOGGER.warn("History age limit less than 1. Using 60 days instead.");
        }
        TreeTableNode[] children = this.getChildren();
        for (int i = children.length - 1; i >= 0 && (hf = (PanHistoryFolder)children[i]).getAge() > xlimit; --i) {
            this.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBookmark(NcDataset ncd) {
        PanBookmark b;
        block9: {
            Objects.requireNonNull(ncd, "NcDataset cannot be null.");
            LOGGER.trace("add dataset {}", (Object)ncd);
            String addrStr = ncd.getAddress();
            int colon = addrStr.indexOf(58);
            String prot = colon > 0 ? addrStr.substring(0, colon) : "";
            b = null;
            try {
                if (PanFileUtils.isLocalFile(addrStr)) {
                    b = new PanBookmark(PanBookmarkType.LOCAL_DATASET, (Object)addrStr, null);
                    break block9;
                }
                if ("http".equals(prot) || "https".equals(prot) || "ftp".equals(prot)) {
                    b = new PanBookmark(PanBookmarkType.REMOTE_DATASET, (Object)addrStr, null);
                    break block9;
                }
                if ("dap4".equals(prot) || "dods".equals(prot) || "cdms3".equals(prot) || "s3".equals(prot)) {
                    b = new PanBookmark(PanBookmarkType.REMOTE_DATASET, (Object)addrStr, null);
                    break block9;
                }
                throw new RuntimeException("Dataset access protocol '" + prot + "' not understood");
            }
            catch (Exception exc) {
                LOGGER.warn("Bad bookmark: {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block9;
                exc.printStackTrace();
            }
        }
        if (b == null) {
            LOGGER.debug("Somehow, bookmark is null");
            return;
        }
        PanHistoryList panHistoryList = this;
        synchronized (panHistoryList) {
            this.addBookmark(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBookmark(NcCatalog c) {
        Objects.requireNonNull(c, "Catalog cannot be null.");
        LOGGER.trace("Add catalog {}", (Object)c);
        PanHistoryList panHistoryList = this;
        synchronized (panHistoryList) {
            try {
                PanBookmark b = new PanBookmark(PanBookmarkType.CATALOG, (Object)c.getURI(), null);
                this.addBookmark(b);
            }
            catch (Exception exc) {
                LOGGER.warn("Couldn't add bookmark for {}", (Object)c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBookmark(PanBookmark b) {
        Objects.requireNonNull(b, "Bookmark cannot be null.");
        PanHistoryList panHistoryList = this;
        synchronized (panHistoryList) {
            PanHistoryFolder folder = this.getTodayFolder();
            folder.add(0, b);
            b.setParent(folder);
        }
    }

    public PanHistoryFolder getTodayFolder() {
        PanHistoryFolder hf;
        if (this.getChildCount() > 0 && (hf = (PanHistoryFolder)this.getChildAt(0)).isTodayFolder()) {
            return hf;
        }
        LocalDate offsetLDT = LocalDate.now();
        int year = offsetLDT.getYear();
        int month = offsetLDT.getMonthValue();
        int day = offsetLDT.getDayOfMonth();
        PanHistoryFolder folder = new PanHistoryFolder(this, year, month, day);
        this.add(0, folder);
        return folder;
    }

    @Override
    void write(Element parentElement) throws IOException {
        this.enforceAgeLimit();
        this.writeGroup(parentElement, this);
    }

    private static class Singleton {
        private static final PanHistoryList INSTANCE = new PanHistoryList();

        private Singleton() {
        }
    }
}

