/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.ui;

import gov.nasa.giss.data.nc.NcDimension;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcDimensionListModel
extends AbstractListModel<String>
implements ComboBoxModel<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final NcDimension ncdim_;
    private final int length_;
    private final boolean hasBounds_;
    private String selectedItem_;

    public NcDimensionListModel(NcDimension ncdim) {
        this.ncdim_ = ncdim;
        this.length_ = ncdim.getLength();
        this.hasBounds_ = ncdim.hasBounds();
        this.selectedItem_ = this.getElementAt(0);
        LOGGER.trace("dim {}, length {}, hasBounds {}", this.ncdim_, this.length_, this.hasBounds_);
    }

    @Override
    public String getSelectedItem() {
        return this.selectedItem_;
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item != null && !(item instanceof String)) {
            throw new IllegalArgumentException("Item must be a String");
        }
        String ss = (String)item;
        if (this.selectedItem_ != null && !this.selectedItem_.equals(ss) || this.selectedItem_ == null && ss != null) {
            this.selectedItem_ = ss;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public int getSize() {
        return this.length_;
    }

    @Override
    public final String getElementAt(int index) {
        String result;
        if (index < 0 || index >= this.length_) {
            return null;
        }
        if (this.hasBounds_ && (result = this.ncdim_.formattedBoundsAt(index)) != null) {
            return result;
        }
        result = this.ncdim_.formattedValueAt(index);
        if (result != null) {
            return result;
        }
        return Integer.toString(index + 1);
    }
}

