/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.fitting.leastsquares;

import java.util.Arrays;
import org.apache.commons.math4.legacy.analysis.MultivariateVectorFunction;
import org.apache.commons.math4.legacy.analysis.UnivariateVectorFunction;
import org.apache.commons.math4.legacy.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.legacy.analysis.differentiation.UnivariateVectorFunctionDifferentiator;
import org.apache.commons.math4.legacy.core.Pair;
import org.apache.commons.math4.legacy.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math4.legacy.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.legacy.linear.ArrayRealVector;
import org.apache.commons.math4.legacy.linear.RealMatrix;
import org.apache.commons.math4.legacy.linear.RealVector;

public class DifferentiatorVectorMultivariateJacobianFunction
implements MultivariateJacobianFunction {
    private final MultivariateVectorFunction function;
    private final UnivariateVectorFunctionDifferentiator differentiator;

    public DifferentiatorVectorMultivariateJacobianFunction(MultivariateVectorFunction function, UnivariateVectorFunctionDifferentiator differentiator) {
        this.function = function;
        this.differentiator = differentiator;
    }

    @Override
    public Pair<RealVector, RealMatrix> value(RealVector point) {
        double[] testArray = point.toArray();
        ArrayRealVector value = new ArrayRealVector(this.function.value(testArray));
        Array2DRowRealMatrix jacobian = new Array2DRowRealMatrix(((RealVector)value).getDimension(), point.getDimension());
        for (int column = 0; column < point.getDimension(); ++column) {
            int columnFinal = column;
            double originalPoint = point.getEntry(column);
            double[] partialDerivatives = this.getPartialDerivative(testPoint -> {
                testArray[columnFinal] = testPoint;
                return this.function.value(testArray);
            }, originalPoint);
            testArray[column] = originalPoint;
            jacobian.setColumn(column, partialDerivatives);
        }
        return new Pair((Object)value, (Object)jacobian);
    }

    private double[] getPartialDerivative(UnivariateVectorFunction univariateVectorFunction, double atParameterValue) {
        DerivativeStructure[] derivatives = this.differentiator.differentiate(univariateVectorFunction).value(new DerivativeStructure(1, 1, 0, atParameterValue));
        return Arrays.stream(derivatives).mapToDouble(derivative -> derivative.getPartialDerivative(1)).toArray();
    }
}

