/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.tables.CodeFlagTables;

public class TableA {
    private static Logger log = LoggerFactory.getLogger(TableA.class);
    private static final String TABLEA_FILENAME = "wmo/BUFR_41_0_0_TableA_en.xml";
    private static Map<Integer, Descriptor> tableA;
    private final String name;
    private final String location;

    private static void init() {
        String filename = "/resources/bufrTables/wmo/BUFR_41_0_0_TableA_en.xml";
        try (InputStream is = CodeFlagTables.class.getResourceAsStream(filename);){
            HashMap<Integer, Descriptor> map = new HashMap<Integer, Descriptor>(100);
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            Document tdoc = builder.build(is);
            Element root = tdoc.getRootElement();
            List elems = root.getChildren();
            for (Element elem : elems) {
                String line = elem.getChildText("No");
                String codeS = elem.getChildText("CodeFigure");
                String desc = elem.getChildText("Meaning_en");
                try {
                    int code = Integer.parseInt(codeS);
                    Descriptor descriptor = new Descriptor(code, desc);
                    map.put(code, descriptor);
                }
                catch (NumberFormatException e) {
                    log.debug("NumberFormatException on line " + line + " in " + codeS);
                }
            }
            tableA = map;
        }
        catch (Exception e) {
            log.error("Can't read BUFR code table " + filename, (Throwable)e);
        }
    }

    public TableA(String name, String location) {
        this.name = name;
        this.location = location;
        tableA = new HashMap<Integer, Descriptor>();
    }

    public Descriptor getDescriptor(int code) {
        if (tableA == null) {
            TableA.init();
        }
        return tableA.get(code);
    }

    public static String getDataCategory(int cat) {
        Descriptor descriptor;
        if (tableA == null) {
            TableA.init();
        }
        return (descriptor = tableA.get(cat)) != null ? descriptor.getDescription() : "Unknown category=" + cat;
    }

    public static String getDataCategoryName(int cat) {
        Descriptor descriptor;
        if (tableA == null) {
            TableA.init();
        }
        return (descriptor = tableA.get(cat)) != null ? descriptor.getName() : "obs_" + cat;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public Descriptor addDescriptor(int code, String description) {
        Descriptor d = new Descriptor(code, description);
        tableA.put(code, d);
        return d;
    }

    public static class Descriptor
    implements Comparable<Descriptor> {
        private int code;
        private String name;
        private String description;
        private boolean localOverride;

        Descriptor(int code, String description) {
            this.code = code;
            this.description = description;
            this.name = "obs_" + String.valueOf(code);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return String.valueOf(this.code) + " " + this.getName() + " " + this.description;
        }

        @Override
        public int compareTo(Descriptor o) {
            return this.code - o.getCode();
        }

        public boolean isLocal() {
            return this.code >= 102 && this.code <= 239;
        }

        public void setLocalOverride(boolean isOverride) {
            this.localOverride = isOverride;
        }

        public boolean getLocalOverride() {
            return this.localOverride;
        }
    }
}

