/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import org.apache.commons.geometry.core.Spatial;
import org.apache.commons.geometry.core.internal.SimpleTupleFormat;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.numbers.angle.Angle;

public final class PolarCoordinates
implements Spatial {
    private final double radius;
    private final double azimuth;

    private PolarCoordinates(double radius, double azimuth) {
        double rad = radius;
        double az = azimuth;
        if (rad < 0.0) {
            rad = Math.abs(radius);
            az += Math.PI;
        }
        this.radius = rad;
        this.azimuth = PolarCoordinates.normalizeAzimuth(az);
    }

    public double getRadius() {
        return this.radius;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public int getDimension() {
        return 2;
    }

    public boolean isNaN() {
        return Double.isNaN(this.radius) || Double.isNaN(this.azimuth);
    }

    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.radius) || Double.isInfinite(this.azimuth));
    }

    public boolean isFinite() {
        return Double.isFinite(this.radius) && Double.isFinite(this.azimuth);
    }

    public Vector2D toCartesian() {
        return PolarCoordinates.toCartesian(this.radius, this.azimuth);
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 191;
        }
        return 449 * (76 * Double.hashCode(this.radius) + Double.hashCode(this.azimuth));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PolarCoordinates) {
            PolarCoordinates rhs = (PolarCoordinates)other;
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            return Double.compare(this.radius, rhs.radius) == 0 && Double.compare(this.azimuth, rhs.azimuth) == 0;
        }
        return false;
    }

    public String toString() {
        return SimpleTupleFormat.getDefault().format(this.radius, this.azimuth);
    }

    public static PolarCoordinates of(double radius, double azimuth) {
        return new PolarCoordinates(radius, azimuth);
    }

    public static PolarCoordinates fromCartesian(double x, double y) {
        double azimuth = Math.atan2(y, x);
        double radius = Math.hypot(x, y);
        return new PolarCoordinates(radius, azimuth);
    }

    public static PolarCoordinates fromCartesian(Vector2D vec) {
        return PolarCoordinates.fromCartesian(vec.getX(), vec.getY());
    }

    public static Vector2D toCartesian(double radius, double azimuth) {
        double x = radius * Math.cos(azimuth);
        double y = radius * Math.sin(azimuth);
        return Vector2D.of(x, y);
    }

    public static PolarCoordinates parse(String input) {
        return (PolarCoordinates)SimpleTupleFormat.getDefault().parse(input, PolarCoordinates::new);
    }

    public static double normalizeAzimuth(double azimuth) {
        if (Double.isFinite(azimuth)) {
            return Angle.Rad.WITHIN_0_AND_2PI.applyAsDouble(azimuth);
        }
        return azimuth;
    }
}

