/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.SampleSet;

public final class FrequencyMap<T> {
    private final ConcurrentHashMap<T, LongAdder> myMap = new ConcurrentHashMap();
    private final LongAdder myPopulation = new LongAdder();

    public FrequencyMap() {
    }

    public FrequencyMap(Iterable<? extends T> initial) {
        for (T element : initial) {
            this.get(element);
        }
    }

    public void add(T element, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException();
        }
        this.get(element).add(count);
        this.myPopulation.add(count);
    }

    public void addAll(Map<? extends T, ? extends Number> frequencies) {
        for (Map.Entry<T, Number> entry : frequencies.entrySet()) {
            this.add(entry.getKey(), entry.getValue().longValue());
        }
    }

    public void addAll(Set<? extends T> elements, long count) {
        for (T element : elements) {
            this.add(element, count);
        }
    }

    public Set<T> elements() {
        return this.myMap.keySet();
    }

    public Set<T> elements(FrequencyPredicate<T> predicate) {
        HashSet<T> retVal = new HashSet<T>();
        SampleSet statistics = this.sample();
        for (Map.Entry<T, LongAdder> entry : this.myMap.entrySet()) {
            T element = entry.getKey();
            if (!predicate.test(element, statistics, entry.getValue().longValue())) continue;
            retVal.add(element);
        }
        return retVal;
    }

    public long getFrequency(T element) {
        return this.myMap.getOrDefault(element, new LongAdder()).longValue();
    }

    public long getMaximumFrequenecy() {
        Map.Entry<T, LongAdder> entryWithHighestFrequenecy = this.getEntryWithHighestFrequenecy();
        if (entryWithHighestFrequenecy != null) {
            return entryWithHighestFrequenecy.getValue().longValue();
        }
        return 0L;
    }

    public T getMode() {
        Map.Entry<T, LongAdder> entryWithHighestFrequenecy = this.getEntryWithHighestFrequenecy();
        if (entryWithHighestFrequenecy != null) {
            return entryWithHighestFrequenecy.getKey();
        }
        return null;
    }

    public double getRelativeFrequency(T element) {
        long populationSize = this.populationSize();
        if (populationSize == 0L) {
            return PrimitiveMath.ZERO;
        }
        return (double)this.getFrequency(element) / (double)populationSize;
    }

    public void increment(T element) {
        this.get(element).increment();
        this.myPopulation.increment();
    }

    public void incrementAll(Iterable<? extends T> elements) {
        for (T element : elements) {
            this.increment(element);
        }
    }

    public void merge(FrequencyMap<T> other) {
        this.addAll(other.getMap());
    }

    public void merge(FrequencyMap<T> other, FrequencyPredicate<T> predicate) {
        SampleSet statistics = other.sample();
        for (Map.Entry<T, LongAdder> entry : other.getMap().entrySet()) {
            long frequency;
            T element = entry.getKey();
            if (!predicate.test(element, statistics, frequency = entry.getValue().longValue())) continue;
            this.add(element, frequency);
        }
    }

    public int numberOfKnownKeys() {
        return this.myMap.size();
    }

    public long populationSize() {
        return this.myPopulation.longValue();
    }

    public void reset() {
        this.myMap.clear();
        this.myPopulation.reset();
    }

    public void retainIf(FrequencyPredicate<T> predicate) {
        SampleSet statistics = this.sample();
        for (Map.Entry<T, LongAdder> entry : this.myMap.entrySet()) {
            T element = entry.getKey();
            if (predicate.test(element, statistics, entry.getValue().longValue())) continue;
            this.myMap.remove(element);
        }
    }

    public SampleSet sample() {
        Set<Map.Entry<T, LongAdder>> entries = this.myMap.entrySet();
        double[] frequencies = new double[entries.size()];
        int index = 0;
        for (Map.Entry<T, LongAdder> entry : entries) {
            frequencies[index++] = entry.getValue().doubleValue();
        }
        return SampleSet.wrap(frequencies);
    }

    private LongAdder get(T element) {
        return this.myMap.computeIfAbsent(element, k -> new LongAdder());
    }

    private Map.Entry<T, LongAdder> getEntryWithHighestFrequenecy() {
        Map.Entry<T, LongAdder> retVal = null;
        long maximum = 0L;
        for (Map.Entry<T, LongAdder> entry : this.myMap.entrySet()) {
            if (entry.getValue().longValue() <= maximum) continue;
            maximum = entry.getValue().longValue();
            retVal = entry;
        }
        return retVal;
    }

    ConcurrentHashMap<T, LongAdder> getMap() {
        return this.myMap;
    }

    @FunctionalInterface
    public static interface FrequencyPredicate<T> {
        public boolean test(T var1, SampleSet var2, long var3);
    }
}

