/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.extension.gui.dock.theme.BubbleTheme;
import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.FlatTheme;
import bibliothek.extension.gui.dock.theme.SmoothTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemePropertyFactory;
import bibliothek.gui.dock.util.laf.DefaultLookAndFeelColors;
import bibliothek.gui.dock.util.laf.LookAndFeelColors;
import bibliothek.gui.dock.util.laf.LookAndFeelColorsListener;
import bibliothek.gui.dock.util.laf.Nimbus6u10;
import bibliothek.gui.dock.util.laf.Windows;
import bibliothek.util.container.Tuple;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DockUI {
    private static DockUI ui;
    public static final String OVERFLOW_MENU_ICON = "overflow.menu";
    private List<ThemeFactory> themes = new ArrayList<ThemeFactory>();
    private List<Tuple<String, LookAndFeelColors>> lookAndFeelColors = new ArrayList<Tuple<String, LookAndFeelColors>>();
    private LookAndFeelColors lookAndFeelColor;
    private List<LookAndFeelColorsListener> colorsListeners = new ArrayList<LookAndFeelColorsListener>();
    private Boolean secureEnvironment = null;
    private LookAndFeelColorsListener colorsListener = new LookAndFeelColorsListener(){

        @Override
        public void colorChanged(String key) {
            for (LookAndFeelColorsListener listener : DockUI.this.colorsListeners.toArray(new LookAndFeelColorsListener[DockUI.this.colorsListeners.size()])) {
                listener.colorChanged(key);
            }
        }

        @Override
        public void colorsChanged() {
            for (LookAndFeelColorsListener listener : DockUI.this.colorsListeners.toArray(new LookAndFeelColorsListener[DockUI.this.colorsListeners.size()])) {
                listener.colorsChanged();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DockUI getDefaultDockUI() {
        if (ui != null) return ui;
        Class<DockUI> clazz = DockUI.class;
        synchronized (DockUI.class) {
            if (ui != null) return ui;
            ui = new DockUI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ui;
        }
    }

    protected DockUI() {
        this.registerThemes();
        this.registerColors();
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("lookAndFeel".equals(evt.getPropertyName())) {
                    DockUI.this.updateUI();
                }
            }
        });
    }

    protected void updateUI() {
        this.updateLookAndFeelColors();
    }

    private void registerThemes() {
        this.registerTheme(BasicTheme.class);
        this.registerTheme(FlatTheme.class);
        this.registerTheme(SmoothTheme.class);
        this.registerTheme(BubbleTheme.class);
        this.registerTheme(EclipseTheme.class);
        this.registerTheme(NoStackTheme.getFactory(BasicTheme.class));
        this.registerTheme(NoStackTheme.getFactory(FlatTheme.class));
        this.registerTheme(NoStackTheme.getFactory(SmoothTheme.class));
        this.registerTheme(NoStackTheme.getFactory(BubbleTheme.class));
    }

    private void registerColors() {
        int major;
        this.registerColors(".+", new DefaultLookAndFeelColors());
        String jvmVersionString = System.getProperty("java.specification.version");
        int verIndex = jvmVersionString.indexOf("1.");
        if (verIndex >= 0) {
            jvmVersionString = jvmVersionString.substring(verIndex + 2);
        }
        if ((major = Integer.parseInt(jvmVersionString)) >= 7) {
            this.registerColors("javax\\.swing\\.plaf\\.nimbus\\.NimbusLookAndFeel", new Nimbus6u10());
        } else {
            this.registerColors("com\\.sun\\.java\\.swing\\.plaf\\.nimbus\\.NimbusLookAndFeel", new Nimbus6u10());
        }
        this.registerColors("com\\.sun\\.java\\.swing\\.plaf\\.windows\\.WindowsLookAndFeel", new Windows());
    }

    public ThemeFactory getDefaultTheme() {
        return this.themes.get(0);
    }

    public ThemeFactory[] getThemes() {
        return this.themes.toArray(new ThemeFactory[this.themes.size()]);
    }

    public <T extends DockTheme> void registerTheme(Class<T> theme) {
        this.registerTheme(new ThemePropertyFactory<T>(theme));
    }

    public void registerTheme(ThemeFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Theme must not be null");
        }
        this.themes.add(factory);
    }

    public void unregisterTheme(ThemeFactory factory) {
        this.themes.remove(factory);
    }

    public void registerColors(String lookAndFeelClassNameRegex, LookAndFeelColors colors) {
        if (lookAndFeelClassNameRegex == null) {
            throw new IllegalArgumentException("lookAndFeelClassNameRegex must not be null");
        }
        if (colors == null) {
            throw new IllegalArgumentException("colors must not be null");
        }
        this.lookAndFeelColors.add(new Tuple<String, LookAndFeelColors>(lookAndFeelClassNameRegex, colors));
        this.updateLookAndFeelColors();
    }

    public void addLookAndFeelColorsListener(LookAndFeelColorsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.colorsListeners.add(listener);
    }

    public void removeLookAndFeelColorsListener(LookAndFeelColorsListener listener) {
        this.colorsListeners.remove(listener);
    }

    protected void updateLookAndFeelColors() {
        LookAndFeelColors next = this.selectBestMatchingColors();
        if (next != this.lookAndFeelColor) {
            if (this.lookAndFeelColor != null) {
                this.lookAndFeelColor.unbind();
                this.lookAndFeelColor.removeListener(this.colorsListener);
            }
            this.lookAndFeelColor = next;
            if (next != null) {
                next.bind();
                this.lookAndFeelColor.addListener(this.colorsListener);
            }
            this.colorsListener.colorsChanged();
        }
    }

    protected LookAndFeelColors selectBestMatchingColors() {
        String className = UIManager.getLookAndFeel().getClass().getName();
        for (int i = this.lookAndFeelColors.size() - 1; i >= 0; --i) {
            if (!className.matches((String)this.lookAndFeelColors.get(i).getA())) continue;
            return this.lookAndFeelColors.get(i).getB();
        }
        return null;
    }

    public LookAndFeelColors getColors() {
        return this.lookAndFeelColor;
    }

    public static Color getColor(String key) {
        return DockUI.getDefaultDockUI().getColors().getColor(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <D extends DockStation, L> void updateTheme(D station, DockFactory<D, ?, L> factory) throws IOException {
        HashMap<Integer, Dockable> children = new HashMap<Integer, Dockable>();
        HashMap<Dockable, Integer> ids = new HashMap<Dockable, Integer>();
        int n = station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable child = station.getDockable(i);
            children.put(i, child);
            ids.put(child, i);
        }
        Object layout = factory.getLayout(station, ids);
        DockController controller = station.getController();
        if (controller != null) {
            controller.getRegister().setStalled(true);
            controller.getHierarchyLock().setConcurrent(true);
        }
        try {
            for (int i = station.getDockableCount() - 1; i >= 0; --i) {
                station.drag(station.getDockable(i));
            }
            factory.setLayout(station, layout, children, null);
        }
        finally {
            if (controller != null) {
                controller.getRegister().setStalled(false);
                controller.getHierarchyLock().setConcurrent(false);
            }
        }
    }

    public static JDesktopPane getDesktopPane(Component component) {
        while (component != null) {
            if (component instanceof JDesktopPane) {
                return (JDesktopPane)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static boolean isOverlapping(Component above, Component under) {
        if (SwingUtilities.isDescendingFrom(under, above)) {
            return false;
        }
        if (SwingUtilities.isDescendingFrom(above, under)) {
            return true;
        }
        if (above == under) {
            return true;
        }
        for (Container parent = above.getParent(); parent != null; parent = parent.getParent()) {
            int zU;
            Rectangle boundsU;
            if (!SwingUtilities.isDescendingFrom(under, parent)) continue;
            Point locationA = new Point(0, 0);
            Point locationU = new Point(0, 0);
            locationA = SwingUtilities.convertPoint(above, locationA, parent);
            locationU = SwingUtilities.convertPoint(under, locationU, parent);
            Rectangle boundsA = new Rectangle(locationA, above.getSize());
            if (!boundsA.intersects(boundsU = new Rectangle(locationU, under.getSize()))) {
                return false;
            }
            Component pathA = DockUI.firstOnPath(parent, above);
            Component pathU = DockUI.firstOnPath(parent, under);
            int zA = parent.getComponentZOrder(pathA);
            return zA < (zU = parent.getComponentZOrder(pathU));
        }
        return false;
    }

    public boolean isSecureEnvironment() {
        if (this.secureEnvironment != null) {
            return this.secureEnvironment;
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            AWTEventListener listener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                }
            };
            toolkit.addAWTEventListener(listener, 131128L);
            toolkit.removeAWTEventListener(listener);
        }
        catch (SecurityException ex) {
            this.secureEnvironment = true;
            return true;
        }
        this.secureEnvironment = false;
        return false;
    }

    public void setSecureEnvironment(boolean secureEnvironment) {
        this.secureEnvironment = secureEnvironment;
    }

    private static Component firstOnPath(Container parent, Component child) {
        Component result = child;
        while (result.getParent() != parent) {
            result = result.getParent();
        }
        return result;
    }
}

