/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.util;

import java.util.Enumeration;
import java.util.Properties;
import ucar.jpeg.jj2000.j2k.util.StringFormatException;

public class ParameterList
extends Properties {
    public ParameterList() {
    }

    public ParameterList(ParameterList def) {
        super(def);
    }

    public ParameterList getDefaultParameterList() {
        return (ParameterList)this.defaults;
    }

    public void parseArgs(String[] argv) {
        int k = -1;
        do {
            if (++k < argv.length) continue;
            return;
        } while (argv[k].length() <= 0);
        char c = argv[k].charAt(0);
        if (c != '-' && c != '+') {
            throw new StringFormatException("Argument list does not start with an option: " + argv[k]);
        }
        if (argv[k].length() >= 2 && Character.isDigit(argv[k].charAt(1))) {
            throw new StringFormatException("Numeric option name: " + argv[k]);
        }
        StringBuffer pvalue = new StringBuffer();
        while (k < argv.length) {
            if (argv[k].length() <= 1) {
                throw new StringFormatException("Option \"" + argv[k] + "\" is too short.");
            }
            c = argv[k].charAt(0);
            String pname = argv[k++];
            pvalue.setLength(0);
            if (k >= argv.length) {
                pvalue.append(c == '-' ? "on" : "off");
            } else {
                char c2 = argv[k].charAt(0);
                if (c2 == '-' || c2 == '+') {
                    if (argv[k].length() <= 1) {
                        throw new StringFormatException("Option or argument \"" + argv[k] + "\" too short");
                    }
                    if (!Character.isDigit(argv[k].charAt(1))) {
                        pvalue.append(c == '-' ? "on" : "off");
                    }
                }
                if (pvalue.length() == 0) {
                    if (c == '+') {
                        throw new StringFormatException("Boolean option \"" + pname + "\" has a value");
                    }
                    pvalue.append(argv[k++]);
                    while (k < argv.length) {
                        if (argv[k].length() == 0) {
                            ++k;
                            continue;
                        }
                        c = argv[k].charAt(0);
                        if (c == '-' || c == '+') {
                            if (argv[k].length() <= 1) {
                                throw new StringFormatException("Option or argument \"" + argv[k] + "\" too short");
                            }
                            if (!Character.isDigit(argv[k].charAt(1))) break;
                        }
                        pvalue.append(' ');
                        pvalue.append(argv[k++]);
                    }
                }
            }
            if (this.get(pname.substring(1)) != null) {
                throw new StringFormatException("Option \"" + pname + "\" appears more than once");
            }
            this.put(pname.substring(1), pvalue.toString());
        }
    }

    public String getParameter(String pname) {
        String pval = (String)this.get(pname);
        if (pval == null && this.defaults != null) {
            pval = this.defaults.getProperty(pname);
        }
        return pval;
    }

    public boolean getBooleanParameter(String pname) {
        String s = this.getParameter(pname);
        if (s == null) {
            throw new IllegalArgumentException("No parameter with name " + pname);
        }
        if (s.equals("on")) {
            return true;
        }
        if (s.equals("off")) {
            return false;
        }
        throw new StringFormatException("Parameter \"" + pname + "\" is not boolean: " + s);
    }

    public int getIntParameter(String pname) {
        String s = this.getParameter(pname);
        if (s == null) {
            throw new IllegalArgumentException("No parameter with name " + pname);
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Parameter \"" + pname + "\" is not integer: " + e.getMessage());
        }
    }

    public float getFloatParameter(String pname) {
        String s = this.getParameter(pname);
        if (s == null) {
            throw new IllegalArgumentException("No parameter with name " + pname);
        }
        try {
            return new Float(s).floatValue();
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Parameter \"" + pname + "\" is not floating-point: " + e.getMessage());
        }
    }

    public void checkList(char prfx, String[] plist) {
        Enumeration<?> args = this.propertyNames();
        while (args.hasMoreElements()) {
            String val = (String)args.nextElement();
            if (val.length() <= 0 || val.charAt(0) != prfx) continue;
            boolean isvalid = false;
            if (plist != null) {
                for (int i = plist.length - 1; i >= 0; --i) {
                    if (!val.equals(plist[i])) continue;
                    isvalid = true;
                    break;
                }
            }
            if (isvalid) continue;
            throw new IllegalArgumentException("Option '" + val + "' is not a valid one.");
        }
    }

    public void checkList(char[] prfxs, String[] plist) {
        Enumeration<?> args = this.propertyNames();
        String strprfxs = new String(prfxs);
        while (args.hasMoreElements()) {
            String val = (String)args.nextElement();
            if (val.length() <= 0 || strprfxs.indexOf(val.charAt(0)) != -1) continue;
            boolean isvalid = false;
            if (plist != null) {
                for (int i = plist.length - 1; i >= 0; --i) {
                    if (!val.equals(plist[i])) continue;
                    isvalid = true;
                    break;
                }
            }
            if (isvalid) continue;
            throw new IllegalArgumentException("Option '" + val + "' is not a valid one.");
        }
    }

    public static String[] toNameArray(String[][] pinfo) {
        if (pinfo == null) {
            return null;
        }
        String[] pnames = new String[pinfo.length];
        for (int i = pinfo.length - 1; i >= 0; --i) {
            pnames[i] = pinfo[i][0];
        }
        return pnames;
    }
}

