/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockPropertyListener;
import bibliothek.gui.dock.util.PropertyKey;

public abstract class PropertyValue<A> {
    private PropertyKey<A> key;
    private DockProperties properties;
    private A value;
    private DockPropertyListener<A> listener;

    public PropertyValue(PropertyKey<A> key) {
        this(key, null);
    }

    public PropertyValue(PropertyKey<A> key, DockController controller) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        this.key = key;
        this.listener = new DockPropertyListener<A>(){

            @Override
            public void propertyChanged(DockProperties properties, PropertyKey<A> property, A oldValue, A newValue) {
                if (PropertyValue.this.value == null) {
                    PropertyValue.this.valueChanged(oldValue, newValue);
                }
            }
        };
        this.setProperties(controller);
    }

    public void setProperties(DockController controller) {
        if (controller == null) {
            this.setProperties((DockProperties)null);
        } else {
            this.setProperties(controller.getProperties());
        }
    }

    public void setProperties(DockProperties properties) {
        if (this.value != null) {
            this.properties = properties;
        } else {
            A oldValue = this.getValue();
            if (this.properties != null) {
                this.properties.removeListener(this.key, this.listener);
            }
            this.properties = properties;
            if (properties != null) {
                properties.addListener(this.key, this.listener);
            }
            A newValue = this.getValue();
            if (oldValue == null && newValue != null || oldValue != null && newValue == null || oldValue != null && !oldValue.equals(newValue)) {
                this.valueChanged(oldValue, newValue);
            }
        }
    }

    public DockProperties getProperties() {
        return this.properties;
    }

    public PropertyKey<A> getKey() {
        return this.key;
    }

    public void setKey(PropertyKey<A> key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.properties == null) {
            this.key = key;
        } else {
            A oldValue = this.getValue();
            this.properties.removeListener(this.key, this.listener);
            this.key = key;
            this.properties.addListener(this.key, this.listener);
            A newValue = this.getValue();
            if (oldValue == null && newValue != null || oldValue != null && newValue == null || oldValue != null && !oldValue.equals(newValue)) {
                this.valueChanged(oldValue, newValue);
            }
        }
    }

    public A getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.properties != null) {
            return this.properties.get(this.key);
        }
        return this.key.getDefault(null);
    }

    public A getOwnValue() {
        return this.value;
    }

    public boolean isAnyValueSet() {
        if (this.value != null) {
            return true;
        }
        return this.properties != null && this.properties.isSet(this.key);
    }

    public void setValue(A value) {
        if (this.properties != null) {
            if (this.value == null && value != null) {
                this.properties.removeListener(this.key, this.listener);
            } else if (this.value != null && value == null) {
                this.properties.addListener(this.key, this.listener);
            }
        }
        A oldValue = this.getValue();
        this.value = value;
        A newValue = this.getValue();
        if (oldValue == null && newValue != null || oldValue != null && newValue == null || oldValue != null && !oldValue.equals(newValue)) {
            this.valueChanged(oldValue, newValue);
        }
    }

    protected abstract void valueChanged(A var1, A var2);

    public String toString() {
        return this.getClass().getName() + "[" + this.key.toString() + " -> " + this.getValue() + "]";
    }
}

