/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;
import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.ResampleMethods;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index2D;
import org.meteoinfo.ndarray.Index3D;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.ProjectionUtil;

public class Reproject {
    private static final CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();

    public static PointD reprojectPoint(double x, double y, ProjectionInfo source, ProjectionInfo dest) {
        double[][] points = new double[][]{{x, y}};
        Reproject.reprojectPoints(points, source, dest, 0, points.length);
        PointD rPoint = new PointD(points[0][0], points[0][1]);
        return rPoint;
    }

    public static PointD reprojectPoint(PointD point, ProjectionInfo source, ProjectionInfo dest) {
        return Reproject.reprojectPoint(point.X, point.Y, source, dest);
    }

    public static void reprojectPoints(double[][] points, ProjectionInfo source, ProjectionInfo dest) {
        Reproject.reprojectPoints(points, source, dest, 0, points.length);
    }

    public static void reprojectPoints(double[][] points, ProjectionInfo source, ProjectionInfo dest, int startIndex, int numPoints) {
        int i;
        CoordinateTransform trans = ctFactory.createTransform(source.getCoordinateReferenceSystem(), dest.getCoordinateReferenceSystem());
        if (source.getProjectionName() == ProjectionNames.LongLat) {
            for (i = startIndex; i < startIndex + numPoints && i < points.length; ++i) {
                if (points[i][0] > 180.0) {
                    double[] dArray = points[i];
                    dArray[0] = dArray[0] - 360.0;
                    continue;
                }
                if (!(points[i][0] < -180.0)) continue;
                double[] dArray = points[i];
                dArray[0] = dArray[0] + 360.0;
            }
        }
        for (i = startIndex; i < startIndex + numPoints && i < points.length; ++i) {
            if (Double.isNaN(points[i][0]) || Double.isNaN(points[i][1])) {
                points[i][0] = Double.NaN;
                points[i][1] = Double.NaN;
                continue;
            }
            ProjCoordinate p1 = new ProjCoordinate(points[i][0], points[i][1]);
            ProjCoordinate p2 = new ProjCoordinate();
            try {
                trans.transform(p1, p2);
                points[i][0] = p2.x;
                points[i][1] = p2.y;
                continue;
            }
            catch (ProjectionException e) {
                points[i][0] = Double.NaN;
                points[i][1] = Double.NaN;
            }
        }
    }

    public static Object[] reproject(Array data, List<Number> xx, List<Number> yy, CoordinateReferenceSystem fromProj, CoordinateReferenceSystem toProj, ResampleMethods method) throws InvalidRangeException {
        return Reproject.reproject(data, xx, yy, ProjectionInfo.factory(fromProj), ProjectionInfo.factory(toProj), method);
    }

    public static Object[] reproject(Array data, List<Number> xx, List<Number> yy, ProjectionInfo fromProj, ProjectionInfo toProj, ResampleMethods method) throws InvalidRangeException {
        int i;
        int xnum = xx.size();
        int ynum = yy.size();
        Extent aExtent = ProjectionUtil.getProjectionExtent(fromProj, toProj, xx, yy);
        double xDelt = (aExtent.maxX - aExtent.minX) / (double)(xnum - 1);
        double yDelt = (aExtent.maxY - aExtent.minY) / (double)(ynum - 1);
        Array rx = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{xnum});
        Array ry = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ynum});
        for (i = 0; i < xnum; ++i) {
            rx.setDouble(i, aExtent.minX + (double)i * xDelt);
        }
        for (i = 0; i < ynum; ++i) {
            ry.setDouble(i, aExtent.minY + (double)i * yDelt);
        }
        Array[] rr = ArrayUtil.meshgrid((Array)rx, (Array)ry);
        Array r = Reproject.reproject(data, xx, yy, rr[0], rr[1], fromProj, toProj, method);
        return new Object[]{r, rx, ry};
    }

    public static Object[] reproject(Array data, Array xx, Array yy, ProjectionInfo fromProj, ProjectionInfo toProj) throws InvalidRangeException {
        return Reproject.reproject(data, xx, yy, fromProj, toProj, ResampleMethods.NearestNeighbor);
    }

    public static Object[] reproject(Array data, Array xx, Array yy, ProjectionInfo fromProj, ProjectionInfo toProj, ResampleMethods method) throws InvalidRangeException {
        int i;
        xx = xx.copyIfView();
        yy = yy.copyIfView();
        int xnum = (int)xx.getSize();
        int ynum = (int)yy.getSize();
        Extent aExtent = ProjectionUtil.getProjectionExtent(fromProj, toProj, xx, yy);
        double xDelt = (aExtent.maxX - aExtent.minX) / (double)(xnum - 1);
        double yDelt = (aExtent.maxY - aExtent.minY) / (double)(ynum - 1);
        Array rx = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{xnum});
        Array ry = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ynum});
        for (i = 0; i < xnum; ++i) {
            rx.setDouble(i, aExtent.minX + (double)i * xDelt);
        }
        for (i = 0; i < ynum; ++i) {
            ry.setDouble(i, aExtent.minY + (double)i * yDelt);
        }
        Array[] rr = ArrayUtil.meshgrid((Array)rx, (Array)ry);
        Array r = Reproject.reproject(data, xx, yy, rr[0], rr[1], fromProj, toProj, method);
        return new Object[]{r, rx, ry};
    }

    public static Object[] reproject(Array data, List<Number> xx, List<Number> yy, ProjectionInfo fromProj, ProjectionInfo toProj) throws InvalidRangeException {
        return Reproject.reproject(data, xx, yy, fromProj, toProj, ResampleMethods.NearestNeighbor);
    }

    public static Array reproject(Array data, List<Number> x, List<Number> y, Array rx, Array ry, ProjectionInfo fromProj, ProjectionInfo toProj, double fill_value, ResampleMethods resampleMethod) throws InvalidRangeException {
        int[] shape;
        int n = (int)rx.getSize();
        int[] dshape = data.getShape();
        if (rx.getRank() == 1) {
            shape = new int[]{rx.getShape()[0]};
        } else {
            shape = new int[data.getRank()];
            for (int i = 0; i < shape.length; ++i) {
                shape[i] = i == shape.length - 2 ? rx.getShape()[0] : (i == shape.length - 1 ? rx.getShape()[1] : data.getShape()[i]);
            }
        }
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        double[][] points = new double[n][];
        for (int i = 0; i < n; ++i) {
            points[i] = new double[]{rx.getDouble(i), ry.getDouble(i)};
        }
        if (!fromProj.equals(toProj)) {
            Reproject.reprojectPoints(points, toProj, fromProj, 0, points.length);
        }
        if (resampleMethod == ResampleMethods.Bilinear) {
            if (shape.length <= 2) {
                for (int i = 0; i < n; ++i) {
                    double xx = points[i][0];
                    double yy = points[i][1];
                    if (Double.isNaN(xx) || Double.isNaN(yy)) {
                        r.setObject(i, (Object)Double.NaN);
                        continue;
                    }
                    r.setObject(i, (Object)ArrayUtil.toStation((Array)data, x, y, (double)xx, (double)yy, (double)fill_value));
                }
            } else {
                Index indexr = r.getIndex();
                int[] cc = null;
                Array ndata = null;
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = indexr.getCurrentCounter();
                    boolean isNew = true;
                    if (i > 0) {
                        for (int j = 0; j < shape.length - 2; ++j) {
                            if (cc[j] == current[j]) continue;
                            isNew = false;
                            break;
                        }
                    }
                    cc = Arrays.copyOf(current, current.length);
                    if (isNew) {
                        ArrayList<Range> ranges = new ArrayList<Range>();
                        for (int j = 0; j < shape.length - 2; ++j) {
                            ranges.add(new Range(current[j], current[j], 1));
                        }
                        ranges.add(new Range(0, dshape[dshape.length - 2] - 1, 1));
                        ranges.add(new Range(0, dshape[dshape.length - 1] - 1, 1));
                        ndata = data.section(ranges).reduce();
                    }
                    int k = current[shape.length - 2] * shape[shape.length - 1] + current[shape.length - 1];
                    double xx = points[k][0];
                    double yy = points[k][1];
                    if (Double.isNaN(xx) || Double.isNaN(yy)) {
                        r.setObject(i, (Object)Double.NaN);
                    } else {
                        r.setObject(i, (Object)ArrayUtil.toStation(ndata, x, y, (double)xx, (double)yy, (double)fill_value));
                    }
                    indexr.incr();
                    ++i;
                }
            }
        } else if (shape.length <= 2) {
            for (int i = 0; i < n; ++i) {
                double xx = points[i][0];
                double yy = points[i][1];
                if (Double.isNaN(xx) || Double.isNaN(yy)) {
                    r.setObject(i, (Object)Double.NaN);
                    continue;
                }
                r.setObject(i, (Object)ArrayUtil.toStation_Neighbor((Array)data, x, y, (double)xx, (double)yy, (double)fill_value));
            }
        } else {
            Index indexr = r.getIndex();
            int[] cc = null;
            Array ndata = null;
            int i = 0;
            while ((long)i < r.getSize()) {
                int[] current = indexr.getCurrentCounter();
                boolean isNew = true;
                if (i > 0) {
                    for (int j = 0; j < shape.length - 2; ++j) {
                        if (cc[j] == current[j]) continue;
                        isNew = false;
                        break;
                    }
                }
                cc = Arrays.copyOf(current, current.length);
                if (isNew) {
                    ArrayList<Range> ranges = new ArrayList<Range>();
                    for (int j = 0; j < shape.length - 2; ++j) {
                        ranges.add(new Range(current[j], current[j], 1));
                    }
                    ranges.add(new Range(0, dshape[dshape.length - 2] - 1, 1));
                    ranges.add(new Range(0, dshape[dshape.length - 1] - 1, 1));
                    ndata = data.section(ranges).reduce();
                }
                int k = current[shape.length - 2] * shape[shape.length - 1] + current[shape.length - 1];
                double xx = points[k][0];
                double yy = points[k][1];
                if (Double.isNaN(xx) || Double.isNaN(yy)) {
                    r.setObject(i, (Object)Double.NaN);
                } else {
                    r.setObject(i, (Object)ArrayUtil.toStation_Neighbor(ndata, x, y, (double)xx, (double)yy, (double)fill_value));
                }
                indexr.incr();
                ++i;
            }
        }
        return r;
    }

    public static Array reproject(Array data, List<Number> x, List<Number> y, Array rx, Array ry, ProjectionInfo fromProj, ProjectionInfo toProj, ResampleMethods resampleMethod) throws InvalidRangeException {
        int[] shape;
        int n = (int)rx.getSize();
        int[] dshape = data.getShape();
        if (rx.getRank() == 1) {
            shape = new int[]{rx.getShape()[0]};
        } else {
            shape = new int[data.getRank()];
            for (int i = 0; i < shape.length; ++i) {
                shape[i] = i == shape.length - 2 ? rx.getShape()[0] : (i == shape.length - 1 ? rx.getShape()[1] : data.getShape()[i]);
            }
        }
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        double[][] points = new double[n][];
        for (int i = 0; i < n; ++i) {
            points[i] = new double[]{rx.getDouble(i), ry.getDouble(i)};
        }
        if (!fromProj.equals(toProj)) {
            Reproject.reprojectPoints(points, toProj, fromProj, 0, points.length);
        }
        if (resampleMethod == ResampleMethods.Bilinear) {
            if (shape.length <= 2) {
                for (int i = 0; i < n; ++i) {
                    double xx = points[i][0];
                    double yy = points[i][1];
                    r.setObject(i, (Object)ArrayUtil.toStation((Array)data, x, y, (double)xx, (double)yy));
                }
            } else {
                Index indexr = r.getIndex();
                int[] cc = null;
                Array ndata = null;
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = indexr.getCurrentCounter();
                    boolean isNew = true;
                    if (i > 0) {
                        for (int j = 0; j < shape.length - 2; ++j) {
                            if (cc[j] == current[j]) continue;
                            isNew = false;
                            break;
                        }
                    }
                    cc = Arrays.copyOf(current, current.length);
                    if (isNew) {
                        ArrayList<Range> ranges = new ArrayList<Range>();
                        for (int j = 0; j < shape.length - 2; ++j) {
                            ranges.add(new Range(current[j], current[j], 1));
                        }
                        ranges.add(new Range(0, dshape[dshape.length - 2] - 1, 1));
                        ranges.add(new Range(0, dshape[dshape.length - 1] - 1, 1));
                        ndata = data.section(ranges).reduce();
                    }
                    int k = current[shape.length - 2] * shape[shape.length - 1] + current[shape.length - 1];
                    double xx = points[k][0];
                    double yy = points[k][1];
                    r.setObject(i, (Object)ArrayUtil.toStation(ndata, x, y, (double)xx, (double)yy));
                    indexr.incr();
                    ++i;
                }
            }
        } else if (shape.length == 2) {
            for (int i = 0; i < n; ++i) {
                double xx = points[i][0];
                double yy = points[i][1];
                r.setObject(i, (Object)ArrayUtil.toStation_Neighbor((Array)data, x, y, (double)xx, (double)yy));
            }
        } else {
            Index indexr = r.getIndex();
            int[] cc = null;
            Array ndata = null;
            int i = 0;
            while ((long)i < r.getSize()) {
                int[] current = indexr.getCurrentCounter();
                boolean isNew = true;
                if (i > 0) {
                    for (int j = 0; j < shape.length - 2; ++j) {
                        if (cc[j] == current[j]) continue;
                        isNew = false;
                        break;
                    }
                }
                cc = Arrays.copyOf(current, current.length);
                if (isNew) {
                    ArrayList<Range> ranges = new ArrayList<Range>();
                    for (int j = 0; j < shape.length - 2; ++j) {
                        ranges.add(new Range(current[j], current[j], 1));
                    }
                    ranges.add(new Range(0, dshape[dshape.length - 2] - 1, 1));
                    ranges.add(new Range(0, dshape[dshape.length - 1] - 1, 1));
                    ndata = data.section(ranges).reduce();
                }
                int k = current[shape.length - 2] * shape[shape.length - 1] + current[shape.length - 1];
                double xx = points[k][0];
                double yy = points[k][1];
                r.setObject(i, (Object)ArrayUtil.toStation_Neighbor(ndata, x, y, (double)xx, (double)yy));
                indexr.incr();
                ++i;
            }
        }
        return r;
    }

    public static Array reproject(Array data, Array x, Array y, Array rx, Array ry, ProjectionInfo fromProj, ProjectionInfo toProj, ResampleMethods resampleMethod) throws InvalidRangeException {
        int[] shape;
        int n = (int)rx.getSize();
        int[] dshape = data.getShape();
        if (rx.getRank() == 1) {
            shape = new int[]{rx.getShape()[0]};
        } else {
            shape = new int[data.getRank()];
            for (int i = 0; i < shape.length; ++i) {
                shape[i] = i == shape.length - 2 ? rx.getShape()[0] : (i == shape.length - 1 ? rx.getShape()[1] : data.getShape()[i]);
            }
        }
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        double[][] points = new double[n][];
        for (int i = 0; i < n; ++i) {
            points[i] = new double[]{rx.getDouble(i), ry.getDouble(i)};
        }
        if (!fromProj.equals(toProj)) {
            Reproject.reprojectPoints(points, toProj, fromProj, 0, points.length);
        }
        if (resampleMethod == ResampleMethods.Bilinear) {
            if (shape.length <= 2) {
                for (int i = 0; i < n; ++i) {
                    double xx = points[i][0];
                    double yy = points[i][1];
                    r.setDouble(i, ArrayUtil.toStation((Array)data, (Array)x, (Array)y, (double)xx, (double)yy));
                }
            } else {
                Index indexr = r.getIndex();
                int[] cc = null;
                Array ndata = null;
                int i = 0;
                while ((long)i < r.getSize()) {
                    int[] current = indexr.getCurrentCounter();
                    boolean isNew = true;
                    if (i > 0) {
                        for (int j = 0; j < shape.length - 2; ++j) {
                            if (cc[j] == current[j]) continue;
                            isNew = false;
                            break;
                        }
                    }
                    cc = Arrays.copyOf(current, current.length);
                    if (isNew) {
                        ArrayList<Range> ranges = new ArrayList<Range>();
                        for (int j = 0; j < shape.length - 2; ++j) {
                            ranges.add(new Range(current[j], current[j], 1));
                        }
                        ranges.add(new Range(0, dshape[dshape.length - 2] - 1, 1));
                        ranges.add(new Range(0, dshape[dshape.length - 1] - 1, 1));
                        ndata = data.section(ranges).reduce();
                    }
                    int k = current[shape.length - 2] * shape[shape.length - 1] + current[shape.length - 1];
                    double xx = points[k][0];
                    double yy = points[k][1];
                    r.setObject(i, (Object)ArrayUtil.toStation(ndata, (Array)x, (Array)y, (double)xx, (double)yy));
                    indexr.incr();
                    ++i;
                }
            }
        } else if (shape.length == 2) {
            for (int i = 0; i < n; ++i) {
                double xx = points[i][0];
                double yy = points[i][1];
                r.setObject(i, (Object)ArrayUtil.toStation_Neighbor((Array)data, (Array)x, (Array)y, (double)xx, (double)yy));
            }
        } else {
            Index indexr = r.getIndex();
            int[] cc = null;
            Array ndata = null;
            int i = 0;
            while ((long)i < r.getSize()) {
                int[] current = indexr.getCurrentCounter();
                boolean isNew = true;
                if (i > 0) {
                    for (int j = 0; j < shape.length - 2; ++j) {
                        if (cc[j] == current[j]) continue;
                        isNew = false;
                        break;
                    }
                }
                cc = Arrays.copyOf(current, current.length);
                if (isNew) {
                    ArrayList<Range> ranges = new ArrayList<Range>();
                    for (int j = 0; j < shape.length - 2; ++j) {
                        ranges.add(new Range(current[j], current[j], 1));
                    }
                    ranges.add(new Range(0, dshape[dshape.length - 2] - 1, 1));
                    ranges.add(new Range(0, dshape[dshape.length - 1] - 1, 1));
                    ndata = data.section(ranges).reduce();
                }
                int k = current[shape.length - 2] * shape[shape.length - 1] + current[shape.length - 1];
                double xx = points[k][0];
                double yy = points[k][1];
                r.setObject(i, (Object)ArrayUtil.toStation_Neighbor(ndata, (Array)x, (Array)y, (double)xx, (double)yy));
                indexr.incr();
                ++i;
            }
        }
        return r;
    }

    public static Array reproject(Array data, List<Number> x, List<Number> y, List<Number> rx, List<Number> ry, ProjectionInfo fromProj, ProjectionInfo toProj, double fill_value, ResampleMethods resampleMethod) {
        int n = rx.size() * ry.size();
        int[] shape = new int[]{ry.size(), rx.size()};
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        double[][] points = new double[n][];
        for (int i = 0; i < ry.size(); ++i) {
            for (int j = 0; j < rx.size(); ++j) {
                points[i * rx.size() + j] = new double[]{rx.get(j).doubleValue(), ry.get(i).doubleValue()};
            }
        }
        if (!fromProj.equals(toProj)) {
            Reproject.reprojectPoints(points, toProj, fromProj, 0, points.length);
        }
        if (resampleMethod == ResampleMethods.Bilinear) {
            for (int i = 0; i < n; ++i) {
                double xx = points[i][0];
                double yy = points[i][1];
                r.setObject(i, (Object)ArrayUtil.toStation((Array)data, x, y, (double)xx, (double)yy, (double)fill_value));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                double xx = points[i][0];
                double yy = points[i][1];
                r.setObject(i, (Object)ArrayUtil.toStation_Neighbor((Array)data, x, y, (double)xx, (double)yy, (double)fill_value));
            }
        }
        return r;
    }

    public static Array[] reproject(Array x, Array y, ProjectionInfo fromProj, ProjectionInfo toProj) {
        int i;
        Array rx = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        Array ry = Array.factory((DataType)DataType.DOUBLE, (int[])x.getShape());
        int n = (int)x.getSize();
        double[][] points = new double[n][];
        IndexIterator iterX = x.getIndexIterator();
        IndexIterator iterY = y.getIndexIterator();
        for (i = 0; i < n; ++i) {
            points[i] = new double[]{iterX.getDoubleNext(), iterY.getDoubleNext()};
        }
        Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
        for (i = 0; i < n; ++i) {
            rx.setDouble(i, points[i][0]);
            ry.setDouble(i, points[i][1]);
        }
        return new Array[]{rx, ry};
    }

    public static Array reprojectImage(Array data, Array x, Array y, Array rx, Array ry, ProjectionInfo fromProj, ProjectionInfo toProj) throws InvalidRangeException {
        data = data.copyIfView();
        x = x.copyIfView();
        y = y.copyIfView();
        rx = rx.copyIfView();
        ry = ry.copyIfView();
        int[] shape = rx.getShape();
        int ny = shape[0];
        int nx = shape[1];
        int[] newShape = data.getRank() == 2 ? new int[]{ny, nx} : new int[]{ny, nx, data.getShape()[2]};
        Array r = Array.factory((DataType)data.getDataType(), (int[])newShape);
        int n = ny * nx;
        double[][] points = new double[n][];
        for (int i = 0; i < n; ++i) {
            points[i] = new double[]{rx.getDouble(i), ry.getDouble(i)};
        }
        if (!fromProj.equals(toProj)) {
            Reproject.reprojectPoints(points, toProj, fromProj, 0, points.length);
        }
        double minX = x.getDouble(0);
        double maxX = x.getDouble((int)x.getSize() - 1);
        double minY = y.getDouble(0);
        double maxY = y.getDouble((int)y.getSize() - 1);
        double dx = (maxX - minX) / (double)((int)x.getSize() - 1);
        double dy = (maxY - minY) / (double)((int)y.getSize() - 1);
        int idx = 0;
        if (data.getRank() == 2) {
            Index2D index = (Index2D)data.getIndex();
            for (int i = 0; i < ny; ++i) {
                for (int j = 0; j < nx; ++j) {
                    int ii = i * nx + j;
                    double xx = points[ii][0];
                    double yy = points[ii][1];
                    int xi = xx < minX || xx > maxX ? -1 : (int)((xx - minX) / dx);
                    int yi = yy < minY || yy > maxY ? -1 : (int)((yy - minY) / dy);
                    if (xi >= 0 && yi >= 0) {
                        index.set(yi, xi);
                        r.setObject(ii, data.getObject((Index)index));
                        continue;
                    }
                    r.setObject(ii, (Object)Double.NaN);
                }
            }
        } else {
            Index3D index = (Index3D)data.getIndex();
            for (int i = 0; i < ny; ++i) {
                for (int j = 0; j < nx; ++j) {
                    int ii = i * nx + j;
                    double xx = points[ii][0];
                    double yy = points[ii][1];
                    int xi = xx < minX || xx > maxX ? -1 : (int)((xx - minX) / dx);
                    int yi = yy < minY || yy > maxY ? -1 : (int)((yy - minY) / dy);
                    if (xi >= 0 && yi >= 0) {
                        index.set(yi, xi, 0);
                        r.setObject(idx, data.getObject((Index)index));
                        index.set2(1);
                        r.setObject(++idx, data.getObject((Index)index));
                        index.set2(2);
                        r.setObject(++idx, data.getObject((Index)index));
                        ++idx;
                        continue;
                    }
                    r.setObject(idx, (Object)255);
                    r.setObject(++idx, (Object)255);
                    r.setObject(++idx, (Object)255);
                    ++idx;
                }
            }
        }
        return r;
    }

    public static Object[] reprojectImage(Array data, Array x, Array y, ProjectionInfo fromProj, ProjectionInfo toProj) throws InvalidRangeException {
        int i;
        Extent extent = ProjectionUtil.getProjectionExtent(fromProj, toProj, x, y);
        int nx = (int)x.getSize();
        int ny = (int)y.getSize();
        double dx = (extent.maxX - extent.minX) / (double)(nx - 1);
        double dy = (extent.maxY - extent.minY) / (double)(ny - 1);
        Array rx = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{nx});
        Array ry = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ny});
        for (i = 0; i < nx; ++i) {
            rx.setDouble(i, extent.minX + (double)i * dx);
        }
        for (i = 0; i < ny; ++i) {
            ry.setDouble(i, extent.minY + (double)i * dy);
        }
        Array[] rr = ArrayUtil.meshgrid((Array)rx, (Array)ry);
        Array r = Reproject.reprojectImage(data, x, y, rr[0], rr[1], fromProj, toProj);
        return new Object[]{r, rx, ry};
    }
}

