/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.trajstat.forms;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import org.meteoinfo.common.GenericFileFilter;
import org.meteoinfo.common.PointD;
import org.meteoinfo.data.GridData;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.GroupNode;
import org.meteoinfo.geo.legend.LayerNode;
import org.meteoinfo.geo.plugin.IApplication;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.table.Field;

public class FrmToGrid
extends JDialog {
    private final IApplication app;
    private JButton jButton_Save;
    private JComboBox jComboBox_Field;
    private JComboBox jComboBox_Layer;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public FrmToGrid(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.app = (IApplication)parent;
        GroupNode pNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("PSCF");
        this.jComboBox_Layer.removeAllItems();
        if (pNode != null) {
            for (LayerNode lNode : pNode.getLayers()) {
                this.jComboBox_Layer.addItem(lNode.getMapLayer());
            }
        }
        if ((pNode = this.app.getMapDocument().getActiveMapFrame().getGroupByName("CWT")) != null) {
            for (LayerNode lNode : pNode.getLayers()) {
                this.jComboBox_Layer.addItem(lNode.getMapLayer());
            }
        }
        if (this.jComboBox_Layer.getItemCount() > 0) {
            this.jComboBox_Layer.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox_Layer = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox_Field = new JComboBox();
        this.jButton_Save = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("PSCF/CWT Layer:");
        this.jComboBox_Layer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Layer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmToGrid.this.jComboBox_LayerActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Field:");
        this.jComboBox_Field.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButton_Save.setText("Save");
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmToGrid.this.jButton_SaveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_Save).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBox_Layer, 0, 164, Short.MAX_VALUE).addComponent(this.jComboBox_Field, 0, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_Layer, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBox_Field, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jButton_Save).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        Object obj = this.jComboBox_Layer.getSelectedItem();
        if (obj != null) {
            VectorLayer layer = (VectorLayer)obj;
            int sn = layer.getShapeNum();
            int xn = 0;
            double oldx = Double.NEGATIVE_INFINITY;
            for (Shape shape : layer.getShapes()) {
                double x = ((PointD)shape.getPoints().get((int)0)).X;
                if (x < oldx) break;
                oldx = x;
                ++xn;
            }
            int yn = sn / xn;
            int idx = sn - xn;
            Shape shp = (Shape)layer.getShapes().get(idx);
            PointD point = shp.getExtent().getCenterPoint();
            double minx = point.X;
            double miny = point.Y;
            PointD rpoint = ((Shape)layer.getShapes().get(idx + 1)).getExtent().getCenterPoint();
            double xdelta = rpoint.X - minx;
            PointD tpoint = ((Shape)layer.getShapes().get(idx - xn)).getExtent().getCenterPoint();
            double ydelta = tpoint.Y - miny;
            GridData gData = new GridData(minx, xdelta, xn, miny, ydelta, yn);
            String fieldName = this.jComboBox_Field.getSelectedItem().toString();
            for (int i = 0; i < yn; ++i) {
                for (int j = 0; j < xn; ++j) {
                    idx = (yn - i - 1) * xn + j;
                    double v = ((Number)layer.getCellValue(fieldName, idx)).doubleValue();
                    gData.setValue(i, j, v);
                }
            }
            String userPath = System.getProperty("user.dir");
            File pathDir = new File(userPath);
            JFileChooser aDlg = new JFileChooser();
            String[] fileExts = new String[]{"dat"};
            GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "Surfer ASCII file (*.dat)");
            aDlg.setFileFilter((FileFilter)pFileFilter);
            aDlg.setAcceptAllFileFilterUsed(false);
            aDlg.setCurrentDirectory(pathDir);
            if (0 == aDlg.showSaveDialog((JFrame)this.app)) {
                String fileName = aDlg.getSelectedFile().getAbsolutePath();
                String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
                if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                    fileName = fileName + "." + extent;
                }
                gData.saveAsSurferASCIIFile(fileName);
            }
        }
    }

    private void jComboBox_LayerActionPerformed(ActionEvent evt) {
        Object obj = this.jComboBox_Layer.getSelectedItem();
        if (obj != null) {
            VectorLayer layer = (VectorLayer)obj;
            this.jComboBox_Field.removeAllItems();
            for (Field field : layer.getFields()) {
                if (!field.isNumeric()) continue;
                this.jComboBox_Field.addItem(field.getColumnName());
            }
            if (this.jComboBox_Field.getItemCount() > 0) {
                this.jComboBox_Field.setSelectedIndex(this.jComboBox_Field.getItemCount() - 1);
            }
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmToGrid.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmToGrid.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmToGrid.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmToGrid.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmToGrid dialog = new FrmToGrid((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

