/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.stats;

import java.util.ArrayList;
import org.apache.commons.math4.legacy.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.legacy.linear.RealMatrix;
import org.apache.commons.math4.legacy.stat.StatUtils;
import org.apache.commons.math4.legacy.stat.correlation.Covariance;
import org.apache.commons.math4.legacy.stat.correlation.KendallsCorrelation;
import org.apache.commons.math4.legacy.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math4.legacy.stat.correlation.SpearmansCorrelation;
import org.apache.commons.math4.legacy.stat.inference.InferenceTestUtils;
import org.meteoinfo.math.special.Erf;
import org.meteoinfo.math.stats.Jenks;
import org.meteoinfo.math.stats.MIOLSMultipleLinearRegression;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.MAMath;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class StatsUtil {
    public static double covariance(Array x, Array y, boolean bias) {
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)y);
        double r = new Covariance().covariance(xd, yd, bias);
        return r;
    }

    public static Array cov(Array x, Array y, boolean bias) {
        x = x.copyIfView();
        y = y.copyIfView();
        int m = x.getShape()[0];
        int n = 1;
        if (x.getRank() == 2) {
            n = x.getShape()[1];
        }
        double[][] aa = new double[m][n * 2];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n * 2; ++j) {
                aa[i][j] = j < n ? x.getDouble(i * n + j) : y.getDouble(i * n + j - n);
            }
        }
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        Covariance cov = new Covariance((RealMatrix)matrix, bias);
        RealMatrix mcov = cov.getCovarianceMatrix();
        m = mcov.getColumnDimension();
        n = mcov.getRowDimension();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m, n});
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                r.setDouble(i * n + j, mcov.getEntry(i, j));
            }
        }
        return r;
    }

    public static Object cov(Array a, boolean bias) {
        if (a.getRank() == 1) {
            double[] ad = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)a);
            Covariance cov = new Covariance();
            return cov.covariance(ad, ad);
        }
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        Covariance cov = new Covariance((RealMatrix)matrix, bias);
        RealMatrix mcov = cov.getCovarianceMatrix();
        int m = mcov.getColumnDimension();
        int n = mcov.getRowDimension();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m, n});
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                r.setDouble(i * n + j, mcov.getEntry(i, j));
            }
        }
        return r;
    }

    public static double[] kendalltau(Array x, Array y) {
        x = x.copyIfView();
        y = y.copyIfView();
        int is = 0;
        int n2 = 0;
        int n1 = 0;
        int n = (int)x.getSize();
        for (int j = 0; j < n - 1; ++j) {
            for (int k = j + 1; k < n; ++k) {
                double a2;
                double a1 = x.getDouble(j) - x.getDouble(k);
                double aa = a1 * (a2 = y.getDouble(j) - y.getDouble(k));
                if (aa != 0.0) {
                    ++n1;
                    ++n2;
                    if (aa > 0.0) {
                        ++is;
                        continue;
                    }
                    --is;
                    continue;
                }
                if (a1 != 0.0) {
                    ++n1;
                }
                if (a2 == 0.0) continue;
                ++n2;
            }
        }
        double tau = (double)is / (Math.sqrt(n1) * Math.sqrt(n2));
        double var = (4.0 * (double)n + 10.0) / (9.0 * (double)n * ((double)n - 1.0));
        double z = tau / Math.sqrt(var);
        double pvalue = Erf.erfcc(Math.abs(z) / 1.4142136);
        return new double[]{tau, pvalue};
    }

    public static double kendalltau_bak(Array x, Array y) {
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)y);
        KendallsCorrelation kc = new KendallsCorrelation();
        double r = kc.correlation(xd, yd);
        return r;
    }

    public static double[] pearsonr(Array x, Array y) {
        x = x.copyIfView();
        y = y.copyIfView();
        if (ArrayMath.containsNaN((Array)x) || ArrayMath.containsNaN((Array)y)) {
            Array[] xy = ArrayMath.removeNaN((Array[])new Array[]{x, y});
            if (xy == null) {
                return new double[]{Double.NaN, Double.NaN};
            }
            x = xy[0];
            y = xy[1];
        }
        if (MAMath.isEqual((Array)x, (Array)y)) {
            return new double[]{1.0, 0.0};
        }
        int m = (int)x.getSize();
        int n = 1;
        double[][] aa = new double[m][n * 2];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n * 2; ++j) {
                aa[i][j] = j < n ? x.getDouble(i * n + j) : y.getDouble(i * n + j - n);
            }
        }
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        PearsonsCorrelation pc = new PearsonsCorrelation((RealMatrix)matrix);
        double r = pc.getCorrelationMatrix().getEntry(0, 1);
        double pvalue = pc.getCorrelationPValues().getEntry(0, 1);
        return new double[]{r, pvalue};
    }

    public static Array[] pearsonr(Array x, Array y, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = x.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        Array pv = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            Array xx = ArrayMath.section((Array)x, ranges);
            Array yy = ArrayMath.section((Array)y, ranges);
            double[] rp = StatsUtil.pearsonr(xx, yy);
            r.setDouble(i, rp[0]);
            pv.setDouble(i, rp[1]);
            indexr.incr();
            ++i;
        }
        return new Array[]{r, pv};
    }

    public static double[] spearmanr(Array x, Array y) {
        x = x.copyIfView();
        y = y.copyIfView();
        int m = x.getShape()[0];
        int n = 1;
        if (x.getRank() == 2) {
            n = x.getShape()[1];
        }
        double[][] aa = new double[m][n * 2];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n * 2; ++j) {
                aa[i][j] = j < n ? x.getDouble(i * n + j) : y.getDouble(i * n + j - n);
            }
        }
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        SpearmansCorrelation cov = new SpearmansCorrelation((RealMatrix)matrix);
        double r = cov.getCorrelationMatrix().getEntry(0, 1);
        double pValue = cov.getRankCorrelation().getCorrelationPValues().getEntry(0, 1);
        return new double[]{r, pValue};
    }

    public static Object spearmanr(Array a) {
        if (a.getRank() == 1) {
            double[] ad = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)a);
            Covariance cov = new Covariance();
            return cov.covariance(ad, ad);
        }
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        SpearmansCorrelation cov = new SpearmansCorrelation((RealMatrix)matrix);
        RealMatrix mcov = cov.getCorrelationMatrix();
        int m = mcov.getColumnDimension();
        int n = mcov.getRowDimension();
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{m, n});
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                r.setDouble(i * n + j, mcov.getEntry(i, j));
            }
        }
        return r;
    }

    public static Object[] multipleLineRegress_OLS(Array y, Array x) {
        return StatsUtil.multipleLineRegress_OLS(y, x, false);
    }

    public static Object[] multipleLineRegress_OLS(Array y, Array x, boolean noIntercept) {
        int i;
        MIOLSMultipleLinearRegression regression = new MIOLSMultipleLinearRegression();
        regression.setNoIntercept(noIntercept);
        y = y.reduce();
        double[] yy = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)y);
        double[][] xx = (double[][])ArrayUtil.copyToNDJavaArray_Double((Array)x);
        regression.newSampleData(yy, xx);
        double[] para = regression.estimateRegressionParameters();
        double[] residuals = regression.estimateResiduals();
        int k = para.length;
        int n = residuals.length;
        Array aPara = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{k});
        Array aResiduals = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
        for (i = 0; i < k; ++i) {
            aPara.setDouble(i, para[i]);
        }
        for (i = 0; i < k; ++i) {
            aResiduals.setDouble(i, residuals[i]);
        }
        double r2 = regression.calculateRSquared();
        return new Object[]{aPara, aResiduals, r2};
    }

    public static double percentile(Array a, double p) {
        double[] v = (double[])a.get1DJavaArray(Double.class);
        double r = StatUtils.percentile((double[])v, (double)p);
        return r;
    }

    public static Array percentile(Array a, double p, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            Array aa = ArrayMath.section((Array)a, ranges);
            double[] v = (double[])aa.get1DJavaArray(Double.class);
            double q = StatUtils.percentile((double[])v, (double)p);
            r.setDouble(i, q);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static double[] tTest(Array a, double mu) {
        double[] ad = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)a);
        double s = InferenceTestUtils.t((double)mu, (double[])ad);
        double p = InferenceTestUtils.tTest((double)mu, (double[])ad);
        return new double[]{s, p};
    }

    public static double[] tTest(Array a, Array b) {
        double[] ad = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)a);
        double[] bd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)b);
        double s = InferenceTestUtils.t((double[])ad, (double[])bd);
        double p = InferenceTestUtils.tTest((double[])ad, (double[])bd);
        return new double[]{s, p};
    }

    public static double[] pairedTTest(Array a, Array b) {
        double[] ad = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)a);
        double[] bd = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)b);
        double s = InferenceTestUtils.pairedT((double[])ad, (double[])bd);
        double p = InferenceTestUtils.pairedTTest((double[])ad, (double[])bd);
        return new double[]{s, p};
    }

    public static double[] chiSquareTest(Array e, Array o) {
        double[] ed = (double[])ArrayUtil.copyToNDJavaArray_Double((Array)e);
        long[] od = (long[])ArrayUtil.copyToNDJavaArray_Long((Array)o);
        double s = InferenceTestUtils.chiSquare((double[])ed, (long[])od);
        double p = InferenceTestUtils.chiSquareTest((double[])ed, (long[])od);
        return new double[]{s, p};
    }

    public static double[] chiSquareTest(Array o) {
        long[][] od = (long[][])ArrayUtil.copyToNDJavaArray_Long((Array)o);
        double s = InferenceTestUtils.chiSquare((long[][])od);
        double p = InferenceTestUtils.chiSquareTest((long[][])od);
        return new double[]{s, p};
    }

    public static Array jenksBreaks(Array a, int nClass) {
        Jenks jenks = new Jenks();
        IndexIterator iterA = a.getIndexIterator();
        while (iterA.hasNext()) {
            jenks.addValue(iterA.getDoubleNext());
        }
        Jenks.Breaks breaks = jenks.computeBreaks(nClass);
        Array r = breaks.getClassValues();
        return r;
    }

    public static Object[] jenksBreaksGvf(Array a, int nClass) {
        Jenks jenks = new Jenks();
        IndexIterator iterA = a.getIndexIterator();
        while (iterA.hasNext()) {
            jenks.addValue(iterA.getDoubleNext());
        }
        Jenks.Breaks breaks = jenks.computeBreaks(nClass);
        Array r = breaks.getClassValues();
        return new Object[]{r, breaks.gvf()};
    }
}

