/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.meteoinfo.math.interpolate.RectInterpolator;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.math.ArrayUtil;

public class RectLinearInterpolator
extends RectInterpolator {
    public RectLinearInterpolator(Array xa, Array ya, Array va) {
        super(xa, ya, va);
    }

    @Override
    double cellValue(Index dindex, double x, double y) {
        double iValue = Double.NaN;
        int[] xyIdx = ArrayUtil.gridIndex((Array)this.xa, (Array)this.ya, (double)x, (double)y);
        if (xyIdx == null) {
            return iValue;
        }
        int i1 = xyIdx[0];
        int j1 = xyIdx[1];
        int i2 = i1 + 1;
        int j2 = j1 + 1;
        Index index = this.va.getIndex();
        int n = index.getRank();
        for (int i = 0; i < n - 2; ++i) {
            index.setDim(i, dindex.getCurrentCounter()[i]);
        }
        index.setDim(n - 2, i1);
        index.setDim(n - 1, j1);
        double a = this.va.getDouble(index);
        index.setDim(n - 1, j2);
        double b = this.va.getDouble(index);
        index.setDim(n - 2, i2);
        index.setDim(n - 1, j1);
        double c = this.va.getDouble(index);
        index.setDim(n - 2, i2);
        index.setDim(n - 1, j2);
        double d = this.va.getDouble(index);
        ArrayList<Double> dList = new ArrayList<Double>();
        if (!Double.isNaN(a)) {
            dList.add(a);
        }
        if (!Double.isNaN(b)) {
            dList.add(b);
        }
        if (!Double.isNaN(c)) {
            dList.add(c);
        }
        if (!Double.isNaN(d)) {
            dList.add(d);
        }
        if (dList.isEmpty()) {
            return iValue;
        }
        if (dList.size() == 1) {
            iValue = (Double)dList.get(0);
        } else if (dList.size() <= 3) {
            double aSum = 0.0;
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                double dd = (Double)iterator.next();
                aSum += dd;
            }
            iValue = aSum / (double)dList.size();
        } else {
            double dx = this.xa.getDouble(j1 + 1) - this.xa.getDouble(j1);
            double dy = this.ya.getDouble(i1 + 1) - this.ya.getDouble(i1);
            double x1val = a + (c - a) * (y - this.ya.getDouble(i1)) / dy;
            double x2val = b + (d - b) * (y - this.ya.getDouble(i1)) / dy;
            iValue = x1val + (x2val - x1val) * (x - this.xa.getDouble(j1)) / dx;
        }
        return iValue;
    }

    @Override
    double interpolate(double x, double y) {
        List<Array> points = Arrays.asList(this.ya, this.xa);
        Array xi = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{2});
        xi.setDouble(0, y);
        xi.setDouble(1, x);
        return ArrayUtil.interpn_s(points, (Array)this.va, (Array)xi);
    }
}

