/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.blas.openblas;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.bytedeco.openblas.global.openblas;
import org.meteoinfo.math.blas.Diag;
import org.meteoinfo.math.blas.EVDJob;
import org.meteoinfo.math.blas.EigenRange;
import org.meteoinfo.math.blas.Layout;
import org.meteoinfo.math.blas.LinearAlgebra;
import org.meteoinfo.math.blas.SVDJob;
import org.meteoinfo.math.blas.Side;
import org.meteoinfo.math.blas.Transpose;
import org.meteoinfo.math.blas.UPLO;

public class OpenBLAS
extends LinearAlgebra {
    @Override
    public double asum(int n, double[] x, int incx) {
        return openblas.cblas_dasum((int)n, (double[])x, (int)incx);
    }

    @Override
    public float asum(int n, float[] x, int incx) {
        return openblas.cblas_sasum((int)n, (float[])x, (int)incx);
    }

    @Override
    public void axpy(int n, double alpha, double[] x, int incx, double[] y, int incy) {
        openblas.cblas_daxpy((int)n, (double)alpha, (double[])x, (int)incx, (double[])y, (int)incy);
    }

    @Override
    public void axpy(int n, float alpha, float[] x, int incx, float[] y, int incy) {
        openblas.cblas_saxpy((int)n, (float)alpha, (float[])x, (int)incx, (float[])y, (int)incy);
    }

    @Override
    public double dot(int n, double[] x, int incx, double[] y, int incy) {
        return openblas.cblas_ddot((int)n, (double[])x, (int)incx, (double[])y, (int)incy);
    }

    @Override
    public float dot(int n, float[] x, int incx, float[] y, int incy) {
        return openblas.cblas_sdot((int)n, (float[])x, (int)incx, (float[])y, (int)incy);
    }

    @Override
    public double nrm2(int n, double[] x, int incx) {
        return openblas.cblas_dnrm2((int)n, (double[])x, (int)incx);
    }

    @Override
    public float nrm2(int n, float[] x, int incx) {
        return openblas.cblas_snrm2((int)n, (float[])x, (int)incx);
    }

    @Override
    public void scal(int n, double alpha, double[] x, int incx) {
        openblas.cblas_dscal((int)n, (double)alpha, (double[])x, (int)incx);
    }

    @Override
    public void scal(int n, float alpha, float[] x, int incx) {
        openblas.cblas_sscal((int)n, (float)alpha, (float[])x, (int)incx);
    }

    @Override
    public void swap(int n, double[] x, int incx, double[] y, int incy) {
        openblas.cblas_dswap((int)n, (double[])x, (int)incx, (double[])y, (int)incy);
    }

    @Override
    public void swap(int n, float[] x, int incx, float[] y, int incy) {
        openblas.cblas_sswap((int)n, (float[])x, (int)incx, (float[])y, (int)incy);
    }

    @Override
    public long iamax(int n, double[] x, int incx) {
        return openblas.cblas_idamax((int)n, (double[])x, (int)incx);
    }

    @Override
    public long iamax(int n, float[] x, int incx) {
        return openblas.cblas_isamax((int)n, (float[])x, (int)incx);
    }

    @Override
    public void gemv(Layout layout, Transpose trans, int m, int n, double alpha, double[] A, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        openblas.cblas_dgemv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (double)alpha, (double[])A, (int)lda, (double[])x, (int)incx, (double)beta, (double[])y, (int)incy);
    }

    @Override
    public void gemv(Layout layout, Transpose trans, int m, int n, double alpha, DoubleBuffer A, int lda, DoubleBuffer x, int incx, double beta, DoubleBuffer y, int incy) {
        openblas.cblas_dgemv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)x, (int)incx, (double)beta, (DoubleBuffer)y, (int)incy);
    }

    @Override
    public void gemv(Layout layout, Transpose trans, int m, int n, float alpha, float[] A, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        openblas.cblas_sgemv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (float)alpha, (float[])A, (int)lda, (float[])x, (int)incx, (float)beta, (float[])y, (int)incy);
    }

    @Override
    public void gemv(Layout layout, Transpose trans, int m, int n, float alpha, FloatBuffer A, int lda, FloatBuffer x, int incx, float beta, FloatBuffer y, int incy) {
        openblas.cblas_sgemv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)x, (int)incx, (float)beta, (FloatBuffer)y, (int)incy);
    }

    @Override
    public void symv(Layout layout, UPLO uplo, int n, double alpha, double[] A, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        openblas.cblas_dsymv((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (double[])A, (int)lda, (double[])x, (int)incx, (double)beta, (double[])y, (int)incy);
    }

    @Override
    public void symv(Layout layout, UPLO uplo, int n, double alpha, DoubleBuffer A, int lda, DoubleBuffer x, int incx, double beta, DoubleBuffer y, int incy) {
        openblas.cblas_dsymv((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)x, (int)incx, (double)beta, (DoubleBuffer)y, (int)incy);
    }

    @Override
    public void symv(Layout layout, UPLO uplo, int n, float alpha, float[] A, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        openblas.cblas_ssymv((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (float[])A, (int)lda, (float[])x, (int)incx, (float)beta, (float[])y, (int)incy);
    }

    @Override
    public void symv(Layout layout, UPLO uplo, int n, float alpha, FloatBuffer A, int lda, FloatBuffer x, int incx, float beta, FloatBuffer y, int incy) {
        openblas.cblas_ssymv((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)x, (int)incx, (float)beta, (FloatBuffer)y, (int)incy);
    }

    @Override
    public void spmv(Layout layout, UPLO uplo, int n, double alpha, double[] A, double[] x, int incx, double beta, double[] y, int incy) {
        openblas.cblas_dspmv((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (double[])A, (double[])x, (int)incx, (double)beta, (double[])y, (int)incy);
    }

    @Override
    public void spmv(Layout layout, UPLO uplo, int n, double alpha, DoubleBuffer A, DoubleBuffer x, int incx, double beta, DoubleBuffer y, int incy) {
        openblas.cblas_dspmv((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (DoubleBuffer)A, (DoubleBuffer)x, (int)incx, (double)beta, (DoubleBuffer)y, (int)incy);
    }

    @Override
    public void spmv(Layout layout, UPLO uplo, int n, float alpha, float[] A, float[] x, int incx, float beta, float[] y, int incy) {
        openblas.cblas_sspmv((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (float[])A, (float[])x, (int)incx, (float)beta, (float[])y, (int)incy);
    }

    @Override
    public void spmv(Layout layout, UPLO uplo, int n, float alpha, FloatBuffer A, FloatBuffer x, int incx, float beta, FloatBuffer y, int incy) {
        openblas.cblas_sspmv((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (FloatBuffer)A, (FloatBuffer)x, (int)incx, (float)beta, (FloatBuffer)y, (int)incy);
    }

    @Override
    public void trmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, double[] A, int lda, double[] x, int incx) {
        openblas.cblas_dtrmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (double[])A, (int)lda, (double[])x, (int)incx);
    }

    @Override
    public void trmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, DoubleBuffer A, int lda, DoubleBuffer x, int incx) {
        openblas.cblas_dtrmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)x, (int)incx);
    }

    @Override
    public void trmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, float[] A, int lda, float[] x, int incx) {
        openblas.cblas_strmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (float[])A, (int)lda, (float[])x, (int)incx);
    }

    @Override
    public void trmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, FloatBuffer A, int lda, FloatBuffer x, int incx) {
        openblas.cblas_strmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)x, (int)incx);
    }

    @Override
    public void tpmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, double[] A, double[] x, int incx) {
        openblas.cblas_dtpmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (double[])A, (double[])x, (int)incx);
    }

    @Override
    public void tpmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, DoubleBuffer A, DoubleBuffer x, int incx) {
        openblas.cblas_dtpmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (DoubleBuffer)A, (DoubleBuffer)x, (int)incx);
    }

    @Override
    public void tpmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, float[] A, float[] x, int incx) {
        openblas.cblas_stpmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (float[])A, (float[])x, (int)incx);
    }

    @Override
    public void tpmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, FloatBuffer A, FloatBuffer x, int incx) {
        openblas.cblas_stpmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (FloatBuffer)A, (FloatBuffer)x, (int)incx);
    }

    @Override
    public void gbmv(Layout layout, Transpose trans, int m, int n, int kl, int ku, double alpha, double[] A, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        openblas.cblas_dgbmv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (int)kl, (int)ku, (double)alpha, (double[])A, (int)lda, (double[])x, (int)incx, (double)beta, (double[])y, (int)incy);
    }

    @Override
    public void gbmv(Layout layout, Transpose trans, int m, int n, int kl, int ku, double alpha, DoubleBuffer A, int lda, DoubleBuffer x, int incx, double beta, DoubleBuffer y, int incy) {
        openblas.cblas_dgbmv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (int)kl, (int)ku, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)x, (int)incx, (double)beta, (DoubleBuffer)y, (int)incy);
    }

    @Override
    public void gbmv(Layout layout, Transpose trans, int m, int n, int kl, int ku, float alpha, float[] A, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        openblas.cblas_sgbmv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (int)kl, (int)ku, (float)alpha, (float[])A, (int)lda, (float[])x, (int)incx, (float)beta, (float[])y, (int)incy);
    }

    @Override
    public void gbmv(Layout layout, Transpose trans, int m, int n, int kl, int ku, float alpha, FloatBuffer A, int lda, FloatBuffer x, int incx, float beta, FloatBuffer y, int incy) {
        openblas.cblas_sgbmv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (int)kl, (int)ku, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)x, (int)incx, (float)beta, (FloatBuffer)y, (int)incy);
    }

    @Override
    public void sbmv(Layout layout, UPLO uplo, int n, int k, double alpha, double[] A, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        openblas.cblas_dsbmv((int)layout.blas(), (int)uplo.blas(), (int)n, (int)k, (double)alpha, (double[])A, (int)lda, (double[])x, (int)incx, (double)beta, (double[])y, (int)incy);
    }

    @Override
    public void sbmv(Layout layout, UPLO uplo, int n, int k, double alpha, DoubleBuffer A, int lda, DoubleBuffer x, int incx, double beta, DoubleBuffer y, int incy) {
        openblas.cblas_dsbmv((int)layout.blas(), (int)uplo.blas(), (int)n, (int)k, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)x, (int)incx, (double)beta, (DoubleBuffer)y, (int)incy);
    }

    @Override
    public void sbmv(Layout layout, UPLO uplo, int n, int k, float alpha, float[] A, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        openblas.cblas_ssbmv((int)layout.blas(), (int)uplo.blas(), (int)n, (int)k, (float)alpha, (float[])A, (int)lda, (float[])x, (int)incx, (float)beta, (float[])y, (int)incy);
    }

    @Override
    public void sbmv(Layout layout, UPLO uplo, int n, int k, float alpha, FloatBuffer A, int lda, FloatBuffer x, int incx, float beta, FloatBuffer y, int incy) {
        openblas.cblas_ssbmv((int)layout.blas(), (int)uplo.blas(), (int)n, (int)k, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)x, (int)incx, (float)beta, (FloatBuffer)y, (int)incy);
    }

    @Override
    public void ger(Layout layout, int m, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] A, int lda) {
        openblas.cblas_dger((int)layout.blas(), (int)m, (int)n, (double)alpha, (double[])x, (int)incx, (double[])y, (int)incy, (double[])A, (int)lda);
    }

    @Override
    public void ger(Layout layout, int m, int n, double alpha, DoubleBuffer x, int incx, DoubleBuffer y, int incy, DoubleBuffer A, int lda) {
        openblas.cblas_dger((int)layout.blas(), (int)m, (int)n, (double)alpha, (DoubleBuffer)x, (int)incx, (DoubleBuffer)y, (int)incy, (DoubleBuffer)A, (int)lda);
    }

    @Override
    public void ger(Layout layout, int m, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] A, int lda) {
        openblas.cblas_sger((int)layout.blas(), (int)m, (int)n, (float)alpha, (float[])x, (int)incx, (float[])y, (int)incy, (float[])A, (int)lda);
    }

    @Override
    public void ger(Layout layout, int m, int n, float alpha, FloatBuffer x, int incx, FloatBuffer y, int incy, FloatBuffer A, int lda) {
        openblas.cblas_sger((int)layout.blas(), (int)m, (int)n, (float)alpha, (FloatBuffer)x, (int)incx, (FloatBuffer)y, (int)incy, (FloatBuffer)A, (int)lda);
    }

    @Override
    public void syr(Layout layout, UPLO uplo, int n, double alpha, double[] x, int incx, double[] A, int lda) {
        openblas.cblas_dsyr((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (double[])x, (int)incx, (double[])A, (int)lda);
    }

    @Override
    public void syr(Layout layout, UPLO uplo, int n, double alpha, DoubleBuffer x, int incx, DoubleBuffer A, int lda) {
        openblas.cblas_dsyr((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (DoubleBuffer)x, (int)incx, (DoubleBuffer)A, (int)lda);
    }

    @Override
    public void syr(Layout layout, UPLO uplo, int n, float alpha, float[] x, int incx, float[] A, int lda) {
        openblas.cblas_ssyr((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (float[])x, (int)incx, (float[])A, (int)lda);
    }

    @Override
    public void syr(Layout layout, UPLO uplo, int n, float alpha, FloatBuffer x, int incx, FloatBuffer A, int lda) {
        openblas.cblas_ssyr((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (FloatBuffer)x, (int)incx, (FloatBuffer)A, (int)lda);
    }

    @Override
    public void spr(Layout layout, UPLO uplo, int n, double alpha, double[] x, int incx, double[] A) {
        openblas.cblas_dspr((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (double[])x, (int)incx, (double[])A);
    }

    @Override
    public void spr(Layout layout, UPLO uplo, int n, double alpha, DoubleBuffer x, int incx, DoubleBuffer A) {
        openblas.cblas_dspr((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (DoubleBuffer)x, (int)incx, (DoubleBuffer)A);
    }

    @Override
    public void spr(Layout layout, UPLO uplo, int n, float alpha, float[] x, int incx, float[] A) {
        openblas.cblas_sspr((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (float[])x, (int)incx, (float[])A);
    }

    @Override
    public void spr(Layout layout, UPLO uplo, int n, float alpha, FloatBuffer x, int incx, FloatBuffer A) {
        openblas.cblas_sspr((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (FloatBuffer)x, (int)incx, (FloatBuffer)A);
    }

    @Override
    public void gemm(Layout layout, Transpose transA, Transpose transB, int m, int n, int k, double alpha, double[] A, int lda, double[] B, int ldb, double beta, double[] C, int ldc) {
        openblas.cblas_dgemm((int)layout.blas(), (int)transA.blas(), (int)transB.blas(), (int)m, (int)n, (int)k, (double)alpha, (double[])A, (int)lda, (double[])B, (int)ldb, (double)beta, (double[])C, (int)ldc);
    }

    @Override
    public void gemm(Layout layout, Transpose transA, Transpose transB, int m, int n, int k, double alpha, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, double beta, DoubleBuffer C, int ldc) {
        openblas.cblas_dgemm((int)layout.blas(), (int)transA.blas(), (int)transB.blas(), (int)m, (int)n, (int)k, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (double)beta, (DoubleBuffer)C, (int)ldc);
    }

    @Override
    public void gemm(Layout layout, Transpose transA, Transpose transB, int m, int n, int k, float alpha, float[] A, int lda, float[] B, int ldb, float beta, float[] C, int ldc) {
        openblas.cblas_sgemm((int)layout.blas(), (int)transA.blas(), (int)transB.blas(), (int)m, (int)n, (int)k, (float)alpha, (float[])A, (int)lda, (float[])B, (int)ldb, (float)beta, (float[])C, (int)ldc);
    }

    @Override
    public void gemm(Layout layout, Transpose transA, Transpose transB, int m, int n, int k, float alpha, FloatBuffer A, int lda, FloatBuffer B, int ldb, float beta, FloatBuffer C, int ldc) {
        openblas.cblas_sgemm((int)layout.blas(), (int)transA.blas(), (int)transB.blas(), (int)m, (int)n, (int)k, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (float)beta, (FloatBuffer)C, (int)ldc);
    }

    @Override
    public void symm(Layout layout, Side side, UPLO uplo, int m, int n, double alpha, double[] A, int lda, double[] B, int ldb, double beta, double[] C, int ldc) {
        openblas.cblas_dsymm((int)layout.blas(), (int)side.blas(), (int)uplo.blas(), (int)m, (int)n, (double)alpha, (double[])A, (int)lda, (double[])B, (int)ldb, (double)beta, (double[])C, (int)ldc);
    }

    @Override
    public void symm(Layout layout, Side side, UPLO uplo, int m, int n, double alpha, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, double beta, DoubleBuffer C, int ldc) {
        openblas.cblas_dsymm((int)layout.blas(), (int)side.blas(), (int)uplo.blas(), (int)m, (int)n, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (double)beta, (DoubleBuffer)C, (int)ldc);
    }

    @Override
    public void symm(Layout layout, Side side, UPLO uplo, int m, int n, float alpha, float[] A, int lda, float[] B, int ldb, float beta, float[] C, int ldc) {
        openblas.cblas_ssymm((int)layout.blas(), (int)side.blas(), (int)uplo.blas(), (int)m, (int)n, (float)alpha, (float[])A, (int)lda, (float[])B, (int)ldb, (float)beta, (float[])C, (int)ldc);
    }

    @Override
    public void symm(Layout layout, Side side, UPLO uplo, int m, int n, float alpha, FloatBuffer A, int lda, FloatBuffer B, int ldb, float beta, FloatBuffer C, int ldc) {
        openblas.cblas_ssymm((int)layout.blas(), (int)side.blas(), (int)uplo.blas(), (int)m, (int)n, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (float)beta, (FloatBuffer)C, (int)ldc);
    }

    @Override
    public int gesv(Layout layout, int n, int nrhs, double[] A, int lda, int[] ipiv, double[] B, int ldb) {
        return openblas.LAPACKE_dgesv((int)layout.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (int[])ipiv, (double[])B, (int)ldb);
    }

    @Override
    public int gesv(Layout layout, int n, int nrhs, DoubleBuffer A, int lda, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dgesv((int)layout.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int gesv(Layout layout, int n, int nrhs, float[] A, int lda, int[] ipiv, float[] B, int ldb) {
        return openblas.LAPACKE_sgesv((int)layout.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (int[])ipiv, (float[])B, (int)ldb);
    }

    @Override
    public int gesv(Layout layout, int n, int nrhs, FloatBuffer A, int lda, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_sgesv((int)layout.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int sysv(Layout layout, UPLO uplo, int n, int nrhs, double[] A, int lda, int[] ipiv, double[] B, int ldb) {
        return openblas.LAPACKE_dsysv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (int[])ipiv, (double[])B, (int)ldb);
    }

    @Override
    public int sysv(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer A, int lda, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dsysv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int sysv(Layout layout, UPLO uplo, int n, int nrhs, float[] A, int lda, int[] ipiv, float[] B, int ldb) {
        return openblas.LAPACKE_ssysv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (int[])ipiv, (float[])B, (int)ldb);
    }

    @Override
    public int sysv(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer A, int lda, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_ssysv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int spsv(Layout layout, UPLO uplo, int n, int nrhs, double[] A, int[] ipiv, double[] B, int ldb) {
        return openblas.LAPACKE_dspsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])A, (int[])ipiv, (double[])B, (int)ldb);
    }

    @Override
    public int spsv(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer A, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dspsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int spsv(Layout layout, UPLO uplo, int n, int nrhs, float[] A, int[] ipiv, float[] B, int ldb) {
        return openblas.LAPACKE_sspsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])A, (int[])ipiv, (float[])B, (int)ldb);
    }

    @Override
    public int spsv(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer A, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_sspsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int posv(Layout layout, UPLO uplo, int n, int nrhs, double[] A, int lda, double[] B, int ldb) {
        return openblas.LAPACKE_dposv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb);
    }

    @Override
    public int posv(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dposv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int posv(Layout layout, UPLO uplo, int n, int nrhs, float[] A, int lda, float[] B, int ldb) {
        return openblas.LAPACKE_sposv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb);
    }

    @Override
    public int posv(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_sposv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int ppsv(Layout layout, UPLO uplo, int n, int nrhs, double[] A, double[] B, int ldb) {
        return openblas.LAPACKE_dppsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])A, (double[])B, (int)ldb);
    }

    @Override
    public int ppsv(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer A, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dppsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int ppsv(Layout layout, UPLO uplo, int n, int nrhs, float[] A, float[] B, int ldb) {
        return openblas.LAPACKE_sppsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])A, (float[])B, (int)ldb);
    }

    @Override
    public int ppsv(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer A, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_sppsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int gbsv(Layout layout, int n, int kl, int ku, int nrhs, double[] A, int lda, int[] ipiv, double[] B, int ldb) {
        return openblas.LAPACKE_dgbsv((int)layout.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (double[])A, (int)lda, (int[])ipiv, (double[])B, (int)ldb);
    }

    @Override
    public int gbsv(Layout layout, int n, int kl, int ku, int nrhs, DoubleBuffer A, int lda, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dgbsv((int)layout.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int gbsv(Layout layout, int n, int kl, int ku, int nrhs, float[] A, int lda, int[] ipiv, float[] B, int ldb) {
        return openblas.LAPACKE_sgbsv((int)layout.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (float[])A, (int)lda, (int[])ipiv, (float[])B, (int)ldb);
    }

    @Override
    public int gbsv(Layout layout, int n, int kl, int ku, int nrhs, FloatBuffer A, int lda, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_sgbsv((int)layout.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int gels(Layout layout, Transpose trans, int m, int n, int nrhs, double[] A, int lda, double[] B, int ldb) {
        return openblas.LAPACKE_dgels((int)layout.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb);
    }

    @Override
    public int gels(Layout layout, Transpose trans, int m, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dgels((int)layout.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int gels(Layout layout, Transpose trans, int m, int n, int nrhs, float[] A, int lda, float[] B, int ldb) {
        return openblas.LAPACKE_sgels((int)layout.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb);
    }

    @Override
    public int gels(Layout layout, Transpose trans, int m, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_sgels((int)layout.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int gelsy(Layout layout, int m, int n, int nrhs, double[] A, int lda, double[] B, int ldb, int[] jpvt, double rcond, int[] rank) {
        return openblas.LAPACKE_dgelsy((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb, (int[])jpvt, (double)rcond, (int[])rank);
    }

    @Override
    public int gelsy(Layout layout, int m, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, IntBuffer jpvt, double rcond, IntBuffer rank) {
        return openblas.LAPACKE_dgelsy((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (IntBuffer)jpvt, (double)rcond, (IntBuffer)rank);
    }

    @Override
    public int gelsy(Layout layout, int m, int n, int nrhs, float[] A, int lda, float[] B, int ldb, int[] jpvt, float rcond, int[] rank) {
        return openblas.LAPACKE_sgelsy((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb, (int[])jpvt, (float)rcond, (int[])rank);
    }

    @Override
    public int gelsy(Layout layout, int m, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb, IntBuffer jpvt, float rcond, IntBuffer rank) {
        return openblas.LAPACKE_sgelsy((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (IntBuffer)jpvt, (float)rcond, (IntBuffer)rank);
    }

    @Override
    public int gelss(Layout layout, int m, int n, int nrhs, double[] A, int lda, double[] B, int ldb, double[] s, double rcond, int[] rank) {
        return openblas.LAPACKE_dgelss((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb, (double[])s, (double)rcond, (int[])rank);
    }

    @Override
    public int gelss(Layout layout, int m, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, DoubleBuffer s, double rcond, IntBuffer rank) {
        return openblas.LAPACKE_dgelss((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (DoubleBuffer)s, (double)rcond, (IntBuffer)rank);
    }

    @Override
    public int gelss(Layout layout, int m, int n, int nrhs, float[] A, int lda, float[] B, int ldb, float[] s, float rcond, int[] rank) {
        return openblas.LAPACKE_sgelss((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb, (float[])s, (float)rcond, (int[])rank);
    }

    @Override
    public int gelss(Layout layout, int m, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb, FloatBuffer s, float rcond, IntBuffer rank) {
        return openblas.LAPACKE_sgelss((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (FloatBuffer)s, (float)rcond, (IntBuffer)rank);
    }

    @Override
    public int gelsd(Layout layout, int m, int n, int nrhs, double[] A, int lda, double[] B, int ldb, double[] s, double rcond, int[] rank) {
        return openblas.LAPACKE_dgelsd((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb, (double[])s, (double)rcond, (int[])rank);
    }

    @Override
    public int gelsd(Layout layout, int m, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, DoubleBuffer s, double rcond, IntBuffer rank) {
        return openblas.LAPACKE_dgelsd((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (DoubleBuffer)s, (double)rcond, (IntBuffer)rank);
    }

    @Override
    public int gelsd(Layout layout, int m, int n, int nrhs, float[] A, int lda, float[] B, int ldb, float[] s, float rcond, int[] rank) {
        return openblas.LAPACKE_sgelsd((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb, (float[])s, (float)rcond, (int[])rank);
    }

    @Override
    public int gelsd(Layout layout, int m, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb, FloatBuffer s, float rcond, IntBuffer rank) {
        return openblas.LAPACKE_sgelsd((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (FloatBuffer)s, (float)rcond, (IntBuffer)rank);
    }

    @Override
    public int gglse(Layout layout, int m, int n, int p, double[] A, int lda, double[] B, int ldb, double[] c, double[] d, double[] x) {
        return openblas.LAPACKE_dgglse((int)layout.lapack(), (int)m, (int)n, (int)p, (double[])A, (int)lda, (double[])B, (int)ldb, (double[])c, (double[])d, (double[])x);
    }

    @Override
    public int gglse(Layout layout, int m, int n, int p, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, DoubleBuffer c, DoubleBuffer d, DoubleBuffer x) {
        return openblas.LAPACKE_dgglse((int)layout.lapack(), (int)m, (int)n, (int)p, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (DoubleBuffer)c, (DoubleBuffer)d, (DoubleBuffer)x);
    }

    @Override
    public int gglse(Layout layout, int m, int n, int p, float[] A, int lda, float[] B, int ldb, float[] c, float[] d, float[] x) {
        return openblas.LAPACKE_sgglse((int)layout.lapack(), (int)m, (int)n, (int)p, (float[])A, (int)lda, (float[])B, (int)ldb, (float[])c, (float[])d, (float[])x);
    }

    @Override
    public int gglse(Layout layout, int m, int n, int p, FloatBuffer A, int lda, FloatBuffer B, int ldb, FloatBuffer c, FloatBuffer d, FloatBuffer x) {
        return openblas.LAPACKE_sgglse((int)layout.lapack(), (int)m, (int)n, (int)p, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (FloatBuffer)c, (FloatBuffer)d, (FloatBuffer)x);
    }

    @Override
    public int ggglm(Layout layout, int n, int m, int p, double[] A, int lda, double[] B, int ldb, double[] d, double[] x, double[] y) {
        return openblas.LAPACKE_dggglm((int)layout.lapack(), (int)n, (int)m, (int)p, (double[])A, (int)lda, (double[])B, (int)ldb, (double[])d, (double[])x, (double[])y);
    }

    @Override
    public int ggglm(Layout layout, int n, int m, int p, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, DoubleBuffer d, DoubleBuffer x, DoubleBuffer y) {
        return openblas.LAPACKE_dggglm((int)layout.lapack(), (int)n, (int)m, (int)p, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (DoubleBuffer)d, (DoubleBuffer)x, (DoubleBuffer)y);
    }

    @Override
    public int ggglm(Layout layout, int n, int m, int p, float[] A, int lda, float[] B, int ldb, float[] d, float[] x, float[] y) {
        return openblas.LAPACKE_sggglm((int)layout.lapack(), (int)n, (int)m, (int)p, (float[])A, (int)lda, (float[])B, (int)ldb, (float[])d, (float[])x, (float[])y);
    }

    @Override
    public int ggglm(Layout layout, int n, int m, int p, FloatBuffer A, int lda, FloatBuffer B, int ldb, FloatBuffer d, FloatBuffer x, FloatBuffer y) {
        return openblas.LAPACKE_sggglm((int)layout.lapack(), (int)n, (int)m, (int)p, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (FloatBuffer)d, (FloatBuffer)x, (FloatBuffer)y);
    }

    @Override
    public int geev(Layout layout, EVDJob jobvl, EVDJob jobvr, int n, double[] A, int lda, double[] wr, double[] wi, double[] Vl, int ldvl, double[] Vr, int ldvr) {
        return openblas.LAPACKE_dgeev((int)layout.lapack(), (byte)jobvl.lapack(), (byte)jobvr.lapack(), (int)n, (double[])A, (int)lda, (double[])wr, (double[])wi, (double[])Vl, (int)ldvl, (double[])Vr, (int)ldvr);
    }

    @Override
    public int geev(Layout layout, EVDJob jobvl, EVDJob jobvr, int n, DoubleBuffer A, int lda, DoubleBuffer wr, DoubleBuffer wi, DoubleBuffer Vl, int ldvl, DoubleBuffer Vr, int ldvr) {
        return openblas.LAPACKE_dgeev((int)layout.lapack(), (byte)jobvl.lapack(), (byte)jobvr.lapack(), (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)wr, (DoubleBuffer)wi, (DoubleBuffer)Vl, (int)ldvl, (DoubleBuffer)Vr, (int)ldvr);
    }

    @Override
    public int geev(Layout layout, EVDJob jobvl, EVDJob jobvr, int n, float[] A, int lda, float[] wr, float[] wi, float[] Vl, int ldvl, float[] Vr, int ldvr) {
        return openblas.LAPACKE_sgeev((int)layout.lapack(), (byte)jobvl.lapack(), (byte)jobvr.lapack(), (int)n, (float[])A, (int)lda, (float[])wr, (float[])wi, (float[])Vl, (int)ldvl, (float[])Vr, (int)ldvr);
    }

    @Override
    public int geev(Layout layout, EVDJob jobvl, EVDJob jobvr, int n, FloatBuffer A, int lda, FloatBuffer wr, FloatBuffer wi, FloatBuffer Vl, int ldvl, FloatBuffer Vr, int ldvr) {
        return openblas.LAPACKE_sgeev((int)layout.lapack(), (byte)jobvl.lapack(), (byte)jobvr.lapack(), (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)wr, (FloatBuffer)wi, (FloatBuffer)Vl, (int)ldvl, (FloatBuffer)Vr, (int)ldvr);
    }

    @Override
    public int syev(Layout layout, EVDJob jobz, UPLO uplo, int n, double[] A, int lda, double[] w) {
        return openblas.LAPACKE_dsyev((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (double[])A, (int)lda, (double[])w);
    }

    @Override
    public int syev(Layout layout, EVDJob jobz, UPLO uplo, int n, DoubleBuffer A, int lda, DoubleBuffer w) {
        return openblas.LAPACKE_dsyev((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)w);
    }

    @Override
    public int syev(Layout layout, EVDJob jobz, UPLO uplo, int n, float[] A, int lda, float[] w) {
        return openblas.LAPACKE_ssyev((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (float[])A, (int)lda, (float[])w);
    }

    @Override
    public int syev(Layout layout, EVDJob jobz, UPLO uplo, int n, FloatBuffer A, int lda, FloatBuffer w) {
        return openblas.LAPACKE_ssyev((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)w);
    }

    @Override
    public int syevd(Layout layout, EVDJob jobz, UPLO uplo, int n, double[] A, int lda, double[] w) {
        return openblas.LAPACKE_dsyevd((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (double[])A, (int)lda, (double[])w);
    }

    @Override
    public int syevd(Layout layout, EVDJob jobz, UPLO uplo, int n, DoubleBuffer A, int lda, DoubleBuffer w) {
        return openblas.LAPACKE_dsyevd((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)w);
    }

    @Override
    public int syevd(Layout layout, EVDJob jobz, UPLO uplo, int n, float[] A, int lda, float[] w) {
        return openblas.LAPACKE_ssyevd((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (float[])A, (int)lda, (float[])w);
    }

    @Override
    public int syevd(Layout layout, EVDJob jobz, UPLO uplo, int n, FloatBuffer A, int lda, FloatBuffer w) {
        return openblas.LAPACKE_ssyevd((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)w);
    }

    @Override
    public int syevr(Layout layout, EVDJob jobz, EigenRange range, UPLO uplo, int n, double[] A, int lda, double vl, double vu, int il, int iu, double abstol, int[] m, double[] w, double[] Z, int ldz, int[] isuppz) {
        return openblas.LAPACKE_dsyevr((int)layout.lapack(), (byte)jobz.lapack(), (byte)range.lapack(), (byte)uplo.lapack(), (int)n, (double[])A, (int)lda, (double)vl, (double)vu, (int)il, (int)iu, (double)abstol, (int[])m, (double[])w, (double[])Z, (int)ldz, (int[])isuppz);
    }

    @Override
    public int syevr(Layout layout, EVDJob jobz, EigenRange range, UPLO uplo, int n, DoubleBuffer A, int lda, double vl, double vu, int il, int iu, double abstol, IntBuffer m, DoubleBuffer w, DoubleBuffer Z, int ldz, IntBuffer isuppz) {
        return openblas.LAPACKE_dsyevr((int)layout.lapack(), (byte)jobz.lapack(), (byte)range.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)A, (int)lda, (double)vl, (double)vu, (int)il, (int)iu, (double)abstol, (IntBuffer)m, (DoubleBuffer)w, (DoubleBuffer)Z, (int)ldz, (IntBuffer)isuppz);
    }

    @Override
    public int syevr(Layout layout, EVDJob jobz, EigenRange range, UPLO uplo, int n, float[] A, int lda, float vl, float vu, int il, int iu, float abstol, int[] m, float[] w, float[] Z, int ldz, int[] isuppz) {
        return openblas.LAPACKE_ssyevr((int)layout.lapack(), (byte)jobz.lapack(), (byte)range.lapack(), (byte)uplo.lapack(), (int)n, (float[])A, (int)lda, (float)vl, (float)vu, (int)il, (int)iu, (float)abstol, (int[])m, (float[])w, (float[])Z, (int)ldz, (int[])isuppz);
    }

    @Override
    public int syevr(Layout layout, EVDJob jobz, EigenRange range, UPLO uplo, int n, FloatBuffer A, int lda, float vl, float vu, int il, int iu, float abstol, IntBuffer m, FloatBuffer w, FloatBuffer Z, int ldz, IntBuffer isuppz) {
        return openblas.LAPACKE_ssyevr((int)layout.lapack(), (byte)jobz.lapack(), (byte)range.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)A, (int)lda, (float)vl, (float)vu, (int)il, (int)iu, (float)abstol, (IntBuffer)m, (FloatBuffer)w, (FloatBuffer)Z, (int)ldz, (IntBuffer)isuppz);
    }

    @Override
    public int gesvd(Layout layout, SVDJob jobu, SVDJob jobvt, int m, int n, double[] A, int lda, double[] s, double[] U, int ldu, double[] VT, int ldvt, double[] superb) {
        return openblas.LAPACKE_dgesvd((int)layout.lapack(), (byte)jobu.lapack(), (byte)jobvt.lapack(), (int)m, (int)n, (double[])A, (int)lda, (double[])s, (double[])U, (int)ldu, (double[])VT, (int)ldvt, (double[])superb);
    }

    @Override
    public int gesvd(Layout layout, SVDJob jobu, SVDJob jobvt, int m, int n, DoubleBuffer A, int lda, DoubleBuffer s, DoubleBuffer U, int ldu, DoubleBuffer VT, int ldvt, DoubleBuffer superb) {
        return openblas.LAPACKE_dgesvd((int)layout.lapack(), (byte)jobu.lapack(), (byte)jobvt.lapack(), (int)m, (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)s, (DoubleBuffer)U, (int)ldu, (DoubleBuffer)VT, (int)ldvt, (DoubleBuffer)superb);
    }

    @Override
    public int gesvd(Layout layout, SVDJob jobu, SVDJob jobvt, int m, int n, float[] A, int lda, float[] s, float[] U, int ldu, float[] VT, int ldvt, float[] superb) {
        return openblas.LAPACKE_sgesvd((int)layout.lapack(), (byte)jobu.lapack(), (byte)jobvt.lapack(), (int)m, (int)n, (float[])A, (int)lda, (float[])s, (float[])U, (int)ldu, (float[])VT, (int)ldvt, (float[])superb);
    }

    @Override
    public int gesvd(Layout layout, SVDJob jobu, SVDJob jobvt, int m, int n, FloatBuffer A, int lda, FloatBuffer s, FloatBuffer U, int ldu, FloatBuffer VT, int ldvt, FloatBuffer superb) {
        return openblas.LAPACKE_sgesvd((int)layout.lapack(), (byte)jobu.lapack(), (byte)jobvt.lapack(), (int)m, (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)s, (FloatBuffer)U, (int)ldu, (FloatBuffer)VT, (int)ldvt, (FloatBuffer)superb);
    }

    @Override
    public int gesdd(Layout layout, SVDJob jobz, int m, int n, double[] A, int lda, double[] s, double[] U, int ldu, double[] VT, int ldvt) {
        return openblas.LAPACKE_dgesdd((int)layout.lapack(), (byte)jobz.lapack(), (int)m, (int)n, (double[])A, (int)lda, (double[])s, (double[])U, (int)ldu, (double[])VT, (int)ldvt);
    }

    @Override
    public int gesdd(Layout layout, SVDJob jobz, int m, int n, DoubleBuffer A, int lda, DoubleBuffer s, DoubleBuffer U, int ldu, DoubleBuffer VT, int ldvt) {
        return openblas.LAPACKE_dgesdd((int)layout.lapack(), (byte)jobz.lapack(), (int)m, (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)s, (DoubleBuffer)U, (int)ldu, (DoubleBuffer)VT, (int)ldvt);
    }

    @Override
    public int gesdd(Layout layout, SVDJob jobz, int m, int n, float[] A, int lda, float[] s, float[] U, int ldu, float[] VT, int ldvt) {
        return openblas.LAPACKE_sgesdd((int)layout.lapack(), (byte)jobz.lapack(), (int)m, (int)n, (float[])A, (int)lda, (float[])s, (float[])U, (int)ldu, (float[])VT, (int)ldvt);
    }

    @Override
    public int gesdd(Layout layout, SVDJob jobz, int m, int n, FloatBuffer A, int lda, FloatBuffer s, FloatBuffer U, int ldu, FloatBuffer VT, int ldvt) {
        return openblas.LAPACKE_sgesdd((int)layout.lapack(), (byte)jobz.lapack(), (int)m, (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)s, (FloatBuffer)U, (int)ldu, (FloatBuffer)VT, (int)ldvt);
    }

    @Override
    public int getrf(Layout layout, int m, int n, DoubleBuffer A, int lda, IntBuffer ipiv) {
        return openblas.LAPACKE_dgetrf((int)layout.lapack(), (int)m, (int)n, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv);
    }

    @Override
    public int getrf(Layout layout, int m, int n, double[] A, int lda, int[] ipiv) {
        return openblas.LAPACKE_dgetrf((int)layout.lapack(), (int)m, (int)n, (double[])A, (int)lda, (int[])ipiv);
    }

    @Override
    public int getrf(Layout layout, int m, int n, float[] A, int lda, int[] ipiv) {
        return openblas.LAPACKE_sgetrf((int)layout.lapack(), (int)m, (int)n, (float[])A, (int)lda, (int[])ipiv);
    }

    @Override
    public int getrf(Layout layout, int m, int n, FloatBuffer A, int lda, IntBuffer ipiv) {
        return openblas.LAPACKE_sgetrf((int)layout.lapack(), (int)m, (int)n, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv);
    }

    @Override
    public int getrf2(Layout layout, int m, int n, double[] A, int lda, int[] ipiv) {
        return openblas.LAPACKE_dgetrf2((int)layout.lapack(), (int)m, (int)n, (double[])A, (int)lda, (int[])ipiv);
    }

    @Override
    public int getrf2(Layout layout, int m, int n, DoubleBuffer A, int lda, IntBuffer ipiv) {
        return openblas.LAPACKE_dgetrf2((int)layout.lapack(), (int)m, (int)n, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv);
    }

    @Override
    public int getrf2(Layout layout, int m, int n, float[] A, int lda, int[] ipiv) {
        return openblas.LAPACKE_sgetrf2((int)layout.lapack(), (int)m, (int)n, (float[])A, (int)lda, (int[])ipiv);
    }

    @Override
    public int getrf2(Layout layout, int m, int n, FloatBuffer A, int lda, IntBuffer ipiv) {
        return openblas.LAPACKE_sgetrf2((int)layout.lapack(), (int)m, (int)n, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv);
    }

    @Override
    public int gbtrf(Layout layout, int m, int n, int kl, int ku, double[] AB, int ldab, int[] ipiv) {
        return openblas.LAPACKE_dgbtrf((int)layout.lapack(), (int)m, (int)n, (int)kl, (int)ku, (double[])AB, (int)ldab, (int[])ipiv);
    }

    @Override
    public int gbtrf(Layout layout, int m, int n, int kl, int ku, DoubleBuffer AB, int ldab, IntBuffer ipiv) {
        return openblas.LAPACKE_dgbtrf((int)layout.lapack(), (int)m, (int)n, (int)kl, (int)ku, (DoubleBuffer)AB, (int)ldab, (IntBuffer)ipiv);
    }

    @Override
    public int gbtrf(Layout layout, int m, int n, int kl, int ku, float[] AB, int ldab, int[] ipiv) {
        return openblas.LAPACKE_sgbtrf((int)layout.lapack(), (int)m, (int)n, (int)kl, (int)ku, (float[])AB, (int)ldab, (int[])ipiv);
    }

    @Override
    public int gbtrf(Layout layout, int m, int n, int kl, int ku, FloatBuffer AB, int ldab, IntBuffer ipiv) {
        return openblas.LAPACKE_sgbtrf((int)layout.lapack(), (int)m, (int)n, (int)kl, (int)ku, (FloatBuffer)AB, (int)ldab, (IntBuffer)ipiv);
    }

    @Override
    public int sptrf(Layout layout, UPLO uplo, int n, double[] AP, int[] ipiv) {
        return openblas.LAPACKE_dsptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (double[])AP, (int[])ipiv);
    }

    @Override
    public int sptrf(Layout layout, UPLO uplo, int n, DoubleBuffer AP, IntBuffer ipiv) {
        return openblas.LAPACKE_dsptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)AP, (IntBuffer)ipiv);
    }

    @Override
    public int sptrf(Layout layout, UPLO uplo, int n, float[] AP, int[] ipiv) {
        return openblas.LAPACKE_ssptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (float[])AP, (int[])ipiv);
    }

    @Override
    public int sptrf(Layout layout, UPLO uplo, int n, FloatBuffer AP, IntBuffer ipiv) {
        return openblas.LAPACKE_ssptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)AP, (IntBuffer)ipiv);
    }

    @Override
    public int getrs(Layout layout, Transpose trans, int n, int nrhs, double[] A, int lda, int[] ipiv, double[] B, int ldb) {
        return openblas.LAPACKE_dgetrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (int[])ipiv, (double[])B, (int)ldb);
    }

    @Override
    public int getrs(Layout layout, Transpose trans, int n, int nrhs, DoubleBuffer A, int lda, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dgetrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int getrs(Layout layout, Transpose trans, int n, int nrhs, float[] A, int lda, int[] ipiv, float[] B, int ldb) {
        return openblas.LAPACKE_sgetrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (int[])ipiv, (float[])B, (int)ldb);
    }

    @Override
    public int getrs(Layout layout, Transpose trans, int n, int nrhs, FloatBuffer A, int lda, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_sgetrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int gbtrs(Layout layout, Transpose trans, int n, int kl, int ku, int nrhs, double[] A, int lda, int[] ipiv, double[] B, int ldb) {
        return openblas.LAPACKE_dgbtrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (double[])A, (int)lda, (int[])ipiv, (double[])B, (int)ldb);
    }

    @Override
    public int gbtrs(Layout layout, Transpose trans, int n, int kl, int ku, int nrhs, DoubleBuffer A, int lda, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dgbtrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int gbtrs(Layout layout, Transpose trans, int n, int kl, int ku, int nrhs, float[] A, int lda, int[] ipiv, float[] B, int ldb) {
        return openblas.LAPACKE_sgbtrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (float[])A, (int)lda, (int[])ipiv, (float[])B, (int)ldb);
    }

    @Override
    public int gbtrs(Layout layout, Transpose trans, int n, int kl, int ku, int nrhs, FloatBuffer A, int lda, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_sgbtrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int sptrs(Layout layout, UPLO uplo, int n, int nrhs, double[] AP, int[] ipiv, double[] B, int ldb) {
        return openblas.LAPACKE_dsptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])AP, (int[])ipiv, (double[])B, (int)ldb);
    }

    @Override
    public int sptrs(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer AP, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dsptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)AP, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int sptrs(Layout layout, UPLO uplo, int n, int nrhs, float[] AP, int[] ipiv, float[] B, int ldb) {
        return openblas.LAPACKE_ssptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])AP, (int[])ipiv, (float[])B, (int)ldb);
    }

    @Override
    public int sptrs(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer AP, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_ssptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)AP, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int potrf(Layout layout, UPLO uplo, int n, double[] A, int lda) {
        return openblas.LAPACKE_dpotrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (double[])A, (int)lda);
    }

    @Override
    public int potrf(Layout layout, UPLO uplo, int n, DoubleBuffer A, int lda) {
        return openblas.LAPACKE_dpotrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)A, (int)lda);
    }

    @Override
    public int potrf(Layout layout, UPLO uplo, int n, float[] A, int lda) {
        return openblas.LAPACKE_spotrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (float[])A, (int)lda);
    }

    @Override
    public int potrf(Layout layout, UPLO uplo, int n, FloatBuffer A, int lda) {
        return openblas.LAPACKE_spotrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)A, (int)lda);
    }

    @Override
    public int potrf2(Layout layout, UPLO uplo, int n, double[] A, int lda) {
        return openblas.LAPACKE_dpotrf2((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (double[])A, (int)lda);
    }

    @Override
    public int potrf2(Layout layout, UPLO uplo, int n, DoubleBuffer A, int lda) {
        return openblas.LAPACKE_dpotrf2((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)A, (int)lda);
    }

    @Override
    public int potrf2(Layout layout, UPLO uplo, int n, float[] A, int lda) {
        return openblas.LAPACKE_spotrf2((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (float[])A, (int)lda);
    }

    @Override
    public int potrf2(Layout layout, UPLO uplo, int n, FloatBuffer A, int lda) {
        return openblas.LAPACKE_spotrf2((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)A, (int)lda);
    }

    @Override
    public int pbtrf(Layout layout, UPLO uplo, int n, int kd, double[] AB, int ldab) {
        return openblas.LAPACKE_dpbtrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (double[])AB, (int)ldab);
    }

    @Override
    public int pbtrf(Layout layout, UPLO uplo, int n, int kd, DoubleBuffer AB, int ldab) {
        return openblas.LAPACKE_dpbtrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (DoubleBuffer)AB, (int)ldab);
    }

    @Override
    public int pbtrf(Layout layout, UPLO uplo, int n, int kd, float[] AB, int ldab) {
        return openblas.LAPACKE_spbtrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (float[])AB, (int)ldab);
    }

    @Override
    public int pbtrf(Layout layout, UPLO uplo, int n, int kd, FloatBuffer AB, int ldab) {
        return openblas.LAPACKE_spbtrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (FloatBuffer)AB, (int)ldab);
    }

    @Override
    public int pptrf(Layout layout, UPLO uplo, int n, double[] AP) {
        return openblas.LAPACKE_dpptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (double[])AP);
    }

    @Override
    public int pptrf(Layout layout, UPLO uplo, int n, DoubleBuffer AP) {
        return openblas.LAPACKE_dpptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)AP);
    }

    @Override
    public int pptrf(Layout layout, UPLO uplo, int n, float[] AP) {
        return openblas.LAPACKE_spptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (float[])AP);
    }

    @Override
    public int pptrf(Layout layout, UPLO uplo, int n, FloatBuffer AP) {
        return openblas.LAPACKE_spptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)AP);
    }

    @Override
    public int potrs(Layout layout, UPLO uplo, int n, int nrhs, double[] A, int lda, double[] B, int ldb) {
        return openblas.LAPACKE_dpotrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb);
    }

    @Override
    public int potrs(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dpotrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int potrs(Layout layout, UPLO uplo, int n, int nrhs, float[] A, int lda, float[] B, int ldb) {
        return openblas.LAPACKE_spotrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb);
    }

    @Override
    public int potrs(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_spotrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int pbtrs(Layout layout, UPLO uplo, int n, int kd, int nrhs, double[] AB, int ldab, double[] B, int ldb) {
        return openblas.LAPACKE_dpbtrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (int)nrhs, (double[])AB, (int)ldab, (double[])B, (int)ldb);
    }

    @Override
    public int pbtrs(Layout layout, UPLO uplo, int n, int kd, int nrhs, DoubleBuffer AB, int ldab, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dpbtrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (int)nrhs, (DoubleBuffer)AB, (int)ldab, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int pbtrs(Layout layout, UPLO uplo, int n, int kd, int nrhs, float[] AB, int ldab, float[] B, int ldb) {
        return openblas.LAPACKE_spbtrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (int)nrhs, (float[])AB, (int)ldab, (float[])B, (int)ldb);
    }

    @Override
    public int pbtrs(Layout layout, UPLO uplo, int n, int kd, int nrhs, FloatBuffer AB, int ldab, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_spbtrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (int)nrhs, (FloatBuffer)AB, (int)ldab, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int pptrs(Layout layout, UPLO uplo, int n, int nrhs, double[] AP, double[] B, int ldb) {
        return openblas.LAPACKE_dpptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])AP, (double[])B, (int)ldb);
    }

    @Override
    public int pptrs(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer AP, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dpptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)AP, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int pptrs(Layout layout, UPLO uplo, int n, int nrhs, float[] AP, float[] B, int ldb) {
        return openblas.LAPACKE_spptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])AP, (float[])B, (int)ldb);
    }

    @Override
    public int pptrs(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer AP, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_spptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)AP, (FloatBuffer)B, (int)ldb);
    }

    @Override
    public int geqrf(Layout layout, int m, int n, double[] A, int lda, double[] tau) {
        return openblas.LAPACKE_dgeqrf((int)layout.lapack(), (int)m, (int)n, (double[])A, (int)lda, (double[])tau);
    }

    @Override
    public int geqrf(Layout layout, int m, int n, DoubleBuffer A, int lda, DoubleBuffer tau) {
        return openblas.LAPACKE_dgeqrf((int)layout.lapack(), (int)m, (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)tau);
    }

    @Override
    public int geqrf(Layout layout, int m, int n, float[] A, int lda, float[] tau) {
        return openblas.LAPACKE_sgeqrf((int)layout.lapack(), (int)m, (int)n, (float[])A, (int)lda, (float[])tau);
    }

    @Override
    public int geqrf(Layout layout, int m, int n, FloatBuffer A, int lda, FloatBuffer tau) {
        return openblas.LAPACKE_sgeqrf((int)layout.lapack(), (int)m, (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)tau);
    }

    @Override
    public int orgqr(Layout layout, int m, int n, int k, double[] A, int lda, double[] tau) {
        return openblas.LAPACKE_dorgqr((int)layout.lapack(), (int)m, (int)n, (int)k, (double[])A, (int)lda, (double[])tau);
    }

    @Override
    public int orgqr(Layout layout, int m, int n, int k, DoubleBuffer A, int lda, DoubleBuffer tau) {
        return openblas.LAPACKE_dorgqr((int)layout.lapack(), (int)m, (int)n, (int)k, (DoubleBuffer)A, (int)lda, (DoubleBuffer)tau);
    }

    @Override
    public int orgrq(Layout layout, int m, int n, int k, double[] A, int lda, double[] tau) {
        return openblas.LAPACKE_dorgrq((int)layout.lapack(), (int)m, (int)n, (int)k, (double[])A, (int)lda, (double[])tau);
    }

    @Override
    public int orgrq(Layout layout, int m, int n, int k, DoubleBuffer A, int lda, DoubleBuffer tau) {
        return openblas.LAPACKE_dorgrq((int)layout.lapack(), (int)m, (int)n, (int)k, (DoubleBuffer)A, (int)lda, (DoubleBuffer)tau);
    }

    @Override
    public int ormqr(Layout layout, Side side, Transpose trans, int m, int n, int k, double[] A, int lda, double[] tau, double[] C, int ldc) {
        return openblas.LAPACKE_dormqr((int)layout.lapack(), (byte)side.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)k, (double[])A, (int)lda, (double[])tau, (double[])C, (int)ldc);
    }

    @Override
    public int ormqr(Layout layout, Side side, Transpose trans, int m, int n, int k, DoubleBuffer A, int lda, DoubleBuffer tau, DoubleBuffer C, int ldc) {
        return openblas.LAPACKE_dormqr((int)layout.lapack(), (byte)side.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)k, (DoubleBuffer)A, (int)lda, (DoubleBuffer)tau, (DoubleBuffer)C, (int)ldc);
    }

    @Override
    public int ormqr(Layout layout, Side side, Transpose trans, int m, int n, int k, float[] A, int lda, float[] tau, float[] C, int ldc) {
        return openblas.LAPACKE_sormqr((int)layout.lapack(), (byte)side.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)k, (float[])A, (int)lda, (float[])tau, (float[])C, (int)ldc);
    }

    @Override
    public int ormqr(Layout layout, Side side, Transpose trans, int m, int n, int k, FloatBuffer A, int lda, FloatBuffer tau, FloatBuffer C, int ldc) {
        return openblas.LAPACKE_sormqr((int)layout.lapack(), (byte)side.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)k, (FloatBuffer)A, (int)lda, (FloatBuffer)tau, (FloatBuffer)C, (int)ldc);
    }

    @Override
    public int trtrs(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, int nrhs, double[] A, int lda, double[] B, int ldb) {
        return openblas.LAPACKE_dtrtrs((int)layout.lapack(), (byte)uplo.lapack(), (byte)trans.lapack(), (byte)diag.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb);
    }

    @Override
    public int trtrs(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb) {
        return openblas.LAPACKE_dtrtrs((int)layout.lapack(), (byte)uplo.lapack(), (byte)trans.lapack(), (byte)diag.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb);
    }

    @Override
    public int trtrs(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, int nrhs, float[] A, int lda, float[] B, int ldb) {
        return openblas.LAPACKE_strtrs((int)layout.lapack(), (byte)uplo.lapack(), (byte)trans.lapack(), (byte)diag.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb);
    }

    @Override
    public int trtrs(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb) {
        return openblas.LAPACKE_strtrs((int)layout.lapack(), (byte)uplo.lapack(), (byte)trans.lapack(), (byte)diag.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb);
    }
}

