/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.common;

import org.meteoinfo.common.Extent;

public class Extent3D
extends Extent {
    public double minZ;
    public double maxZ;

    public Extent3D() {
    }

    public Extent3D(double xMin, double xMax, double yMin, double yMax, double zMin, double zMax) {
        super(xMin, xMax, yMin, yMax);
        this.minZ = zMin;
        this.maxZ = zMax;
    }

    public double getZLength() {
        return this.maxZ - this.minZ;
    }

    public double[] getCenter() {
        return new double[]{(this.maxX + this.minX) / 2.0, (this.maxY + this.minY) / 2.0, (this.maxZ + this.minZ) / 2.0};
    }

    @Override
    public boolean is3D() {
        return true;
    }

    @Override
    public boolean intersects(Extent extent) {
        if (extent instanceof Extent3D) {
            Extent3D bET = (Extent3D)extent;
            return !(this.maxX < bET.minX || this.maxY < bET.minY || this.maxZ < bET.minZ || bET.maxX < this.minX || bET.maxY < this.minY || bET.maxZ < this.minZ);
        }
        return super.intersects(extent);
    }

    public Extent3D union(Extent3D ex) {
        Extent3D cET = new Extent3D();
        if (this.isNaN()) {
            return (Extent3D)ex.clone();
        }
        if (ex.isNaN()) {
            return (Extent3D)this.clone();
        }
        cET.minX = Math.min(this.minX, ex.minX);
        cET.minY = Math.min(this.minY, ex.minY);
        cET.maxX = Math.max(this.maxX, ex.maxX);
        cET.maxY = Math.max(this.maxY, ex.maxY);
        cET.minZ = Math.min(this.minZ, ex.minZ);
        cET.maxZ = Math.max(this.maxZ, ex.maxZ);
        return cET;
    }

    public Extent3D shift(double dx, double dy, double dz) {
        return new Extent3D(this.minX + dx, this.maxX + dx, this.minY + dy, this.maxY + dy, this.minZ + dz, this.maxZ + dz);
    }

    @Override
    public Extent3D extend(double ratio) {
        double dx = this.getWidth() * ratio;
        double dy = this.getHeight() * ratio;
        double dz = (this.maxZ - this.minZ) * ratio;
        return this.extend(dx, dy, dz);
    }

    public Extent3D extend(double dx, double dy, double dz) {
        return new Extent3D(this.minX - dx, this.maxX + dx, this.minY - dy, this.maxY + dy, this.minZ - dz, this.maxZ + dz);
    }

    @Override
    public void asNonZero() {
        double width = this.getWidth();
        double height = this.getHeight();
        double zLength = this.getZLength();
        double v = Math.max(width, height);
        v = Math.max(v, zLength);
        v /= 2.0;
        if (width == 0.0) {
            this.minX -= v;
            this.maxX += v;
        }
        if (height == 0.0) {
            this.minY -= v;
            this.maxY += v;
        }
        if (zLength == 0.0) {
            this.minZ -= v;
            this.maxZ += v;
        }
    }

    @Override
    public Object clone() {
        return new Extent3D(this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
    }
}

