/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl.tessellator;

import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import com.jogamp.opengl.glu.GLUtessellatorCallbackAdapter;
import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.chart.jogl.tessellator.Primitive;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolygonZ;

public class PrimitiveTessellator {
    private final GLU glu = new GLU();
    private final GLUtessellator tobj;
    private final TessellationCallback tessCallback;
    private TesselationException err;
    private boolean done;
    private TessellatorListener listener;

    public PrimitiveTessellator() {
        PrimitiveTessellator primitiveTessellator = this;
        this.tobj = primitiveTessellator.glu.gluNewTess();
        this.tessCallback = new TessellationCallback();
        this.done = false;
    }

    public List<Primitive> getPrimitives(PolygonZ polygon) throws TesselationException {
        this.makePrimitives(polygon);
        try {
            while (!this.done) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.err == null) {
            return this.tessCallback.primitives;
        }
        throw this.err;
    }

    public void getPrimitives(PolygonZ polygon, TessellatorListener listener) {
        this.listener = listener;
        this.makePrimitives(polygon);
    }

    private void makePrimitives(PolygonZ polygon) {
        double[] v;
        PointZ p;
        int i;
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100100, (GLUtessellatorCallback)this.tessCallback);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100101, (GLUtessellatorCallback)this.tessCallback);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100102, (GLUtessellatorCallback)this.tessCallback);
        GLU.gluTessCallback((GLUtessellator)this.tobj, (int)100103, (GLUtessellatorCallback)this.tessCallback);
        GLU.gluTessBeginPolygon((GLUtessellator)this.tobj, null);
        GLU.gluTessBeginContour((GLUtessellator)this.tobj);
        for (i = 0; i < polygon.getOutLine().size() - 1; ++i) {
            p = (PointZ)polygon.getOutLine().get(i);
            v = p.toArray();
            GLU.gluTessVertex((GLUtessellator)this.tobj, (double[])v, (int)0, (Object)v);
        }
        GLU.gluTessEndContour((GLUtessellator)this.tobj);
        if (polygon.hasHole()) {
            for (i = 0; i < polygon.getHoleLineNumber(); ++i) {
                GLU.gluTessBeginContour((GLUtessellator)this.tobj);
                for (int j = 0; j < polygon.getHoleLine(i).size() - 1; ++j) {
                    p = (PointZ)polygon.getHoleLine(i).get(j);
                    v = p.toArray();
                    GLU.gluTessVertex((GLUtessellator)this.tobj, (double[])v, (int)0, (Object)v);
                }
                GLU.gluTessEndContour((GLUtessellator)this.tobj);
            }
        }
        GLU.gluTessEndPolygon((GLUtessellator)this.tobj);
        GLU.gluDeleteTess((GLUtessellator)this.tobj);
    }

    protected void sendSuccess() {
        this.done = true;
        this.err = null;
        if (this.listener != null) {
            this.listener.onTesselationDone(this.tessCallback.primitives);
        }
    }

    protected void sendError(String message) {
        this.done = true;
        this.err = new TesselationException(message);
        if (this.listener != null) {
            this.listener.onTesselationError(this.err);
        }
    }

    class TessellationCallback
    extends GLUtessellatorCallbackAdapter {
        protected List<Primitive> primitives = new ArrayList<Primitive>();
        private PointZ p1;
        private PointZ p2;
        private PointZ p3;
        private int geometricPrimitiveType;

        TessellationCallback() {
        }

        public void begin(int type) {
            this.primitives.add(new Primitive(type));
        }

        public void end() {
            PrimitiveTessellator.this.sendSuccess();
        }

        public void vertex(Object vertexData) {
            PointZ coords = new PointZ((double[])vertexData);
            this.getLastPrimitive().vertices.add(coords);
        }

        public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
            PrimitiveTessellator.this.sendError("Self-intersecting polygons not supported");
        }

        public void error(int errnum) {
            PrimitiveTessellator.this.sendError("Opengl error: " + PrimitiveTessellator.this.glu.gluErrorString(errnum));
        }

        private Primitive getLastPrimitive() {
            return this.primitives.get(this.primitives.size() - 1);
        }
    }

    public class TesselationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TesselationException(String message) {
            super(message);
        }
    }

    public static interface TessellatorListener {
        public void onTesselationDone(List<Primitive> var1);

        public void onTesselationError(TesselationException var1);
    }
}

