/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import org.meteoinfo.ndarray.io.npy.NpyFormatException;
import org.meteoinfo.ndarray.io.npy.NpyUtil;
import org.meteoinfo.ndarray.io.npy.NpyVersion;
import org.meteoinfo.ndarray.io.npy.dict.NpyHeaderDict;

public final class NpyHeader {
    private final long dataOffset;
    private final NpyHeaderDict dict;

    private NpyHeader(long dataOffset, NpyHeaderDict dict) {
        this.dataOffset = dataOffset;
        this.dict = Objects.requireNonNull(dict);
    }

    public String toString() {
        return this.dict.toString();
    }

    public NpyHeaderDict dict() {
        return this.dict;
    }

    public long dataOffset() {
        return this.dataOffset;
    }

    public ByteOrder byteOrder() {
        return this.dict.byteOrder() == null ? ByteOrder.nativeOrder() : this.dict.byteOrder().toJava();
    }

    public static NpyHeader read(InputStream in) throws IOException, NpyFormatException {
        long dataOffset;
        int headerLength;
        byte[] bytes = new byte[8];
        int n = in.read(bytes);
        if (n != 8) {
            throw new NpyFormatException("invalid NPY header");
        }
        NpyVersion version = NpyVersion.of(bytes);
        if (version.major == 1) {
            bytes = new byte[2];
            n = in.read(bytes);
            if (n != 2) {
                throw new NpyFormatException("invalid NPY header");
            }
            headerLength = NpyUtil.u2ToInt(bytes, ByteOrder.LITTLE_ENDIAN);
            dataOffset = 10 + headerLength;
        } else {
            bytes = new byte[4];
            n = in.read(bytes);
            if (n != 4) {
                throw new NpyFormatException("invalid NPY header");
            }
            long len = NpyUtil.u4ToLong(bytes, ByteOrder.LITTLE_ENDIAN);
            dataOffset = 12L + len;
            headerLength = (int)len;
        }
        bytes = new byte[headerLength];
        if (in.read(bytes) != headerLength) {
            throw new NpyFormatException("invalid NPY file");
        }
        String header = new String(bytes, version.headerEncoding());
        return new NpyHeader(dataOffset, NpyHeaderDict.parse(header));
    }

    public static NpyHeader read(ReadableByteChannel channel) throws IOException {
        long dataOffset;
        int headerLength;
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        if (channel.read(buffer) < 8) {
            throw new NpyFormatException("invalid NPY header");
        }
        buffer.flip();
        NpyVersion version = NpyVersion.of(buffer.array());
        buffer.position(0);
        if (version.major == 1) {
            buffer.limit(2);
            if (channel.read(buffer) != 2) {
                throw new NpyFormatException("invalid NPY header");
            }
            buffer.flip();
            headerLength = NpyUtil.u2ToInt(buffer);
            dataOffset = 10 + headerLength;
        } else {
            buffer.limit(4);
            if (channel.read(buffer) != 4) {
                throw new NpyFormatException("invalid NPY header");
            }
            long len = NpyUtil.u4ToLong(buffer);
            dataOffset = 12L + len;
            headerLength = (int)len;
        }
        buffer = ByteBuffer.allocate(headerLength);
        if (channel.read(buffer) != headerLength) {
            throw new NpyFormatException("invalid NPY file");
        }
        String header = new String(buffer.array(), version.headerEncoding());
        return new NpyHeader(dataOffset, NpyHeaderDict.parse(header));
    }
}

