/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import us.hebi.matlab.mat.format.Compat;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.types.AbstractArray;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Opaque;
import us.hebi.matlab.mat.types.Sink;

class MatOpaque
extends AbstractArray
implements Opaque,
Mat5Serializable {
    private final String objectType;
    private final String className;
    private final Array content;
    private static final int[] SINGLE_DIM = new int[]{1, 1};

    MatOpaque(String objectType, String className, Array content) {
        super(SINGLE_DIM);
        this.content = content;
        this.className = className;
        this.objectType = objectType;
    }

    @Override
    public MatlabType getType() {
        return MatlabType.Opaque;
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Array getContent() {
        return this.content;
    }

    @Override
    public int getMat5Size(String name) {
        return Mat5WriteUtil.computeOpaqueSize(name, this);
    }

    @Override
    public void writeMat5(String name, boolean isGlobal, Sink sink) throws IOException {
        Mat5WriteUtil.writeOpaque(name, isGlobal, this, sink);
    }

    @Override
    public void close() throws IOException {
        this.content.close();
    }

    @Override
    protected int subHashCode() {
        return Compat.hash(this.objectType, this.className, this.content);
    }

    @Override
    protected boolean subEqualsGuaranteedSameClass(Object otherGuaranteedSameClass) {
        MatOpaque other = (MatOpaque)otherGuaranteedSameClass;
        return other.objectType.equals(this.objectType) && other.className.equals(this.className) && other.content.equals(this.content);
    }
}

