/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.keyvalue;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.PrimitiveNumber;
import org.ojalgo.type.keyvalue.EntryList;
import org.ojalgo.type.keyvalue.EntryPair;

public abstract class EntrySet<K, V>
extends AbstractList<Map.Entry<K, V>>
implements EntryList<K, V>,
Set<Map.Entry<K, V>> {
    private final K[] myKeys;

    EntrySet(K[] keys) {
        this.myKeys = keys;
    }

    @Override
    public abstract EntryPair<K, V> get(int var1);

    @Override
    public final K getKey(int index) {
        return this.myKeys[index];
    }

    @Override
    public final EntryPair<K, V> getPair(int index) {
        return this.get(index);
    }

    @Override
    public abstract V getValue(int var1);

    @Override
    public final Iterator<Map.Entry<K, V>> iterator() {
        return new ViewingIterator(this);
    }

    public abstract void setValue(int var1, V var2);

    @Override
    public final int size() {
        return this.myKeys.length;
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return super.spliterator();
    }

    static final class ViewingIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final int myLastIndex;
        private final EntryView<K, V> myView;

        ViewingIterator(EntrySet<K, V> set) {
            this.myView = new EntryView<K, V>(set);
            this.myView.index = -1;
            this.myLastIndex = set.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.myView.index < this.myLastIndex;
        }

        @Override
        public Map.Entry<K, V> next() {
            ++this.myView.index;
            return this.myView;
        }
    }

    static final class ObjectShort<K>
    extends KeyedPrimitives<K> {
        private final short[] myValues;

        ObjectShort(K[] keys, short[] values) {
            super(keys);
            this.myValues = values;
        }

        public void add(long index, Comparable<?> addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = (short)(this.myValues[n] + NumberDefinition.shortValue(addend));
        }

        public void add(long index, double addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = (short)(this.myValues[n] + (short)addend);
        }

        public void add(long index, float addend) {
            int intIndex = Math.toIntExact(index);
            this.myValues[intIndex] = (short)((float)this.myValues[intIndex] + addend);
        }

        @Override
        public double doubleValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public float floatValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public EntryPair<K, PrimitiveNumber> get(int index) {
            return EntryPair.of(this.getKey(index), this.myValues[index]);
        }

        @Override
        public PrimitiveNumber getValue(int index) {
            return PrimitiveNumber.of(this.myValues[index]);
        }

        @Override
        public int intValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public long longValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public void set(long index, Comparable<?> value) {
            this.myValues[Math.toIntExact((long)index)] = NumberDefinition.shortValue(value);
        }

        @Override
        public void set(long index, double value) {
            this.myValues[Math.toIntExact((long)index)] = (short)value;
        }

        @Override
        public void set(long index, float value) {
            this.myValues[Math.toIntExact((long)index)] = (short)value;
        }

        @Override
        public void setValue(int index, PrimitiveNumber value) {
            this.myValues[index] = value.shortValue();
        }

        @Override
        public short shortValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }
    }

    static final class ObjectObject<K, V>
    extends EntrySet<K, V> {
        private final V[] myValues;

        ObjectObject(K[] keys, V[] values) {
            super(keys);
            this.myValues = values;
        }

        @Override
        public EntryPair<K, V> get(int index) {
            return EntryPair.of(this.getKey(index), this.myValues[index]);
        }

        @Override
        public V getValue(int index) {
            return this.myValues[index];
        }

        @Override
        public void setValue(int index, V value) {
            this.myValues[index] = value;
        }
    }

    static final class ObjectLong<K>
    extends KeyedPrimitives<K> {
        private final long[] myValues;

        ObjectLong(K[] keys, long[] values) {
            super(keys);
            this.myValues = values;
        }

        public void add(long index, Comparable<?> addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = this.myValues[n] + NumberDefinition.longValue(addend);
        }

        public void add(long index, double addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = this.myValues[n] + (long)addend;
        }

        public void add(long index, float addend) {
            int intIndex = Math.toIntExact(index);
            this.myValues[intIndex] = (long)((float)this.myValues[intIndex] + addend);
        }

        @Override
        public double doubleValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public float floatValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public EntryPair<K, PrimitiveNumber> get(int index) {
            return EntryPair.of(this.getKey(index), this.myValues[index]);
        }

        @Override
        public PrimitiveNumber getValue(int index) {
            return PrimitiveNumber.of(this.myValues[index]);
        }

        @Override
        public long longValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public void set(long index, Comparable<?> value) {
            this.myValues[Math.toIntExact((long)index)] = NumberDefinition.longValue(value);
        }

        @Override
        public void set(long index, double value) {
            this.myValues[Math.toIntExact((long)index)] = (long)value;
        }

        @Override
        public void set(long index, float value) {
            this.myValues[Math.toIntExact((long)index)] = (long)value;
        }

        @Override
        public void setValue(int index, PrimitiveNumber value) {
            this.myValues[index] = value.longValue();
        }
    }

    static final class ObjectInt<K>
    extends KeyedPrimitives<K> {
        private final int[] myValues;

        ObjectInt(K[] keys, int[] values) {
            super(keys);
            this.myValues = values;
        }

        public void add(long index, Comparable<?> addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = this.myValues[n] + NumberDefinition.intValue(addend);
        }

        public void add(long index, double addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = this.myValues[n] + (int)addend;
        }

        public void add(long index, float addend) {
            int intIndex = Math.toIntExact(index);
            this.myValues[intIndex] = (int)((float)this.myValues[intIndex] + addend);
        }

        @Override
        public double doubleValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public float floatValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public EntryPair<K, PrimitiveNumber> get(int index) {
            return EntryPair.of(this.getKey(index), this.myValues[index]);
        }

        @Override
        public PrimitiveNumber getValue(int index) {
            return PrimitiveNumber.of(this.myValues[index]);
        }

        @Override
        public int intValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public long longValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public void set(long index, Comparable<?> value) {
            this.myValues[Math.toIntExact((long)index)] = NumberDefinition.intValue(value);
        }

        @Override
        public void set(long index, double value) {
            this.myValues[Math.toIntExact((long)index)] = (int)value;
        }

        @Override
        public void set(long index, float value) {
            this.myValues[Math.toIntExact((long)index)] = (int)value;
        }

        @Override
        public void setValue(int index, PrimitiveNumber value) {
            this.myValues[index] = value.intValue();
        }
    }

    static final class ObjectFloat<K>
    extends KeyedPrimitives<K> {
        private final float[] myValues;

        ObjectFloat(K[] keys, float[] values) {
            super(keys);
            this.myValues = values;
        }

        public void add(long index, Comparable<?> addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = this.myValues[n] + NumberDefinition.floatValue(addend);
        }

        public void add(long index, double addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = this.myValues[n] + (float)addend;
        }

        public void add(long index, float addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = this.myValues[n] + addend;
        }

        @Override
        public double doubleValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public float floatValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public EntryPair<K, PrimitiveNumber> get(int index) {
            return EntryPair.of(this.getKey(index), this.myValues[index]);
        }

        @Override
        public PrimitiveNumber getValue(int index) {
            return PrimitiveNumber.of(this.myValues[index]);
        }

        @Override
        public void set(long index, Comparable<?> value) {
            this.myValues[Math.toIntExact((long)index)] = NumberDefinition.floatValue(value);
        }

        @Override
        public void set(long index, double value) {
            this.myValues[Math.toIntExact((long)index)] = (float)value;
        }

        @Override
        public void set(long index, float value) {
            this.myValues[Math.toIntExact((long)index)] = value;
        }

        @Override
        public void setValue(int index, PrimitiveNumber value) {
            this.myValues[index] = value.floatValue();
        }
    }

    static final class ObjectDouble<K>
    extends KeyedPrimitives<K> {
        private final double[] myValues;

        ObjectDouble(K[] keys, double[] values) {
            super(keys);
            this.myValues = values;
        }

        public void add(long index, Comparable<?> addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = this.myValues[n] + NumberDefinition.doubleValue(addend);
        }

        public void add(long index, double addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = this.myValues[n] + addend;
        }

        public void add(long index, float addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = this.myValues[n] + (double)addend;
        }

        @Override
        public double doubleValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public EntryPair<K, PrimitiveNumber> get(int index) {
            return EntryPair.of(this.getKey(index), this.myValues[index]);
        }

        @Override
        public PrimitiveNumber getValue(int index) {
            return PrimitiveNumber.of(this.myValues[index]);
        }

        @Override
        public void set(long index, Comparable<?> value) {
            this.myValues[Math.toIntExact((long)index)] = NumberDefinition.doubleValue(value);
        }

        @Override
        public void set(long index, double value) {
            this.myValues[Math.toIntExact((long)index)] = value;
        }

        @Override
        public void set(long index, float value) {
            this.myValues[Math.toIntExact((long)index)] = value;
        }

        @Override
        public void setValue(int index, PrimitiveNumber value) {
            this.myValues[index] = value.doubleValue();
        }
    }

    static final class ObjectByte<K>
    extends KeyedPrimitives<K> {
        private final byte[] myValues;

        ObjectByte(K[] keys, byte[] values) {
            super(keys);
            this.myValues = values;
        }

        public void add(long index, Comparable<?> addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = (byte)(this.myValues[n] + NumberDefinition.byteValue(addend));
        }

        public void add(long index, double addend) {
            int n = Math.toIntExact(index);
            this.myValues[n] = (byte)(this.myValues[n] + (byte)addend);
        }

        public void add(long index, float addend) {
            int intIndex = Math.toIntExact(index);
            this.myValues[intIndex] = (byte)((float)this.myValues[intIndex] + addend);
        }

        @Override
        public byte byteValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public double doubleValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public float floatValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public EntryPair<K, PrimitiveNumber> get(int index) {
            return EntryPair.of(this.getKey(index), this.myValues[index]);
        }

        @Override
        public PrimitiveNumber getValue(int index) {
            return PrimitiveNumber.of(this.myValues[index]);
        }

        @Override
        public int intValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public long longValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }

        @Override
        public void set(long index, Comparable<?> value) {
            this.myValues[Math.toIntExact((long)index)] = NumberDefinition.byteValue(value);
        }

        @Override
        public void set(long index, double value) {
            this.myValues[Math.toIntExact((long)index)] = (byte)value;
        }

        @Override
        public void set(long index, float value) {
            this.myValues[Math.toIntExact((long)index)] = (byte)value;
        }

        @Override
        public void setValue(int index, PrimitiveNumber value) {
            this.myValues[index] = value.byteValue();
        }

        @Override
        public short shortValue(long index) {
            return this.myValues[Math.toIntExact(index)];
        }
    }

    static abstract class KeyedPrimitives<K>
    extends EntrySet<K, PrimitiveNumber>
    implements Access1D<PrimitiveNumber>,
    Mutate1D {
        KeyedPrimitives(K[] keys) {
            super(keys);
        }

        @Override
        public final long count() {
            return this.size();
        }

        @Override
        public final PrimitiveNumber get(long index) {
            return (PrimitiveNumber)this.getValue(Math.toIntExact(index));
        }
    }

    static final class EntryView<K, V>
    implements Map.Entry<K, V> {
        private final EntrySet<K, V> mySet;
        int index = 0;

        EntryView(EntrySet<K, V> set) {
            this.mySet = set;
        }

        @Override
        public K getKey() {
            return this.mySet.getKey(this.index);
        }

        @Override
        public V getValue() {
            return this.mySet.getValue(this.index);
        }

        @Override
        public V setValue(V value) {
            V old = this.mySet.getValue(this.index);
            this.mySet.setValue(this.index, value);
            return old;
        }
    }
}

