/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.graphic;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.ColorBreakCollection;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.IndexIterator;

public class Line2DGraphic
extends Graphic {
    private Array xData;
    private Array yData;
    private Array cData;
    private boolean curve = false;
    private LegendScheme legendScheme;

    public Line2DGraphic(PolylineShape polylineShape, PolylineBreak polylineBreak) {
        this.shape = polylineShape;
        this.legend = polylineBreak;
    }

    public Line2DGraphic(Array xData, Array yData, PolylineBreak polylineBreak) {
        this.xData = xData;
        this.yData = yData;
        this.updateShape();
        if (polylineBreak == null) {
            polylineBreak = new PolylineBreak();
        }
        this.legend = polylineBreak;
    }

    public Line2DGraphic(Array xData, Array yData) {
        this(xData, yData, new PolylineBreak());
    }

    public Line2DGraphic(Array xData, Array yData, Array cData, LegendScheme legendScheme) {
        this.xData = xData;
        this.yData = yData;
        this.cData = cData;
        this.updateShapeLegend(legendScheme);
    }

    protected void updateShape() {
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = this.xData.getIndexIterator();
        IndexIterator yIter = this.yData.getIndexIterator();
        while (xIter.hasNext() && yIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            points.add(new PointD(x, y));
        }
        if (this.shape == null) {
            this.shape = new PolylineShape();
        }
        this.shape.setPoints(points);
    }

    protected void updateShapeLegend(LegendScheme legendScheme) {
        this.legendScheme = legendScheme;
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = this.xData.getIndexIterator();
        IndexIterator yIter = this.yData.getIndexIterator();
        IndexIterator cIter = this.cData.getIndexIterator();
        ColorBreakCollection cbc = new ColorBreakCollection();
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            double c = cIter.getDoubleNext();
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            points.add(new PointD(x, y));
            ColorBreak cb = legendScheme.findLegendBreakAlways(c);
            cbc.add(cb);
        }
        if (this.shape == null) {
            this.shape = new PolylineShape();
        }
        if (points.size() >= 2) {
            this.shape.setPoints(points);
        }
        this.legend = cbc;
    }

    protected void updateShapeLegend(List<ColorBreak> cbs) {
        this.legendScheme = new LegendScheme(cbs);
        ArrayList<PointD> points = new ArrayList<PointD>();
        IndexIterator xIter = this.xData.getIndexIterator();
        IndexIterator yIter = this.yData.getIndexIterator();
        ColorBreakCollection cbc = new ColorBreakCollection();
        int i = 0;
        while (xIter.hasNext()) {
            double x = xIter.getDoubleNext();
            double y = yIter.getDoubleNext();
            ColorBreak cb = cbs.get(i);
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            points.add(new PointD(x, y));
            cbc.add(cb);
            ++i;
        }
        if (this.shape == null) {
            this.shape = new PolylineShape();
        }
        this.shape.setPoints(points);
        this.legend = cbc;
    }

    public boolean isCurve() {
        return this.curve;
    }

    public void setCurve(boolean value) {
        this.curve = value;
    }

    public Array getXData() {
        return this.xData;
    }

    public void setXData(Array xData) {
        this.xData = xData;
        this.updateShape();
    }

    public Array getYData() {
        return this.yData;
    }

    public void setYData(Array yData) {
        this.yData = yData;
        this.updateShape();
    }

    public Array getColorData() {
        return this.cData;
    }

    public void setData(Array xData, Array yData) {
        this.xData = xData;
        this.yData = yData;
        this.updateShape();
    }

    public LegendScheme getLegendScheme() {
        return this.legendScheme;
    }
}

