/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.quaternion;

import java.util.function.DoubleFunction;
import org.apache.commons.numbers.quaternion.Quaternion;

public class Slerp
implements DoubleFunction<Quaternion> {
    private static final double MAX_DOT_THRESHOLD = 0.9995;
    private final Quaternion start;
    private final Quaternion end;
    private final DoubleFunction<Quaternion> algo;

    public Slerp(Quaternion start, Quaternion end) {
        this.start = start.positivePolarForm();
        Quaternion e = end.positivePolarForm();
        double dot = this.start.dot(e);
        if (dot < 0.0) {
            dot = -dot;
            this.end = e.negate();
        } else {
            this.end = e;
        }
        this.algo = dot > 0.9995 ? new Linear() : new Spherical(dot);
    }

    @Override
    public Quaternion apply(double t) {
        if (t == 0.0) {
            return this.start;
        }
        if (t == 1.0) {
            return this.end.positivePolarForm();
        }
        return this.algo.apply(t);
    }

    private class Spherical
    implements DoubleFunction<Quaternion> {
        private final double theta;
        private final double sinTheta;

        Spherical(double dot) {
            this.theta = Math.acos(dot);
            this.sinTheta = Math.sin(this.theta);
        }

        @Override
        public Quaternion apply(double t) {
            double f1 = Math.sin((1.0 - t) * this.theta) / this.sinTheta;
            double f2 = Math.sin(t * this.theta) / this.sinTheta;
            return Quaternion.of(f1 * Slerp.this.start.getW() + f2 * Slerp.this.end.getW(), f1 * Slerp.this.start.getX() + f2 * Slerp.this.end.getX(), f1 * Slerp.this.start.getY() + f2 * Slerp.this.end.getY(), f1 * Slerp.this.start.getZ() + f2 * Slerp.this.end.getZ()).positivePolarForm();
        }
    }

    private class Linear
    implements DoubleFunction<Quaternion> {
        private Linear() {
        }

        @Override
        public Quaternion apply(double t) {
            double f = 1.0 - t;
            return Quaternion.of(f * Slerp.this.start.getW() + t * Slerp.this.end.getW(), f * Slerp.this.start.getX() + t * Slerp.this.end.getX(), f * Slerp.this.start.getY() + t * Slerp.this.end.getY(), f * Slerp.this.start.getZ() + t * Slerp.this.end.getZ()).positivePolarForm();
        }
    }
}

