/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.WindowMenu;
import com.cburch.logisim.util.WindowMenuItemManager;
import java.util.ArrayList;
import java.util.List;

public final class WindowMenuManager {
    private static final ArrayList<WindowMenu> menus = new ArrayList();
    private static final ArrayList<WindowMenuItemManager> managers = new ArrayList();
    private static WindowMenuItemManager currentManager = null;

    private WindowMenuManager() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static void addManager(WindowMenuItemManager manager) {
        for (WindowMenu menu : menus) {
            manager.createMenuItem(menu);
        }
        managers.add(manager);
    }

    public static void addMenu(WindowMenu menu) {
        for (WindowMenuItemManager manager : managers) {
            manager.createMenuItem(menu);
        }
        menus.add(menu);
    }

    private static void enableAll() {
        for (WindowMenu menu : menus) {
            menu.computeEnabled();
        }
    }

    static WindowMenuItemManager getCurrentManager() {
        return currentManager;
    }

    static List<WindowMenu> getMenus() {
        return menus;
    }

    public static void removeManager(WindowMenuItemManager manager) {
        for (WindowMenu menu : menus) {
            manager.removeMenuItem(menu);
        }
        managers.remove(manager);
    }

    static void setCurrentManager(WindowMenuItemManager value) {
        boolean doEnable;
        if (value == currentManager) {
            return;
        }
        boolean bl = doEnable = currentManager == null != (value == null);
        if (currentManager == null) {
            WindowMenuManager.setNullItems(false);
        } else {
            currentManager.setSelected(false);
        }
        currentManager = value;
        if (currentManager == null) {
            WindowMenuManager.setNullItems(true);
        } else {
            currentManager.setSelected(true);
        }
        if (doEnable) {
            WindowMenuManager.enableAll();
        }
    }

    private static void setNullItems(boolean value) {
        for (WindowMenu menu : menus) {
            menu.setNullItemSelected(value);
        }
    }

    static void unsetCurrentManager(WindowMenuItemManager value) {
        if (value != currentManager) {
            return;
        }
        WindowMenuManager.setCurrentManager(null);
    }
}

