/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitorKeyStroke;
import com.cburch.logisim.util.IconsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class JHotkeyInput
extends JPanel {
    private static JFrame topFrame = null;
    private final JButton resetButton = new JButton();
    private final JButton applyButton = new JButton();
    private static final String os = System.getProperty("os.name").toLowerCase();
    private static final String lookAndFeel = UIManager.getLookAndFeel().getName();
    private int fieldVerticalBias;
    private int fieldHorizonalBias;
    public final JTextField hotkeyInputField;
    private transient PrefMonitorKeyStroke boundKeyStroke = null;
    private final transient HotkeyInputKeyListener hotkeyListener;
    private boolean focusableEnabled = false;
    private static int layoutOptimizedDelay = 4;
    private static boolean globalLayoutOptimized = false;
    private boolean needUpdate = false;
    private static boolean activeHotkeyInputUpdated = false;
    private static String activeHotkeyInputName = "";
    private String previousData;
    private static final List<JHotkeyInput> JHotkeyInputList = new ArrayList<JHotkeyInput>();
    private static final Timer optimizeTimer = new Timer(80, e -> {
        if (topFrame == null) {
            return;
        }
        for (JHotkeyInput com : JHotkeyInputList) {
            int height = com.getHeight();
            int width = com.getWidth();
            if (!globalLayoutOptimized && width > 0 && layoutOptimizedDelay-- > 0) {
                com.setPreferredSize(new Dimension(width + 18 + 18, height));
                globalLayoutOptimized = true;
                com.repaint();
                com.updateUI();
            }
            if (!com.focusableEnabled && globalLayoutOptimized) {
                Dimension preferredSize = com.hotkeyInputField.getPreferredSize();
                if (preferredSize.height + com.fieldVerticalBias >= com.getHeight()) {
                    com.setPreferredSize(new Dimension(width, preferredSize.height + com.fieldVerticalBias));
                }
                com.exitEditMode();
                com.hotkeyInputField.setFocusable(true);
                com.focusableEnabled = true;
            }
            if (!com.needUpdate || com.boundKeyStroke == null || !activeHotkeyInputUpdated || activeHotkeyInputName.equals(com.boundKeyStroke.getName())) continue;
            com.needUpdate = false;
            com.exitEditMode();
        }
    });

    public JHotkeyInput(JFrame frame, String text) {
        if (topFrame == null) {
            topFrame = frame;
        }
        this.hotkeyListener = new HotkeyInputKeyListener(this, this);
        this.hotkeyInputField = new JTextField(text.toUpperCase());
        this.previousData = text;
        this.setLayout(new FlowLayout(1, 0, 0));
        Insets insets = this.hotkeyInputField.getBorder().getBorderInsets(this.hotkeyInputField);
        this.fieldVerticalBias = insets.top + insets.bottom;
        this.fieldHorizonalBias = insets.left + insets.right;
        if (os.contains("linux") && !lookAndFeel.contains("Flat")) {
            this.fieldVerticalBias += 2;
        }
        this.setBorder(BorderFactory.createCompoundBorder(this.hotkeyInputField.getBorder(), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        this.setPreferredSize(new Dimension(170, 28));
        ((AbstractDocument)this.hotkeyInputField.getDocument()).setDocumentFilter(new KeyboardInputFilter(this));
        this.hotkeyInputField.setHorizontalAlignment(0);
        if (lookAndFeel.contains("Nimbus")) {
            this.hotkeyInputField.setBackground(new Color(0, 0, 0, 0));
        } else {
            this.hotkeyInputField.setBackground(topFrame.getBackground());
        }
        this.hotkeyInputField.setBorder(BorderFactory.createEmptyBorder());
        this.hotkeyInputField.addKeyListener(this.hotkeyListener);
        this.hotkeyInputField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JHotkeyInput.this.enterEditMode();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JHotkeyInput.this.needUpdate = true;
            }
        });
        ImageIcon iconOK = IconsUtil.getIcon("ok.gif");
        ImageIcon iconCancel = IconsUtil.getIcon("cancel.gif");
        this.applyButton.setIcon(iconOK);
        this.resetButton.setIcon(iconCancel);
        this.applyButton.setBorder(BorderFactory.createEmptyBorder());
        this.applyButton.setVisible(false);
        this.resetButton.setBorder(BorderFactory.createEmptyBorder());
        this.resetButton.setVisible(false);
        this.resetButton.addActionListener(e -> this.exitEditMode());
        this.applyButton.addActionListener(e -> this.applyChanges());
        Font font = this.resetButton.getFont();
        this.applyButton.setFont(new Font(font.getFontName(), 0, 8));
        this.applyButton.setPreferredSize(new Dimension(18, 18));
        this.resetButton.setFont(new Font(font.getFontName(), 0, 8));
        this.resetButton.setPreferredSize(new Dimension(18, 18));
        this.hotkeyInputField.setFocusable(false);
        this.add(this.hotkeyInputField);
        this.add(this.applyButton);
        this.add(this.resetButton);
        if (!optimizeTimer.isRunning()) {
            optimizeTimer.start();
        }
    }

    private void enterEditMode() {
        activeHotkeyInputName = this.boundKeyStroke.getName();
        activeHotkeyInputUpdated = true;
        if (this.hotkeyListener.rewritable()) {
            this.previousData = this.hotkeyInputField.getText();
        }
        this.hotkeyListener.clearStatus();
        this.hotkeyInputField.setText("");
        this.resetButton.setVisible(true);
        this.applyButton.setVisible(true);
        int height = this.hotkeyInputField.getHeight();
        int width = this.getWidth() - 18 - 18 - 8 - 8 - 6 - this.fieldHorizonalBias;
        this.hotkeyInputField.setPreferredSize(new Dimension(width, height));
        this.applyButton.setEnabled(false);
    }

    public void exitEditModeWithoutRefresh() {
        activeHotkeyInputUpdated = false;
        this.applyButton.setVisible(false);
        this.resetButton.setVisible(false);
        this.hotkeyInputField.setText(this.previousData);
    }

    public void exitEditMode() {
        this.exitEditModeWithoutRefresh();
        int height = this.hotkeyInputField.getHeight();
        int width = this.getWidth() - 12;
        this.hotkeyInputField.setPreferredSize(new Dimension(width, height));
        this.repaint();
        this.updateUI();
        topFrame.requestFocus();
    }

    private void applyChanges() {
        if (this.hotkeyListener.code != 0) {
            this.boundKeyStroke.set(KeyStroke.getKeyStroke(this.hotkeyListener.code, this.hotkeyListener.modifier));
            this.previousData = this.hotkeyListener.getHotkeyString();
            try {
                AppPreferences.getPrefs().flush();
                AppPreferences.hotkeySync();
            }
            catch (BackingStoreException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.applyButton.setVisible(false);
        this.resetButton.setVisible(false);
        int height = this.hotkeyInputField.getHeight();
        int width = this.getWidth() - 12;
        this.hotkeyInputField.setPreferredSize(new Dimension(width, height));
        this.repaint();
        this.updateUI();
        topFrame.requestFocus();
    }

    public void setText(String s) {
        this.hotkeyInputField.setText(s.toUpperCase());
    }

    public void resetText(String s) {
        this.hotkeyInputField.setText(s.toUpperCase());
        this.previousData = s.toUpperCase();
    }

    public void setBoundKeyStroke(PrefMonitorKeyStroke keyStroke) {
        this.boundKeyStroke = keyStroke;
        JHotkeyInputList.add(this);
    }

    public PrefMonitorKeyStroke getBoundKeyStroke() {
        return this.boundKeyStroke;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.hotkeyInputField.setEnabled(enabled);
    }

    public void setApplyEnabled(boolean enabled) {
        this.applyButton.setEnabled(enabled);
    }

    private class HotkeyInputKeyListener
    implements KeyListener {
        private final JHotkeyInput hotkeyInput;
        private int modifier = 0;
        private int code = 0;
        private boolean rewriteFlag = true;
        private String hotkeyString = "";

        public HotkeyInputKeyListener(JHotkeyInput jHotkeyInput, JHotkeyInput hotkeyInput) {
            this.hotkeyInput = hotkeyInput;
        }

        public void clearStatus() {
            this.code = 0;
            this.modifier = 0;
            this.hotkeyString = "";
            this.rewriteFlag = false;
        }

        public boolean rewritable() {
            return this.rewriteFlag;
        }

        public String getHotkeyString() {
            return this.hotkeyString;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.modifier = e.getModifiersEx();
            this.code = e.getKeyCode();
            if (this.code == 0 || this.code == 17 || this.code == 18 || this.code == 16 || this.code == 157) {
                this.clearStatus();
                return;
            }
            String modifierString = InputEvent.getModifiersExText(this.modifier);
            this.hotkeyString = modifierString.isEmpty() ? KeyEvent.getKeyText(this.code) : InputEvent.getModifiersExText(this.modifier) + "+" + KeyEvent.getKeyText(this.code);
            if (!this.hotkeyInput.getBoundKeyStroke().metaCheckPass(this.modifier)) {
                JOptionPane.showMessageDialog(null, Strings.S.get("hotkeyErrMeta", InputEvent.getModifiersExText(AppPreferences.hotkeyMenuMask)), Strings.S.get("hotkeyOptTitle"), 0);
                this.clearStatus();
                return;
            }
            String checkPass = AppPreferences.hotkeyCheckConflict(this.hotkeyInput.boundKeyStroke.getName(), this.code, this.modifier);
            if (!checkPass.isEmpty()) {
                JOptionPane.showMessageDialog(null, checkPass, Strings.S.get("hotkeyOptTitle"), 0);
                this.clearStatus();
                return;
            }
            this.hotkeyInput.setText("");
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.hotkeyInput.setText(this.hotkeyString);
            this.hotkeyInput.setApplyEnabled(!this.hotkeyString.isEmpty());
            if (!this.hotkeyString.isEmpty()) {
                this.rewriteFlag = true;
            }
        }
    }

    private class KeyboardInputFilter
    extends DocumentFilter {
        private KeyboardInputFilter(JHotkeyInput jHotkeyInput) {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            fb.insertString(offset, text.toUpperCase(), attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            fb.replace(offset, length, text.toUpperCase(), attrs);
        }
    }
}

