/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

public final class FileUtil {
    private FileUtil() {
        throw new IllegalStateException("Utility class. No instantiation allowed.");
    }

    public static String correctPath(String path) {
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    public static File createTmpFile(String content, String prefix, String suffix) throws IOException {
        File tmp = File.createTempFile(prefix, suffix);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(tmp));){
            out.write(content, 0, content.length());
        }
        return tmp;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        byte[] buf;
        int size = 1024;
        if (is instanceof ByteArrayInputStream) {
            size = is.available();
            buf = new byte[size];
            int len = is.read(buf, 0, size);
        } else {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            buf = new byte[size];
            while ((len = is.read(buf, 0, size)) != -1) {
                bos.write(buf, 0, len);
            }
            buf = bos.toByteArray();
        }
        return buf;
    }
}

