/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class Dag {
    private final HashMap<Object, Node> nodes = new HashMap();

    public boolean addEdge(Object srcData, Object dstData) {
        if (!this.canFollow(dstData, srcData)) {
            return false;
        }
        Node src = this.createNode(srcData);
        if (src == null) {
            return false;
        }
        Node dst = this.createNode(dstData);
        if (dst == null) {
            return false;
        }
        if (src.succs.add(dst)) {
            ++dst.numPreds;
        }
        return true;
    }

    private boolean canFollow(Node query, Node base) {
        if (base == query) {
            return false;
        }
        for (Node n : this.nodes.values()) {
            n.mark = false;
        }
        LinkedList<Node> fringe = new LinkedList<Node>();
        fringe.add(query);
        while (!fringe.isEmpty()) {
            Node n;
            n = (Node)fringe.removeFirst();
            for (Node next : n.succs) {
                if (next.mark) continue;
                if (next == base) {
                    return false;
                }
                next.mark = true;
                fringe.addLast(next);
            }
        }
        return true;
    }

    public boolean canFollow(Object query, Object base) {
        if (base == null || query == null) {
            return false;
        }
        Node queryNode = this.findNode(query);
        Node baseNode = this.findNode(base);
        return baseNode == null || queryNode == null ? !query.equals(base) : this.canFollow(queryNode, baseNode);
    }

    private Node createNode(Object data) {
        Node ret = this.findNode(data);
        if (ret != null) {
            return ret;
        }
        if (data == null) {
            return null;
        }
        ret = new Node(data);
        this.nodes.put(data, ret);
        return ret;
    }

    private Node findNode(Object data) {
        if (data == null) {
            return null;
        }
        return this.nodes.get(data);
    }

    public boolean hasPredecessors(Object data) {
        Node from = this.findNode(data);
        return from != null && from.numPreds != 0;
    }

    public boolean hasSuccessors(Object data) {
        Node to = this.findNode(data);
        return to != null && !to.succs.isEmpty();
    }

    public boolean removeEdge(Object srcData, Object dstData) {
        Node src = this.findNode(srcData);
        Node dst = this.findNode(dstData);
        if (src == null || dst == null) {
            return false;
        }
        if (!src.succs.remove(dst)) {
            return false;
        }
        --dst.numPreds;
        if (dst.numPreds == 0 && dst.succs.isEmpty()) {
            this.nodes.remove(dstData);
        }
        if (src.numPreds == 0 && src.succs.isEmpty()) {
            this.nodes.remove(srcData);
        }
        return true;
    }

    public void removeNode(Object data) {
        Node n = this.findNode(data);
        if (n == null) {
            return;
        }
        Iterator<Node> it = n.succs.iterator();
        while (it.hasNext()) {
            Node succ = it.next();
            --succ.numPreds;
            if (succ.numPreds != 0 || !succ.succs.isEmpty()) continue;
            it.remove();
        }
        if (n.numPreds > 0) {
            this.nodes.values().removeIf(q -> q.succs.remove(n) && q.numPreds == 0 && q.succs.isEmpty());
        }
    }

    private static class Node {
        Object data;
        final HashSet<Node> succs = new HashSet();
        int numPreds = 0;
        boolean mark;

        Node(Object data) {
            this.data = data;
        }
    }
}

