/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.TtlRegisterData;

public class Ttl74670
extends AbstractTtlGate {
    public static final String _ID = "74670";
    public static final int DELAY = 1;
    public static final byte D1 = 15;
    public static final byte D2 = 1;
    public static final byte D3 = 2;
    public static final byte D4 = 3;
    public static final byte WA0 = 14;
    public static final byte WA1 = 13;
    public static final byte RA0 = 5;
    public static final byte RA1 = 4;
    public static final byte nWE = 12;
    public static final byte nOE = 11;
    public static final byte Q1 = 10;
    public static final byte Q2 = 9;
    public static final byte Q3 = 7;
    public static final byte Q4 = 6;
    public static final byte GND = 8;
    public static final byte VCC = 16;
    private static final byte[] DATA_OUTPUTS = new byte[]{10, 9, 7, 6};
    private InstanceState _state;
    private TtlRegisterData _data;

    public Ttl74670() {
        super(_ID, (byte)16, DATA_OUTPUTS, new String[]{"D2", "D3", "D4", "RA1", "RA0", "Q4", "Q3", "Q2", "Q1", "nOE", "nWE", "WA1", "WA0", "D1"}, null);
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        super.paintBase(painter, true, false);
        Drawgates.paintPortNames(painter, x, y, height, this.portNames);
    }

    private byte pinNrToPortNr(byte dsPinNr) {
        return (byte)(dsPinNr <= 8 ? dsPinNr - 1 : dsPinNr - 2);
    }

    private Value getPort(byte dsPinNr) {
        return this._state.getPortValue(this.pinNrToPortNr(dsPinNr));
    }

    private void setPort(byte dsPinNr, Value v) {
        this._state.setPort(this.pinNrToPortNr(dsPinNr), v, 1);
    }

    private TtlRegisterData getData() {
        TtlRegisterData data = (TtlRegisterData)this._state.getData();
        if (data == null) {
            data = new TtlRegisterData(BitWidth.create(4), 4);
            this._state.setData(data);
        }
        return data;
    }

    private int getAddress(byte msbPinNr, byte lsbPinNr) {
        return (this.getPort(msbPinNr) == Value.TRUE ? 2 : 0) + (this.getPort(lsbPinNr) == Value.TRUE ? 1 : 0);
    }

    private int getReadAddress() {
        return this.getAddress((byte)4, (byte)5);
    }

    private int getWriteAddress() {
        return this.getAddress((byte)13, (byte)14);
    }

    private boolean isTriggered() {
        return this._data.updateClock(this.getPort((byte)12), this.getWriteAddress(), StdAttr.TRIG_LOW);
    }

    private void propagateWritePort() {
        if (this.isTriggered()) {
            for (int i = 0; i < 4; ++i) {
                this._data.setValue(this.getWriteAddress(), Value.create(new Value[]{this.getPort((byte)15), this.getPort((byte)1), this.getPort((byte)2), this.getPort((byte)3)}));
            }
        }
    }

    private void propagateReadPort() {
        boolean readEnabled = this.getPort((byte)11) == Value.FALSE;
        Value readData = this._data.getValue(this.getReadAddress());
        for (int i = 0; i < 4; ++i) {
            this.setPort(DATA_OUTPUTS[i], readEnabled ? readData.get(i) : Value.UNKNOWN);
        }
    }

    @Override
    public void propagateTtl(InstanceState state) {
        this._state = state;
        this._data = this.getData();
        this.propagateWritePort();
        this.propagateReadPort();
    }
}

