/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.tcl;

import com.cburch.hdl.HdlModel;
import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.hdl.HdlContent;
import com.cburch.logisim.std.hdl.HdlContentEditor;
import com.cburch.logisim.std.hdl.VhdlContentComponent;
import com.cburch.logisim.std.tcl.TclComponentAttributes;
import com.cburch.logisim.std.tcl.TclGeneric;
import com.cburch.logisim.std.tcl.TclVhdlEntityContent;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;

public class TclGenericAttributes
extends TclComponentAttributes {
    private static final List<Attribute<?>> attributes = Arrays.asList(CONTENT_FILE_ATTR, TclGeneric.CONTENT_ATTR, StdAttr.LABEL, StdAttr.LABEL_FONT);
    private static final WeakHashMap<HdlContent, HdlContentEditor> windowRegistry = new WeakHashMap();
    private VhdlContentComponent vhdlEntitiy = TclVhdlEntityContent.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HdlContentEditor getContentEditor(Window source, HdlContent value, Project proj) {
        WeakHashMap<HdlContent, HdlContentEditor> weakHashMap = windowRegistry;
        synchronized (weakHashMap) {
            HdlContentEditor ret = windowRegistry.get(value);
            if (ret == null) {
                ret = source instanceof Frame ? new HdlContentEditor((Frame)source, proj, (HdlModel)value) : new HdlContentEditor((Dialog)source, proj, (HdlModel)value);
                windowRegistry.put(value, ret);
            }
            return ret;
        }
    }

    TclGenericAttributes() {
    }

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        TclGenericAttributes attr = (TclGenericAttributes)dest;
        attr.vhdlEntitiy = this.vhdlEntitiy;
        super.copyInto(dest);
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return attributes;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == TclGeneric.CONTENT_ATTR) {
            return (V)this.vhdlEntitiy;
        }
        return super.getValue(attr);
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        if (attr == TclGeneric.CONTENT_ATTR) {
            VhdlContentComponent newContent = (VhdlContentComponent)value;
            if (!this.vhdlEntitiy.equals(newContent)) {
                this.vhdlEntitiy = newContent;
            }
            this.fireAttributeValueChanged(attr, value, null);
        } else {
            super.setValue(attr, value);
        }
    }
}

