/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.TelnetServer;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.IOException;

public class Telnet
extends InstanceFactory {
    public static final String _ID = "Telnet";
    private static final int IN = 0;
    private static final int OUT = 1;
    private static final int CLK = 2;
    private static final int WR = 3;
    private static final int RD = 4;
    private static final int AVAIL = 5;
    private static final Attribute<Boolean> ATTR_TELNET_MODE = Attributes.forBoolean("telnetMode", Strings.S.getter("telnetModeAttr"));
    private static final Attribute<Integer> ATTR_PORT = Attributes.forIntegerRange("port", Strings.S.getter("telnetPortAttr"), 1, 65535);
    private static final Attribute<Integer> ATTR_BUFFER = Attributes.forIntegerRange("buflen", Strings.S.getter("keybBufferLengthAttr"), 1, 0x1000000);

    public Telnet() {
        super(_ID, Strings.S.getter("telnetComponent"));
        this.setAttributes(new Attribute[]{ATTR_TELNET_MODE, ATTR_PORT, ATTR_BUFFER, StdAttr.EDGE_TRIGGER, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT}, new Object[]{false, 8000, 1024, StdAttr.TRIG_RISING, "", Direction.NORTH, StdAttr.DEFAULT_LABEL_FONT});
        this.setOffsetBounds(Bounds.create(-30, -20, 40, 60));
        this.setIconName("telnet.gif");
        this.setKeyConfigurator(JoinedConfigurator.create(new BitWidthConfigurator(StdAttr.WIDTH), new DirectionConfigurator(StdAttr.LABEL_LOC, 512)));
        Port[] ps = new Port[]{new Port(-30, 10, "input", 8), new Port(10, 10, "output", 8), new Port(-30, 20, "input", 1), new Port(-30, 30, "input", 1), new Port(10, 30, "input", 1), new Port(10, 20, "output", 1)};
        ps[0].setToolTip(Strings.S.getter("telnetInTip"));
        ps[1].setToolTip(Strings.S.getter("telnetOutTip"));
        ps[2].setToolTip(Strings.S.getter("telnetClkTip"));
        ps[3].setToolTip(Strings.S.getter("telnetWriteTip"));
        ps[4].setToolTip(Strings.S.getter("telnetReadTip"));
        ps[5].setToolTip(Strings.S.getter("telnetAvailableTip"));
        this.setPorts(ps);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        painter.drawPort(0, "in", Direction.EAST);
        painter.drawPort(1, "out", Direction.WEST);
        painter.drawClock(2, Direction.EAST);
        painter.drawPort(3, "wr", Direction.EAST);
        painter.drawPort(4, "rd", Direction.WEST);
        painter.drawPort(5, "av", Direction.WEST);
        FontMetrics metric = g.getFontMetrics();
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        Bounds bds = painter.getBounds();
        int x0 = bds.getX() + bds.getWidth() / 2;
        int y0 = bds.getY() + metric.getHeight() + 2;
        GraphicsUtil.drawText(g, _ID, x0, y0, 0, 2);
        g.setFont(g.getFont().deriveFont(g.getFont().getSize2D() * 0.8f));
        GraphicsUtil.drawText(g, painter.getAttributeValue(ATTR_PORT).toString(), x0, y0 + metric.getHeight() - 4, 0, 2);
        g.setColor(painter.getAttributeValue(StdAttr.LABEL_COLOR));
        painter.drawLabel();
    }

    private TelnetServer getData(InstanceState state) {
        TelnetServer data = (TelnetServer)state.getData();
        Integer port = state.getAttributeValue(ATTR_PORT);
        if (data == null || data.getPort() != port.intValue()) {
            try {
                data = TelnetServer.ServerHolder.INSTANCE.getServer(port, state.getAttributeValue(ATTR_BUFFER));
                data.setInstanceState(state);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            state.setData(data);
        } else {
            Integer buffer = state.getAttributeValue(ATTR_BUFFER);
            if (data.getBufferSize() != buffer.intValue()) {
                data.setBufferSize(buffer);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagate(InstanceState circState) {
        TelnetServer state = this.getData(circState);
        Boolean telnetMode = circState.getAttributeValue(ATTR_TELNET_MODE);
        state.setTelnetEscape(telnetMode);
        AttributeOption triggerType = circState.getAttributeValue(StdAttr.TRIGGER);
        Value clock = circState.getPortValue(2);
        Value write = circState.getPortValue(3);
        Value read = circState.getPortValue(4);
        Value in = circState.getPortValue(0);
        TelnetServer telnetServer = state;
        synchronized (telnetServer) {
            Value lastClock = state.setLastClock(clock);
            boolean go = triggerType == StdAttr.TRIG_FALLING ? lastClock == Value.TRUE && clock == Value.FALSE : lastClock == Value.FALSE && clock == Value.TRUE;
            circState.setPort(5, state.hasData() ? Value.TRUE : Value.FALSE, 0);
            if (read == Value.TRUE) {
                circState.setPort(1, Value.createKnown(8, (long)state.getData()), 0);
            } else {
                circState.setPort(1, Value.UNKNOWN, 0);
            }
            if (go) {
                if (write == Value.TRUE) {
                    state.send((int)in.toLongValue());
                }
                if (read == Value.TRUE) {
                    state.deleteOldest();
                }
            }
        }
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        instance.computeLabelTextField(10);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(10);
        }
    }
}

