/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.io.LedArrayGenericHdlGeneratorFactory;
import com.cburch.logisim.std.io.SevenSegment;
import com.cburch.logisim.std.io.SevenSegmentScanningGenericHdlGenerator;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;
import java.util.List;

public class SevenSegmentScanningDecodedHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public static final int NR_OF_SEGMENTS_ID = -1;
    public static final int NR_OF_DIGITS_ID = -2;
    public static final int NR_OF_CONTROL_ID = -3;
    public static final int ACTIVE_LOW_ID = -4;
    public static final int SCANNING_COUNTER_BITS_ID = -5;
    public static final int SCANNING_COUNTER_VALUE_ID = -6;
    public static final String NR_OF_SEGMENTS_STRING = "nrOfSegments";
    public static final String NR_OF_DIGITS_STRING = "nrOfDigits";
    public static final String NR_OF_CONTROL_STRING = "nrOfControl";
    public static final String HDL_IDENTIFIER = "SevenSegmentScanningDecoded";
    public static final String ACTIVE_LOW_STRING = "activeLow";
    public static final String SCANNING_COUNTER_BITS_STRING = "nrOfScanningCounterBits";
    public static final String SCANNING_COUNTER_VALUE_STRING = "scanningCounterReloadValue";

    public SevenSegmentScanningDecodedHdlGeneratorFactory() {
        this.myParametersList.add(NR_OF_SEGMENTS_STRING, -1).add(NR_OF_DIGITS_STRING, -2).add(NR_OF_CONTROL_STRING, -3).add(ACTIVE_LOW_STRING, -4).add(SCANNING_COUNTER_BITS_STRING, -5).add(SCANNING_COUNTER_VALUE_STRING, -6);
        this.myWires.addWire("s_columnCounterNext", -3).addWire("s_scanningCounterNext", -5).addWire("s_tickNext", 1).addRegister("s_columnCounterReg", -3).addRegister("s_scanningCounterReg", -5).addRegister("s_tickReg", 1);
        this.myPorts.add("input", SevenSegmentScanningGenericHdlGenerator.SevenSegmentSegmenInputs, -1, 9).add("output", SevenSegmentScanningGenericHdlGenerator.SevenSegmentControlOutput, -3, 10).add("input", "fpgaGlobalClock", 1, 11);
        int id = 0;
        for (String segName : SevenSegment.getLabels()) {
            this.myPorts.add("output", segName, 1, id++);
        }
    }

    public static LineBuffer getGenericMap(int nrOfRows, int nrOfColumns, long fpgaClockFrequency, boolean activeLow, boolean selectActiveLow) {
        int scanningReload = (int)(fpgaClockFrequency / 1000L);
        int nrOfScanningBitsCount = LedArrayGenericHdlGeneratorFactory.getNrOfBitsRequired(scanningReload);
        HashMap<String, String> generics = new HashMap<String, String>();
        int nrOfControl = SevenSegmentScanningDecodedHdlGeneratorFactory.nrOfControlBits(nrOfRows, nrOfColumns);
        generics.put(NR_OF_SEGMENTS_STRING, Integer.toString(nrOfRows * 8));
        generics.put(NR_OF_DIGITS_STRING, Integer.toString(nrOfRows));
        generics.put(NR_OF_CONTROL_STRING, Integer.toString(nrOfControl));
        generics.put(ACTIVE_LOW_STRING, activeLow ? "1" : "0");
        generics.put(SCANNING_COUNTER_BITS_STRING, Integer.toString(nrOfScanningBitsCount));
        generics.put(SCANNING_COUNTER_VALUE_STRING, Integer.toString(scanningReload - 1));
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(generics, true);
    }

    public static int nrOfControlBits(int nrOfDigits, int nrOfDecodedBits) {
        return Math.max((int)Math.ceil(Math.log(nrOfDigits) / Math.log(2.0)), nrOfDecodedBits);
    }

    public static LineBuffer getPortMap(int id) {
        HashMap<String, String> ports = new HashMap<String, String>();
        ports.put(SevenSegmentScanningGenericHdlGenerator.SevenSegmentSegmenInputs, String.format("s_%s%d", SevenSegmentScanningGenericHdlGenerator.InternalSignalName, id));
        ports.put("fpgaGlobalClock", "fpgaGlobalClock");
        ports.put(SevenSegmentScanningGenericHdlGenerator.SevenSegmentControlOutput, String.format("Displ%dSelect", id));
        for (String segName : SevenSegment.getLabels()) {
            ports.put(segName, String.format("Displ%d_%s", id, segName));
        }
        return LedArrayGenericHdlGeneratorFactory.getGenericPortMapAlligned(ports, false);
    }

    public static List<String> getTickCounterCode() {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("clock", "fpgaGlobalClock").pair("counterBits", SCANNING_COUNTER_BITS_STRING).pair("counterValue", SCANNING_COUNTER_VALUE_STRING).pair("digitReload", NR_OF_DIGITS_STRING).pair("nrControlBits", NR_OF_CONTROL_STRING).pair("nrOfRows", NR_OF_DIGITS_STRING).pair("controlOutput", SevenSegmentScanningGenericHdlGenerator.SevenSegmentControlOutput).pair("seg_a", SevenSegment.getOutputLabel(0)).pair("seg_b", SevenSegment.getOutputLabel(1)).pair("seg_c", SevenSegment.getOutputLabel(2)).pair("seg_d", SevenSegment.getOutputLabel(3)).pair("seg_e", SevenSegment.getOutputLabel(4)).pair("seg_f", SevenSegment.getOutputLabel(5)).pair("seg_g", SevenSegment.getOutputLabel(6)).pair("dp", SevenSegment.getOutputLabel(7)).pair("seg_a_id", 0).pair("seg_b_id", 1).pair("seg_c_id", 2).pair("seg_d_id", 3).pair("seg_e_id", 4).pair("seg_f_id", 5).pair("seg_g_id", 6).pair("dp_id", 7).pair(ACTIVE_LOW_STRING, ACTIVE_LOW_STRING).pair("segmentInputs", SevenSegmentScanningGenericHdlGenerator.SevenSegmentSegmenInputs);
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("s_tickNext <= '1' {{when}} s_scanningCounterReg = std_logic_vector(to_unsigned(0, {{counterBits}})) {{else}} '0';\n\ns_scanningCounterNext <= ({{others}} => '0') {{when}} s_tickReg /= '0' {{and}} s_tickReg /= '1' {{else}} -- for simulation\n                         std_logic_vector(to_unsigned({{counterValue}}-1, {{counterBits}}))\n                            {{when}} s_tickNext = '1' {{else}}\n                         std_logic_vector(unsigned(s_scanningCounterReg)-1);\n\ns_columnCounterNext <= ({{others}} => '0') {{when}} s_tickReg /= '0' {{and}} s_tickReg /= '1' {{else}} -- for simulation\n                       s_columnCounterReg {{when}} s_tickReg = '0' {{else}}\n                       std_logic_vector(to_unsigned({{digitReload}} - 1, {{nrControlBits}}))\n                         {{when}} s_columnCounterReg = std_logic_vector(to_unsigned(0, {{nrControlBits}})) {{else}}\n                       std_logic_vector(unsigned(s_columnCounterReg)-1);\n\nmakeFlops : {{process}} ({{clock}}) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{clock}})) {{then}}\n      s_scanningCounterReg <= s_scanningCounterNext;\n      s_columnCounterReg   <= s_columnCounterNext;\n      s_tickReg            <= s_tickNext;\n   {{end}} {{if}};\n{{end}} {{process}} makeFlops;\n\n{{seg_a}} <= {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_a_id}}) {{when}} {{activeLow}} = 0 {{else}} {{not}} {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_a_id}});\n{{seg_b}} <= {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_b_id}}) {{when}} {{activeLow}} = 0 {{else}} {{not}} {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_b_id}});\n{{seg_c}} <= {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_c_id}}) {{when}} {{activeLow}} = 0 {{else}} {{not}} {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_c_id}});\n{{seg_d}} <= {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_d_id}}) {{when}} {{activeLow}} = 0 {{else}} {{not}} {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_d_id}});\n{{seg_e}} <= {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_e_id}}) {{when}} {{activeLow}} = 0 {{else}} {{not}} {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_e_id}});\n{{seg_f}} <= {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_f_id}}) {{when}} {{activeLow}} = 0 {{else}} {{not}} {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_f_id}});\n{{seg_g}} <= {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_g_id}}) {{when}} {{activeLow}} = 0 {{else}} {{not}} {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{seg_g_id}});\n{{dp}} <= {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{dp_id}}) {{when}} {{activeLow}} = 0 {{else}} {{not}} {{segmentInputs}}(to_integer(unsigned(s_columnCounterReg))*8 + {{dp_id}});\n").empty();
        } else {
            contents.add("\nassign s_tickNext = (s_scanningCounterReg == 0) ? 1'b1 : 1'b0;\nassign s_scanningCounterNext = (s_scanningCounterReg == 0) ? {{counterValue}} : s_scanningCounterReg - 1;\nassign s_columnCounterNext =  (s_tickReg == 1'b0) ? s_columnCounterReg : (s_columnCounterReg == 0) ? {{digitReload}} - 1 : s_columnCounterReg - 1;\n\nassign {{seg_a}} = {{segmentInputs}}[s_columnCounterReg * 8 + {{seg_a_id}}] ^ activeLow;\nassign {{seg_b}} = {{segmentInputs}}[s_columnCounterReg * 8 + {{seg_b_id}}] ^ activeLow;\nassign {{seg_c}} = {{segmentInputs}}[s_columnCounterReg * 8 + {{seg_c_id}}] ^ activeLow;\nassign {{seg_d}} = {{segmentInputs}}[s_columnCounterReg * 8 + {{seg_d_id}}] ^ activeLow;\nassign {{seg_e}} = {{segmentInputs}}[s_columnCounterReg * 8 + {{seg_e_id}}] ^ activeLow;\nassign {{seg_f}} = {{segmentInputs}}[s_columnCounterReg * 8 + {{seg_f_id}}] ^ activeLow;\nassign {{seg_g}} = {{segmentInputs}}[s_columnCounterReg * 8 + {{seg_g_id}}] ^ activeLow;\nassign {{dp}} = {{segmentInputs}}[s_columnCounterReg * 8 + {{dp_id}}] ^ activeLow;\n").addRemarkBlock("Here the simulation only initial is defined").add("initial\nbegin\n   s_scanningCounterReg = 0;\n   s_columnCounterReg   = 0;\n   s_tickReg            = 1'b0;\nend\n\nalways @(posedge {{clock}})\nbegin\n    s_scanningCounterReg = s_scanningCounterNext;\n    s_columnCounterReg   = s_columnCounterNext;\n    s_tickReg            = s_tickNext;\nend\n").empty();
        }
        return contents.get();
    }

    public static List<String> getDecoderCounterCode() {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("controlOutput", SevenSegmentScanningGenericHdlGenerator.SevenSegmentControlOutput);
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("{{controlOutput}} <= s_columnCounterReg;\n\n").empty();
        } else {
            contents.add("assign {{controlOutput}} = s_columnCounterReg;\n\n").empty();
        }
        return contents.get();
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().add(SevenSegmentScanningDecodedHdlGeneratorFactory.getTickCounterCode()).add(SevenSegmentScanningDecodedHdlGeneratorFactory.getDecoderCounterCode());
        return contents;
    }
}

