/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.std.gates.AbstractGate;
import com.cburch.logisim.std.gates.GateAttributes;
import com.cburch.logisim.std.gates.NotGate;
import com.cburch.logisim.std.gates.OrGate;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.HashMap;

public class PainterShaped {
    private static final GeneralPath PATH_NARROW = new GeneralPath();
    private static final GeneralPath PATH_MEDIUM;
    private static final GeneralPath PATH_WIDE;
    private static final GeneralPath SHIELD_NARROW;
    private static final GeneralPath SHIELD_MEDIUM;
    private static final GeneralPath SHIELD_WIDE;
    private static final HashMap<Integer, int[]> INPUT_LENGTHS;

    private static GeneralPath computeShield(int width, int height) {
        GeneralPath base = width < 40 ? SHIELD_NARROW : (width < 60 ? SHIELD_MEDIUM : SHIELD_WIDE);
        if (height <= width) {
            return base;
        }
        int wingHeight = (height - width) / 2;
        int dx = Math.min(20, wingHeight / 4);
        GeneralPath path = new GeneralPath();
        path.moveTo(-width, -height / 2);
        path.quadTo(-width + dx, -(width + height) / 4, -width, -width / 2);
        path.append(base, true);
        path.quadTo(-width + dx, (width + height) / 4, -width, height / 2);
        return path;
    }

    private static int[] getInputLineLengths(GateAttributes attrs, AbstractGate factory) {
        int inputs = attrs.inputs;
        Integer mainHeight = (Integer)attrs.size.getValue();
        Integer key = inputs * 31 + mainHeight;
        int[] ret = INPUT_LENGTHS.get(key);
        if (ret != null) {
            return ret;
        }
        Direction facing = attrs.facing;
        if (facing != Direction.EAST) {
            attrs = (GateAttributes)attrs.clone();
            attrs.facing = Direction.EAST;
        }
        int[] lengths = new int[inputs];
        INPUT_LENGTHS.put(key, lengths);
        Location loc0 = OrGate.FACTORY.getInputOffset(attrs, 0);
        Location locn = OrGate.FACTORY.getInputOffset(attrs, inputs - 1);
        int totalHeight = 10 + loc0.manhattanDistanceTo(locn);
        if (totalHeight < mainHeight) {
            totalHeight = mainHeight;
        }
        GeneralPath path = PainterShaped.computeShield(mainHeight, totalHeight);
        for (int i = 0; i < inputs; ++i) {
            int iters;
            Location loci = OrGate.FACTORY.getInputOffset(attrs, i);
            Point2D.Float p = new Point2D.Float(loci.getX() + 1, loci.getY());
            for (iters = 0; path.contains(p) && iters < 15; ++iters) {
                p.setLocation(p.getX() + 1.0, p.getY());
            }
            if (iters >= 15) {
                iters = 0;
            }
            lengths[i] = iters;
        }
        return lengths;
    }

    static void paintAnd(InstancePainter painter, int width, int height) {
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        int[] xp = new int[]{-width / 2, -width + 1, -width + 1, -width / 2};
        int[] yp = new int[]{-width / 2, -width / 2, width / 2, width / 2};
        GraphicsUtil.drawCenteredArc(g, -width / 2, 0, width / 2, -90, 180);
        g.drawPolyline(xp, yp, 4);
        if (height > width) {
            g.drawLine(-width + 1, -height / 2, -width + 1, height / 2);
        }
    }

    static void paintInputLines(InstancePainter painter, AbstractGate factory) {
        Location loc = painter.getLocation();
        boolean printView = painter.isPrintView();
        GateAttributes attrs = (GateAttributes)painter.getAttributeSet();
        Direction facing = attrs.facing;
        int inputs = attrs.inputs;
        long negated = attrs.negated;
        int[] lengths = PainterShaped.getInputLineLengths(attrs, factory);
        if (painter.getInstance() == null) {
            for (int i = 0; i < inputs; ++i) {
                boolean iNegated;
                boolean bl = iNegated = (negated >> i & 1L) == 1L;
                if (!iNegated) continue;
                Location offs = factory.getInputOffset(attrs, i);
                Location loci = loc.translate(offs.getX(), offs.getY());
                Location cent = loci.translate(facing, lengths[i] + 5);
                painter.drawDongle(cent.getX(), cent.getY());
            }
        } else {
            Graphics g = painter.getGraphics();
            Color baseColor = g.getColor();
            GraphicsUtil.switchToWidth(g, 3);
            for (int i = 0; i < inputs; ++i) {
                Location offs = factory.getInputOffset(attrs, i);
                Location src = loc.translate(offs.getX(), offs.getY());
                int len = lengths[i];
                if (len != 0 && (!printView || painter.isPortConnected(i + 1))) {
                    if (painter.getShowState()) {
                        Value val = painter.getPortValue(i + 1);
                        g.setColor(val.getColor());
                    } else {
                        g.setColor(baseColor);
                    }
                    Location dst = src.translate(facing, len);
                    g.drawLine(src.getX(), src.getY(), dst.getX(), dst.getY());
                }
                if ((negated >> i & 1L) != 1L) continue;
                Location cent = src.translate(facing, lengths[i] + 5);
                g.setColor(baseColor);
                painter.drawDongle(cent.getX(), cent.getY());
                GraphicsUtil.switchToWidth(g, 3);
            }
        }
    }

    static void paintNot(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        if (painter.getAttributeValue(NotGate.ATTR_SIZE) == NotGate.SIZE_NARROW) {
            GraphicsUtil.switchToWidth(g, 2);
            int[] xp = new int[4];
            int[] yp = new int[4];
            xp[0] = -7;
            yp[0] = -1;
            xp[1] = -19;
            yp[1] = -6;
            xp[2] = -19;
            yp[2] = 6;
            xp[3] = -7;
            yp[3] = 1;
            g.drawPolyline(xp, yp, 4);
            g.drawOval(-6, -3, 6, 6);
        } else {
            int[] xp = new int[4];
            int[] yp = new int[4];
            xp[0] = -10;
            yp[0] = 0;
            xp[1] = -29;
            yp[1] = -7;
            xp[2] = -29;
            yp[2] = 7;
            xp[3] = -10;
            yp[3] = 0;
            g.drawPolyline(xp, yp, 4);
            g.drawOval(-9, -4, 9, 9);
        }
    }

    static void paintOr(InstancePainter painter, int width, int height) {
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        GeneralPath path = width < 40 ? PATH_NARROW : (width < 60 ? PATH_MEDIUM : PATH_WIDE);
        ((Graphics2D)g).draw(path);
        if (height > width) {
            PainterShaped.paintShield(g, 0, width, height);
        }
    }

    private static void paintShield(Graphics g, int xlate, int width, int height) {
        GraphicsUtil.switchToWidth(g, 2);
        g.translate(xlate, 0);
        ((Graphics2D)g).draw(PainterShaped.computeShield(width, height));
        g.translate(-xlate, 0);
    }

    static void paintXor(InstancePainter painter, int width, int height) {
        Graphics g = painter.getGraphics();
        PainterShaped.paintOr(painter, width - 10, width - 10);
        PainterShaped.paintShield(g, -10, width - 10, height);
    }

    private PainterShaped() {
    }

    static {
        PATH_NARROW.moveTo(0.0f, 0.0f);
        PATH_NARROW.quadTo(-10.0f, -15.0f, -30.0f, -15.0f);
        PATH_NARROW.quadTo(-22.0f, 0.0f, -30.0f, 15.0f);
        PATH_NARROW.quadTo(-10.0f, 15.0f, 0.0f, 0.0f);
        PATH_NARROW.closePath();
        PATH_MEDIUM = new GeneralPath();
        PATH_MEDIUM.moveTo(0.0f, 0.0f);
        PATH_MEDIUM.quadTo(-20.0f, -25.0f, -50.0f, -25.0f);
        PATH_MEDIUM.quadTo(-37.0f, 0.0f, -50.0f, 25.0f);
        PATH_MEDIUM.quadTo(-20.0f, 25.0f, 0.0f, 0.0f);
        PATH_MEDIUM.closePath();
        PATH_WIDE = new GeneralPath();
        PATH_WIDE.moveTo(0.0f, 0.0f);
        PATH_WIDE.quadTo(-25.0f, -35.0f, -70.0f, -35.0f);
        PATH_WIDE.quadTo(-50.0f, 0.0f, -70.0f, 35.0f);
        PATH_WIDE.quadTo(-25.0f, 35.0f, 0.0f, 0.0f);
        PATH_WIDE.closePath();
        SHIELD_NARROW = new GeneralPath();
        SHIELD_NARROW.moveTo(-30.0f, -15.0f);
        SHIELD_NARROW.quadTo(-22.0f, 0.0f, -30.0f, 15.0f);
        SHIELD_MEDIUM = new GeneralPath();
        SHIELD_MEDIUM.moveTo(-50.0f, -25.0f);
        SHIELD_MEDIUM.quadTo(-37.0f, 0.0f, -50.0f, 25.0f);
        SHIELD_WIDE = new GeneralPath();
        SHIELD_WIDE.moveTo(-70.0f, -35.0f);
        SHIELD_WIDE.quadTo(-50.0f, 0.0f, -70.0f, 35.0f);
        INPUT_LENGTHS = new HashMap();
    }
}

