/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.std.Strings;
import java.awt.Component;

public class NegateAttribute
extends Attribute<Boolean> {
    private static final Attribute<Boolean> BOOLEAN_ATTR = Attributes.forBoolean("negateDummy");
    final int index;
    private final Direction side;

    public NegateAttribute(int index, Direction side) {
        super("negate" + index, null);
        this.index = index;
        this.side = side;
    }

    public boolean equals(Object other) {
        boolean bl;
        if (other instanceof NegateAttribute) {
            NegateAttribute o = (NegateAttribute)other;
            bl = this.index == o.index && this.side == o.side;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public Component getCellEditor(Boolean value) {
        return BOOLEAN_ATTR.getCellEditor(null, value);
    }

    @Override
    public String getDisplayName() {
        Object ret = Strings.S.get("gateNegateAttr", "" + (this.index + 1));
        if (this.side != null) {
            ret = (String)ret + " (" + this.side.toVerticalDisplayString() + ")";
        }
        return ret;
    }

    public int hashCode() {
        return this.index * 31 + (this.side == null ? 0 : this.side.hashCode());
    }

    @Override
    public Boolean parse(String value) {
        return BOOLEAN_ATTR.parse(value);
    }

    @Override
    public String toDisplayString(Boolean value) {
        return BOOLEAN_ATTR.toDisplayString(value);
    }
}

