/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.gates.GateAttributes;
import com.cburch.logisim.std.gates.NegateAttribute;
import com.cburch.logisim.util.LineBuffer;

public class AbstractGateHdlGenerator
extends AbstractHdlGeneratorFactory {
    private static final int BIT_WIDTH_GENERIC = -1;
    private static final String BIT_WIDTH_STRING = "NrOfBits";
    private static final int BUBBLES_GENERIC = -2;
    private static final String BUBBLES_MASK = "BubblesMask";

    public AbstractGateHdlGenerator() {
        this.myParametersList.addBusOnly(BIT_WIDTH_STRING, -1).addVector(BUBBLES_MASK, -2, 7, new Object[0]);
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        if (!attrs.containsAttribute(GateAttributes.ATTR_INPUTS)) {
            return;
        }
        Integer nrOfInputs = attrs.getValue(GateAttributes.ATTR_INPUTS);
        int bitWidth = attrs.getValue(StdAttr.WIDTH).getWidth();
        for (int input = 1; input <= nrOfInputs; ++input) {
            this.myWires.addWire(String.format("s_realInput%d", input), bitWidth == 1 ? 1 : -1);
            boolean floatingToZero = this.getFloatingValue(attrs.getValue(new NegateAttribute(input - 1, null)));
            this.myPorts.add("input", String.format("input%d", input), bitWidth == 1 ? 1 : -1, input, floatingToZero);
        }
        this.myPorts.add("output", "result", -1, 0, StdAttr.WIDTH);
    }

    public boolean getFloatingValue(boolean isInverted) {
        return !isInverted;
    }

    public LineBuffer getLogicFunction(int nrOfInputs, int bitwidth, boolean isOneHot) {
        return LineBuffer.getHdlBuffer();
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist nets, AttributeSet attrs) {
        int nrOfInputs;
        LineBuffer contents = LineBuffer.getHdlBuffer();
        int bitWidth = attrs.getValue(StdAttr.WIDTH).getWidth();
        int n = nrOfInputs = attrs.containsAttribute(GateAttributes.ATTR_INPUTS) ? attrs.getValue(GateAttributes.ATTR_INPUTS) : 1;
        if (nrOfInputs > 1) {
            contents.empty();
            contents.addRemarkBlock("Here the bubbles are processed");
            for (int i = 0; i < nrOfInputs; ++i) {
                if (Hdl.isVhdl()) {
                    contents.addVhdlKeywords().add("s_realInput{{1}} <= input{{1}} {{when}} {{2}}{{<}}{{3}}{{>}} = '0' {{else}} {{not}}(input{{1}});", i + 1, BUBBLES_MASK, i);
                    continue;
                }
                contents.add("{{assign}} s_realInput{{1}} = ({{2}}{{<}}{{3}}{{>}} == 1'b0) ? input{{1}} : ~input{{1}};", i + 1, BUBBLES_MASK, i);
            }
        }
        contents.empty().addRemarkBlock("Here the functionality is defined");
        boolean onehot = false;
        if (attrs.containsAttribute(GateAttributes.ATTR_XOR)) {
            onehot = attrs.getValue(GateAttributes.ATTR_XOR) == GateAttributes.XOR_ONE;
        }
        contents.add(this.getLogicFunction(nrOfInputs, bitWidth, onehot));
        return contents.empty();
    }

    public LineBuffer getOneHot(boolean inverted, int nrOfInputs, boolean isBus) {
        LineBuffer lines = LineBuffer.getHdlBuffer();
        Object spaces = "";
        String indexString = "";
        if (isBus) {
            if (Hdl.isVhdl()) {
                lines.addVhdlKeywords().add((String)spaces + "genBits : {{for}} n {{in}} (NrOfBits-1) {{downto}} 0 {{generate}}");
                spaces = (String)spaces + "   ";
                indexString = "(n)";
            } else {
                lines.add("genvar n;");
                lines.add("generate");
                lines.add("   for (n = 0 ; n < NrOfBits ; n = n + 1)");
                lines.add("      begin: bit");
                spaces = (String)spaces + "      ";
                indexString = "[n]";
            }
        }
        StringBuilder oneLine = new StringBuilder();
        oneLine.append((String)spaces).append(Hdl.assignPreamble()).append("result").append(indexString).append(Hdl.assignOperator());
        if (inverted) {
            oneLine.append(Hdl.notOperator()).append("(");
        }
        int spacesLen = oneLine.length();
        for (int termloop = 0; termloop < nrOfInputs; ++termloop) {
            while (oneLine.length() < spacesLen) {
                oneLine.append(" ");
            }
            oneLine.append("(");
            for (int i = 0; i < nrOfInputs; ++i) {
                if (i == termloop) {
                    oneLine.append("s_realInput").append(i + 1).append(indexString);
                } else {
                    oneLine.append(Hdl.notOperator()).append("(s_realInput").append(i + 1).append(indexString).append(")");
                }
                if (i >= nrOfInputs - 1) continue;
                oneLine.append(Hdl.andOperator());
            }
            oneLine.append(")");
            if (termloop < nrOfInputs - 1) {
                oneLine.append(Hdl.orOperator());
            } else {
                if (inverted) {
                    oneLine.append(")");
                }
                oneLine.append(";");
            }
            lines.add(oneLine.toString());
            oneLine.setLength(0);
        }
        if (isBus) {
            if (Hdl.isVhdl()) {
                lines.add("{{end}} {{generate}} GenBits;");
            } else {
                lines.add("      end");
                lines.add("endgenerate");
            }
        }
        return lines.empty();
    }

    public static LineBuffer getParity(boolean inverted, int nrOfInputs, boolean isBus) {
        LineBuffer lines = LineBuffer.getHdlBuffer();
        Object spaces = "   ";
        String indexString = "";
        if (isBus) {
            if (Hdl.isVhdl()) {
                lines.addVhdlKeywords().add((String)spaces + "genBits : {{for}} n {{in}} (NrOfBits-1) {{downto}} 0 {{generate}}");
                spaces = (String)spaces + "   ";
                indexString = "(n)";
            } else {
                lines.add("genvar n;");
                lines.add("generate");
                lines.add("   for (n = 0 ; n < NrOfBits ; n = n + 1)");
                lines.add("      begin: bit");
                spaces = (String)spaces + "      ";
                indexString = "[n]";
            }
        }
        StringBuilder oneLine = new StringBuilder();
        oneLine.append((String)spaces).append(Hdl.assignPreamble()).append("result").append(indexString).append(Hdl.assignOperator());
        if (inverted) {
            oneLine.append(Hdl.notOperator()).append("(");
        }
        int spacesLen = oneLine.length();
        for (int i = 0; i < nrOfInputs; ++i) {
            while (oneLine.length() < spacesLen) {
                oneLine.append(" ");
            }
            oneLine.append("s_realInput").append(i + 1).append(indexString);
            if (i < nrOfInputs - 1) {
                oneLine.append(Hdl.xorOperator());
            } else {
                if (inverted) {
                    oneLine.append(")");
                }
                oneLine.append(";");
            }
            lines.add(oneLine.toString());
            oneLine.setLength(0);
        }
        if (isBus) {
            if (Hdl.isVhdl()) {
                lines.add("{{end}} {{generate}} genBits;");
            } else {
                lines.add("      end");
                lines.add("endgenerate");
            }
        }
        return lines.empty();
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        boolean supported = true;
        if (attrs.containsAttribute(GateAttributes.ATTR_OUTPUT)) {
            supported = attrs.getValue(GateAttributes.ATTR_OUTPUT).equals(GateAttributes.OUTPUT_01);
        }
        return supported;
    }
}

