/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.bfh;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.bfh.BinToBcdHdlGeneratorFactory;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import java.awt.Color;
import java.awt.Graphics;

public class BinToBcd
extends InstanceFactory {
    public static final String _ID = "Binary_to_BCD_converter";
    public static final int PER_DELAY = 1;
    private static final int BINin = 0;
    private static final int InnerDistance = 60;
    public static final Attribute<BitWidth> ATTR_BinBits = Attributes.forBitWidth("binvalue", Strings.S.getter("BinaryDataBits"), 4, 13);

    public BinToBcd() {
        super(_ID, Strings.S.getter("Bin2BCD"), new BinToBcdHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{ATTR_BinBits}, new Object[]{BitWidth.create(9)});
        this.setKeyConfigurator(new BitWidthConfigurator(ATTR_BinBits, 4, 13, 0));
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics gfx = painter.getGraphics();
        BitWidth nrOfBits = painter.getAttributeValue(ATTR_BinBits);
        int nrOfPorts = (int)(Math.log10(Math.pow(2.0, nrOfBits.getWidth())) + 1.0);
        gfx.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.getGraphics().setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        painter.drawPort(0, "Bin", Direction.EAST);
        for (int i = nrOfPorts; i > 0; --i) {
            painter.drawPort(nrOfPorts - i + 1, Integer.toString((int)Math.pow(10.0, nrOfPorts - i)), Direction.NORTH);
        }
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == ATTR_BinBits) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        }
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        BitWidth nrOfBits = attrs.getValue(ATTR_BinBits);
        int nrOfPorts = (int)(Math.log10(1 << nrOfBits.getWidth()) + 1.0);
        return Bounds.create(-30, -20, nrOfPorts * 60, 40);
    }

    @Override
    public void propagate(InstanceState state) {
        int nrOfPorts;
        int binValue = state.getPortValue(0).isFullyDefined() & !state.getPortValue(0).isUnknown() & !state.getPortValue(0).isErrorValue() ? (int)state.getPortValue(0).toLongValue() : -1;
        BitWidth nrOfBits = state.getAttributeValue(ATTR_BinBits);
        for (int i = nrOfPorts = (int)(Math.log10(Math.pow(2.0, nrOfBits.getWidth())) + 1.0); i > 0; --i) {
            int value = (int)Math.pow(10.0, i - 1);
            int number = binValue / value;
            state.setPort(i, Value.createKnown(BitWidth.create(4), (long)number), 1);
            binValue -= number * value;
        }
    }

    private void updatePorts(Instance instance) {
        BitWidth nrOfbits = instance.getAttributeValue(ATTR_BinBits);
        int nrOfPorts = (int)(Math.log10(1 << nrOfbits.getWidth()) + 1.0);
        Port[] ps = new Port[nrOfPorts + 1];
        ps[0] = new Port(-30, 0, "input", ATTR_BinBits);
        ps[0].setToolTip(Strings.S.getter("BinaryInputTip"));
        for (int i = nrOfPorts; i > 0; --i) {
            ps[i] = new Port((nrOfPorts - i) * 60, -20, "output", 4);
            int value = (int)Math.pow(10.0, i - 1);
            ps[i].setToolTip(Strings.S.getter(Integer.toString(value)));
        }
        instance.setPorts(ps);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        StringBuilder completeName = new StringBuilder();
        BitWidth nrofbits = attrs.getValue(ATTR_BinBits);
        int nrOfPorts = (int)(Math.log10(1 << nrofbits.getWidth()) + 1.0);
        completeName.append(CorrectLabel.getCorrectLabel(this.getName()));
        completeName.append("_").append(nrOfPorts).append("_bcd_ports");
        return completeName.toString();
    }
}

