/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.vga;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceStateImpl;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.soc.data.SocBusMasterInterface;
import com.cburch.logisim.soc.data.SocBusSlaveInterface;
import com.cburch.logisim.soc.data.SocBusSlaveListener;
import com.cburch.logisim.soc.data.SocBusSnifferInterface;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.vga.SocVga;
import com.cburch.logisim.soc.vga.VgaAttributes;
import com.cburch.logisim.util.StringUtil;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class VgaState
implements SocBusSlaveInterface,
SocBusSnifferInterface,
SocBusMasterInterface {
    public static final int TOP_MARGIN = 20;
    public static final int BOTTOM_MARGIN = 20;
    public static final int LEFT_MARGIN = 5;
    public static final int RIGHT_MARGIN = 5;
    private Integer startAddress = 0;
    private Integer vgaBufferAddress = 0;
    private int displayMode = 0;
    private final SocBusInfo attachedBus = new SocBusInfo("");
    private String label = "";
    private Boolean soft160x120 = true;
    private Boolean soft320x240 = true;
    private Boolean soft640x480 = true;
    private Boolean soft800x600 = false;
    private Boolean soft1024x768 = false;
    private final ArrayList<SocBusSlaveListener> listeners = new ArrayList();

    public AttributeOption getInitialMode() {
        return VgaAttributes.MODES.get(this.displayMode);
    }

    public AttributeOption getCurrentMode() {
        VgaDisplayState data = this.getRegCurrentState();
        int mode = data == null ? this.displayMode : data.getMode();
        return VgaAttributes.MODES.get(mode);
    }

    public Integer getVgaBufferStartAddress() {
        return this.vgaBufferAddress;
    }

    public String getLabel() {
        return this.label;
    }

    public SocBusInfo getBusInfo() {
        return this.attachedBus;
    }

    public Boolean getSoft160x120() {
        return this.soft160x120;
    }

    public Boolean getSoft320x240() {
        return this.soft320x240;
    }

    public Boolean getSoft640x480() {
        return this.soft640x480;
    }

    public Boolean getSoft800x600() {
        return this.soft800x600;
    }

    public Boolean getSoft1024x768() {
        return this.soft1024x768;
    }

    public boolean setStartAddress(Integer value) {
        if (this.startAddress == value) {
            return false;
        }
        this.startAddress = value;
        this.firememMapChanged();
        return true;
    }

    public boolean setInitialMode(AttributeOption value) {
        int mode;
        int n = mode = VgaAttributes.MODES.contains(value) ? VgaAttributes.MODES.indexOf(value) : 0;
        if (this.displayMode == mode) {
            return false;
        }
        this.displayMode = mode;
        VgaDisplayState data = this.getRegCurrentState();
        if (data != null && data.sizeChanged(true)) {
            InstanceComponent comp = (InstanceComponent)this.attachedBus.getComponent();
            ((SocVga)comp.getFactory()).setTextField(comp.getInstance());
            comp.getInstance().fireInvalidated();
        }
        return true;
    }

    public boolean setVgaBufferStartAddress(Integer value) {
        if (value == this.vgaBufferAddress) {
            return false;
        }
        this.vgaBufferAddress = value;
        VgaDisplayState data = this.getRegCurrentState();
        if (data != null) {
            data.clear();
        }
        return true;
    }

    public boolean setLabel(String l) {
        if (this.label.equals(l)) {
            return false;
        }
        this.label = l;
        this.fireNameChanged();
        return true;
    }

    public boolean setBusInfo(SocBusInfo bus) {
        if (bus.getBusId().equals(this.attachedBus.getBusId())) {
            return false;
        }
        this.attachedBus.setBusId(bus.getBusId());
        VgaDisplayState data = this.getRegCurrentState();
        if (data != null) {
            data.clear();
        }
        return true;
    }

    public boolean setSoft160x120(Boolean b) {
        if (this.soft160x120 == b) {
            return false;
        }
        this.soft160x120 = b;
        return true;
    }

    public boolean setSoft320x240(Boolean b) {
        if (this.soft320x240 == b) {
            return false;
        }
        this.soft320x240 = b;
        return true;
    }

    public boolean setSoft640x480(Boolean b) {
        if (this.soft640x480 == b) {
            return false;
        }
        this.soft640x480 = b;
        return true;
    }

    public boolean setSoft800x600(Boolean b) {
        if (this.soft800x600 == b) {
            return false;
        }
        this.soft800x600 = b;
        return true;
    }

    public boolean setSoft1024x768(Boolean b) {
        if (this.soft1024x768 == b) {
            return false;
        }
        this.soft1024x768 = b;
        return true;
    }

    public void copyInto(VgaState dest) {
        dest.setStartAddress(this.getStartAddress());
        dest.setInitialMode(this.getInitialMode());
        dest.soft160x120 = this.soft160x120;
        dest.soft320x240 = this.soft320x240;
        dest.soft640x480 = this.soft640x480;
        dest.soft800x600 = this.soft800x600;
        dest.soft1024x768 = this.soft1024x768;
        dest.setVgaBufferStartAddress(this.getVgaBufferStartAddress());
        dest.setLabel(this.getLabel());
        dest.setBusInfo(this.getBusInfo());
    }

    public static Bounds getSize(int mode) {
        return switch (mode) {
            case 1 -> Bounds.create(0, 0, 330, 280);
            case 2 -> Bounds.create(0, 0, 650, 520);
            case 3 -> Bounds.create(0, 0, 810, 640);
            case 4 -> Bounds.create(0, 0, 1034, 808);
            default -> Bounds.create(0, 0, 170, 160);
        };
    }

    public VgaDisplayState getNewState() {
        return new VgaDisplayState();
    }

    public VgaDisplayState getRegCurrentState() {
        InstanceComponent comp = (InstanceComponent)this.attachedBus.getComponent();
        if (comp == null) {
            return null;
        }
        InstanceStateImpl state = comp.getInstanceStateImpl();
        if (state == null) {
            return null;
        }
        return (VgaDisplayState)state.getProject().getCircuitState().getData(comp);
    }

    public VgaDisplayState getRegPropagateState() {
        return (VgaDisplayState)this.attachedBus.getSocSimulationManager().getdata(this.attachedBus.getComponent());
    }

    @Override
    public void initializeTransaction(SocBusTransaction trans, String busId, CircuitState cState) {
        if (this.attachedBus.getSocSimulationManager() == null) {
            return;
        }
        this.attachedBus.getSocSimulationManager().initializeTransaction(trans, busId, cState);
    }

    @Override
    public void sniffTransaction(SocBusTransaction trans) {
        if (!trans.isWriteTransaction()) {
            return;
        }
        long start = SocSupport.convUnsignedInt(this.vgaBufferAddress);
        VgaDisplayState state = this.getRegPropagateState();
        if (state == null) {
            return;
        }
        long end = start + (long)(state.getDataSize() * 4);
        long addr = SocSupport.convUnsignedInt(trans.getAddress());
        if (addr >= start && addr < end) {
            int index = SocSupport.convUnsignedLong(addr - start) >> 2;
            state.myImage.setRGB(index % state.lineSize, index / state.lineSize, trans.getWriteData());
        }
    }

    @Override
    public boolean canHandleTransaction(SocBusTransaction trans) {
        long addr = SocSupport.convUnsignedInt(trans.getAddress());
        long start = SocSupport.convUnsignedInt(this.startAddress);
        long end = this.startAddress + 4;
        return addr >= start && addr < end;
    }

    @Override
    public void handleTransaction(SocBusTransaction trans) {
        if (!this.canHandleTransaction(trans)) {
            return;
        }
        trans.setTransactionResponder(this.attachedBus.getComponent());
        if (trans.getAccessType() != 3) {
            trans.setError(7);
            return;
        }
        if (trans.isReadTransaction()) {
            int data = 0;
            if (this.soft160x120.booleanValue()) {
                data |= 1;
            }
            if (this.soft320x240.booleanValue()) {
                data |= 2;
            }
            if (this.soft640x480.booleanValue()) {
                data |= 4;
            }
            if (this.soft800x600.booleanValue()) {
                data |= 8;
            }
            if (this.soft1024x768.booleanValue()) {
                data |= 0x10;
            }
            trans.setReadData(data);
        }
        if (trans.isWriteTransaction()) {
            VgaDisplayState disp;
            int mode = this.displayMode;
            int data = trans.getWriteData();
            if (data == 1 && this.soft160x120.booleanValue()) {
                mode = 0;
            }
            if (data == 2 && this.soft320x240.booleanValue()) {
                mode = 1;
            }
            if (data == 4 && this.soft640x480.booleanValue()) {
                mode = 2;
            }
            if (data == 8 && this.soft800x600.booleanValue()) {
                mode = 3;
            }
            if (data == 16 && this.soft1024x768.booleanValue()) {
                mode = 4;
            }
            if ((disp = this.getRegPropagateState()) != null && disp.setSoftMode(mode)) {
                InstanceComponent comp = (InstanceComponent)this.attachedBus.getComponent();
                ((SocVga)comp.getFactory()).setTextField(comp.getInstance());
                comp.getInstance().fireInvalidated();
            }
        }
    }

    @Override
    public Integer getStartAddress() {
        return this.startAddress;
    }

    @Override
    public Integer getMemorySize() {
        return 4;
    }

    @Override
    public String getName() {
        Object name = this.label;
        if (StringUtil.isNullOrEmpty((CharSequence)name)) {
            Location loc = this.attachedBus.getComponent().getLocation();
            name = this.attachedBus.getComponent().getFactory().getDisplayName() + "@" + loc.getX() + "," + loc.getY();
        }
        return name;
    }

    @Override
    public void registerListener(SocBusSlaveListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeListener(SocBusSlaveListener l) {
        this.listeners.remove(l);
    }

    @Override
    public InstanceComponent getComponent() {
        return (InstanceComponent)this.attachedBus.getComponent();
    }

    private void fireNameChanged() {
        for (SocBusSlaveListener l : this.listeners) {
            l.labelChanged();
        }
    }

    private void firememMapChanged() {
        for (SocBusSlaveListener l : this.listeners) {
            l.memoryMapChanged();
        }
    }

    public class VgaDisplayState
    implements InstanceData,
    Cloneable {
        private int mode;
        private int lineSize;
        private int nrOfLines;
        private boolean modeSetBySoftware = false;
        private BufferedImage myImage;
        private boolean reload = true;

        public VgaDisplayState() {
            this.mode = VgaState.this.displayMode;
            this.sizeChanged(true);
        }

        public int getMode() {
            if (this.modeSetBySoftware) {
                return this.mode;
            }
            return VgaState.this.displayMode;
        }

        public boolean setSoftMode(int softMode) {
            this.modeSetBySoftware = true;
            if (softMode != this.mode) {
                this.mode = softMode;
                return this.sizeChanged(false);
            }
            return false;
        }

        public BufferedImage getImage(CircuitState cState) {
            this.loadImage(cState);
            return this.myImage;
        }

        public boolean sizeChanged(boolean initialSize) {
            if (initialSize && this.modeSetBySoftware) {
                return false;
            }
            this.clear();
            switch (this.getMode()) {
                case 0: {
                    this.lineSize = 160;
                    this.nrOfLines = 120;
                    break;
                }
                case 1: {
                    this.lineSize = 320;
                    this.nrOfLines = 240;
                    break;
                }
                case 2: {
                    this.lineSize = 640;
                    this.nrOfLines = 480;
                    break;
                }
                case 3: {
                    this.lineSize = 800;
                    this.nrOfLines = 600;
                    break;
                }
                case 4: {
                    this.lineSize = 1024;
                    this.nrOfLines = 768;
                }
            }
            this.myImage = new BufferedImage(this.lineSize, this.nrOfLines, 1);
            return true;
        }

        public int getDataSize() {
            if (this.myImage == null) {
                return 0;
            }
            return this.myImage.getHeight() * this.myImage.getWidth();
        }

        public void clear() {
            this.reload = true;
        }

        @Override
        public VgaDisplayState clone() {
            try {
                return (VgaDisplayState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        private void loadImage(CircuitState cState) {
            if (this.reload) {
                for (int line = 0; line < this.nrOfLines; ++line) {
                    for (int pixel = 0; pixel < this.lineSize; ++pixel) {
                        int index = line * this.lineSize + pixel;
                        SocBusTransaction trans = new SocBusTransaction(1, VgaState.this.vgaBufferAddress + index * 4, 0, 3, "vgadma");
                        trans.setAsHiddenTransaction();
                        VgaState.this.initializeTransaction(trans, VgaState.this.attachedBus.getBusId(), cState);
                        int data = trans.hasError() ? 0 : trans.getReadData();
                        this.myImage.setRGB(pixel, line, data);
                    }
                }
                this.reload = false;
            }
        }

        public void paint(Graphics g, CircuitState cState) {
            this.loadImage(cState);
            g.drawImage(this.myImage, 5, 20, null);
        }
    }
}

