/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.vga;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.vga.VgaState;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SocVgaShape
extends DynamicElement {
    public SocVgaShape(int x, int y, DynamicElement.Path p) {
        super(p, Bounds.create(x, y, 160, 120));
    }

    public void setBounds(int width, int height) {
        this.bounds = Bounds.create(this.bounds.getX(), this.bounds.getY(), width, height);
    }

    @Override
    public void paintDynamic(Graphics g, CircuitState state) {
        VgaState.VgaDisplayState data;
        VgaState.VgaDisplayState vgaDisplayState = data = state == null ? null : (VgaState.VgaDisplayState)this.getData(state);
        if (state == null || data == null) {
            Color c = g.getColor();
            g.setColor(Color.BLUE);
            g.fillRect(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
            g.setColor(Color.YELLOW);
            GraphicsUtil.drawCenteredText(g, "VGA", this.bounds.getCenterX(), this.bounds.getCenterY());
            g.setColor(c);
        } else {
            BufferedImage image = data.getImage(state);
            g.drawImage(image, this.bounds.getX(), this.bounds.getY(), null);
        }
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return UnmodifiableList.create(new Attribute[]{ATTR_LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR});
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("SocVgaComponent");
    }

    @Override
    public Element toSvgElement(Document doc) {
        return this.toSvgElement(doc.createElement("visible-vga"));
    }
}

